/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.TreeMap;
import org.archive.util.IoUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KeyMetadataMaker {
    KeyMetadataMaker() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void makeDefaultLocale(File srcDir, File resDir, Class c) {
        Map<String, String> fields;
        String cpath = c.getName().replace('.', '/');
        File dest = new File(resDir, cpath + "_en.utf8");
        if (dest.exists()) {
            return;
        }
        File src = new File(srcDir, cpath + ".java");
        if (!src.exists()) {
            System.err.println("Warning: No such file " + src.getAbsolutePath());
            System.err.println("Aborting.");
            return;
        }
        try {
            fields = KeyMetadataMaker.parseSourceFile(src);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        if (fields.isEmpty()) {
            return;
        }
        System.out.println("Writing key field metadata to " + dest.getAbsolutePath());
        OutputStreamWriter osw = null;
        try {
            osw = new OutputStreamWriter((OutputStream)new FileOutputStream(dest), "UTF-8");
            for (Map.Entry<String, String> me : fields.entrySet()) {
                osw.write(me.getKey() + "-description:\n");
                osw.write(me.getValue() + "\n\n");
            }
            IoUtils.close(osw);
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            IoUtils.close(osw);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map<String, String> parseSourceFile(File src) throws IOException {
        FileReader fr = new FileReader(src);
        BufferedReader br = new BufferedReader(fr);
        try {
            Map<String, String> map = KeyMetadataMaker.parseSourceFile(br);
            return map;
        }
        finally {
            IoUtils.close(br);
        }
    }

    static Map<String, String> parseSourceFile(BufferedReader br) throws IOException {
        String mostRecentJavaDoc = null;
        TreeMap<String, String> fields = new TreeMap<String, String>();
        StringBuffer javaDoc = null;
        String line = br.readLine();
        while (line != null) {
            if ((line = line.trim()).startsWith("/**")) {
                mostRecentJavaDoc = null;
                javaDoc = new StringBuffer(line).append('\n');
                if (line.endsWith("*/")) {
                    mostRecentJavaDoc = javaDoc.toString();
                    javaDoc = null;
                }
            } else {
                String keyFieldName;
                if (line.endsWith("*/") && javaDoc != null) {
                    javaDoc.append(line);
                    mostRecentJavaDoc = javaDoc.toString();
                    javaDoc = null;
                }
                if ((keyFieldName = KeyMetadataMaker.getKeyFieldName(line)) != null) {
                    if (mostRecentJavaDoc != null) {
                        String key = keyFieldName.toLowerCase().replace('_', '-');
                        String value = KeyMetadataMaker.unformatJavaDoc(mostRecentJavaDoc);
                        fields.put(key, value);
                        mostRecentJavaDoc = null;
                    }
                } else if (javaDoc != null) {
                    javaDoc.append(line).append('\n');
                }
            }
            line = br.readLine();
        }
        return fields;
    }

    private static String getKeyFieldName(String line) {
        if (!line.contains("static")) {
            return null;
        }
        if (!line.contains("public")) {
            return null;
        }
        int start = line.indexOf("Key<");
        if (start < 0) {
            return null;
        }
        int end = line.indexOf(62, start);
        if (end < 0) {
            return null;
        }
        int equals = line.indexOf(61, end);
        if (equals < 0) {
            return null;
        }
        return line.substring(end + 1, equals).trim();
    }

    private static String unformatJavaDoc(String javaDoc) {
        if (javaDoc.endsWith("\n")) {
            javaDoc = javaDoc.substring(0, javaDoc.length() - 1);
        }
        javaDoc = javaDoc.substring(3, javaDoc.length() - 2);
        String[] lines = javaDoc.split("\n");
        StringBuffer result = new StringBuffer();
        for (String line : lines) {
            if ((line = line.trim()).startsWith("*")) {
                line = line.substring(1).trim();
            }
            if (line.length() <= 0) continue;
            result.append(line).append(" \n");
        }
        return result.toString();
    }
}

