/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.archive.state.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyTypes {
    private static final Map<Class<?>, String> TYPES;
    private static final Map<String, Class<?>> TAGS;
    public static final String ENUM_TAG = "enum";

    private KeyTypes() {
    }

    public static boolean isSimple(Class<?> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return true;
        }
        return TYPES.keySet().contains(type);
    }

    public static String getSimpleTypeTag(Class<?> type) {
        if (Enum.class.isAssignableFrom(type)) {
            return ENUM_TAG;
        }
        return TYPES.get(type);
    }

    public static Class<?> getSimpleType(String tag) {
        return TAGS.get(tag);
    }

    private static Object fromString2(Class<?> type, String value) {
        if (type == Enum.class) {
            return KeyTypes.parseEnum(value);
        }
        if (type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Byte.class) {
            return Byte.decode(value);
        }
        if (type == Character.class) {
            return Character.valueOf(value.charAt(0));
        }
        if (type == Double.class) {
            return Double.parseDouble(value);
        }
        if (type == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (type == Integer.class) {
            return Integer.decode(value);
        }
        if (type == Long.class) {
            return Long.decode(value);
        }
        if (type == Short.class) {
            return Short.decode(value);
        }
        if (type == BigDecimal.class) {
            return new BigDecimal(value);
        }
        if (type == BigInteger.class) {
            return new BigInteger(value);
        }
        if (type == String.class) {
            return value;
        }
        if (type == Pattern.class) {
            return Pattern.compile(value);
        }
        if (type == Path.class) {
            return new Path(value);
        }
        throw new IllegalArgumentException("Not a simple type: " + type);
    }

    private static Object parseEnum(String value) {
        int p = value.indexOf(45);
        if (p < 0) {
            throw new IllegalArgumentException(value + " cannot be parsed as enum.");
        }
        String cname = value.substring(0, p);
        String field = value.substring(p + 1);
        try {
            Class<?> c = Class.forName(cname);
            Object result = Enum.valueOf(c, field);
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String toString(Object simple) {
        if (simple == null) {
            return "";
        }
        if (!KeyTypes.isSimple(simple.getClass())) {
            throw new IllegalArgumentException();
        }
        if (simple instanceof Enum) {
            return simple.getClass().getName() + "-" + simple.toString();
        }
        return simple.toString();
    }

    public static Object fromString(Class<?> simpleType, String value) {
        try {
            return KeyTypes.fromString2(simpleType, value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    static {
        HashMap<Class, String> types = new HashMap<Class, String>();
        types.put(Boolean.class, "boolean");
        types.put(Byte.class, "byte");
        types.put(Character.class, "char");
        types.put(Double.class, "double");
        types.put(Float.class, "float");
        types.put(Integer.class, "int");
        types.put(Long.class, "long");
        types.put(Short.class, "short");
        types.put(String.class, "string");
        types.put(Pattern.class, "pattern");
        types.put(BigInteger.class, "biginteger");
        types.put(BigDecimal.class, "bigdecimal");
        types.put(Enum.class, ENUM_TAG);
        types.put(Path.class, "file");
        TYPES = Collections.unmodifiableMap(types);
        HashMap tags = new HashMap();
        for (Map.Entry me : types.entrySet()) {
            tags.put(me.getValue(), me.getKey());
        }
        TAGS = Collections.unmodifiableMap(tags);
    }
}

