/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import junit.framework.TestCase;
import org.archive.state.Key;
import org.archive.state.KeyManager;
import org.archive.state.KeyMetadataMaker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModuleTestBase
extends TestCase {
    public ModuleTestBase() {
        File srcDir = this.getSourceCodeDir();
        File resourceDir = this.getResourceDir();
        if (srcDir != null && resourceDir != null) {
            KeyMetadataMaker.makeDefaultLocale(srcDir, resourceDir, this.getModuleClass());
        }
    }

    protected File getSourceCodeDir() {
        return this.getProjectDir("src/main/java");
    }

    protected File getResourceDir() {
        return this.getProjectDir("src/main/resources");
    }

    private File getProjectDir(String path) {
        File r = new File(path);
        if (r.exists()) {
            return r;
        }
        String cname = ((Object)((Object)this)).getClass().getName();
        if (cname.startsWith("org.archive.processors")) {
            return new File("modules/" + path);
        }
        if (cname.startsWith("org.archive.deciderules")) {
            return new File("modules/" + path);
        }
        if (cname.startsWith("org.archive.crawler")) {
            return new File("engine/" + path);
        }
        return null;
    }

    protected Class<?> getModuleClass() {
        String myClassName = ((Object)((Object)this)).getClass().getCanonicalName();
        if (!myClassName.endsWith("Test")) {
            throw new UnsupportedOperationException("Cannot get module class of " + myClassName);
        }
        String moduleClassName = myClassName.substring(0, myClassName.length() - 4);
        try {
            return Class.forName(moduleClassName);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected Object makeModule() throws Exception {
        return this.getModuleClass().newInstance();
    }

    public void testKeyManagerRegistration() {
        Map<String, Key<Object>> keys = KeyManager.getKeys(this.getModuleClass());
        Field[] fields = this.getModuleClass().getFields();
        int expectedKeyCount = 0;
        for (Field f : fields) {
            if (f.getType() != Key.class) continue;
            ++expectedKeyCount;
        }
        if (expectedKeyCount > 0 && keys.isEmpty()) {
            ModuleTestBase.fail((String)"Developer forgot KeyManager.addKeys.");
        }
        ModuleTestBase.assertEquals((int)expectedKeyCount, (int)keys.size());
    }

    public void testDefaultLocale() {
        Class<?> c = this.getModuleClass();
        Map<String, Key<Object>> keys = KeyManager.getKeys(c);
        ArrayList<String> problems = new ArrayList<String>();
        for (Key<Object> k : keys.values()) {
            String name = k.getName(Locale.ENGLISH);
            String desc = k.getDescription(Locale.ENGLISH);
            if (name != null && desc != null) continue;
            problems.add(k.getFieldName());
        }
        if (KeyManager.getModuleDescription(c, Locale.ENGLISH) == null) {
            problems.add("class description");
        }
        TestCase.assertTrue((String)((Object)problems).toString(), (boolean)problems.isEmpty());
    }

    public void testSerialization() throws Exception {
        Object first = this.makeModule();
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream output = new ObjectOutputStream(bout);
        output.writeObject(first);
        ByteArrayInputStream binp = new ByteArrayInputStream(bout.toByteArray());
        ObjectInputStream input = new ObjectInputStream(binp);
        Object second = input.readObject();
        ByteArrayOutputStream bout2 = new ByteArrayOutputStream();
        output = new ObjectOutputStream(bout2);
        output.writeObject(second);
        this.verifySerialization(first, bout.toByteArray(), second, bout2.toByteArray());
    }

    protected void verifySerialization(Object first, byte[] firstBytes, Object second, byte[] secondBytes) throws Exception {
        ModuleTestBase.assertTrue((boolean)Arrays.equals(firstBytes, secondBytes));
    }
}

