/*
 * Decompiled with CFR 0.152.
 */
package org.archive.state;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Map;
import org.archive.state.PathContext;

public class Path
implements Serializable {
    public static final Path EMPTY = new Path("");
    private static final long serialVersionUID = 1L;
    private String path;
    private File file;
    private PathContext context;

    public Path(String path) {
        this.path = path;
        this.file = new File(path);
    }

    public Path(PathContext context, String path) {
        this.context = context;
        this.path = path;
        this.setFromContext(path);
    }

    private void setFromContext(String p) {
        if (this.context != null) {
            for (Map.Entry<String, String> var : this.context.getPathVariables().entrySet()) {
                String token = "${" + var.getKey() + "}";
                p = p.replace(token, var.getValue());
            }
            File f = new File(p);
            if (!f.isAbsolute()) {
                f = new File(this.context.getBaseDir(), p);
            }
            this.file = f;
        } else {
            this.file = new File(p);
        }
    }

    public boolean isEmpty() {
        return this.path.equals("");
    }

    public String toString() {
        return this.path;
    }

    public File toFile() {
        return this.file;
    }

    private void readObject(ObjectInputStream input) throws IOException, ClassNotFoundException {
        input.defaultReadObject();
        this.setFromContext(this.path);
    }

    public boolean equals(Object o) {
        if (!(o instanceof Path)) {
            return false;
        }
        Path p = (Path)o;
        return p.path.equals(this.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }
}

