/*
 * Decompiled with CFR 0.152.
 */
package org.archive.surt;

import org.apache.commons.httpclient.URIException;
import org.archive.net.UURI;
import org.archive.net.UURIFactory;
import org.archive.util.ArchiveUtils;
import org.archive.util.SURT;

public class SURTTokenizer {
    private static final String EXACT_SUFFIX = "\t";
    private String remainder;
    private boolean triedExact;
    private boolean triedFull;
    private boolean choppedArgs;
    private boolean choppedPath;
    private boolean choppedLogin;
    private boolean choppedPort;

    public SURTTokenizer(String url) throws URIException {
        this.remainder = SURTTokenizer.getKey(url, false);
    }

    public String nextSearch() {
        int lastComma;
        if (!this.triedExact) {
            this.triedExact = true;
            return this.remainder + EXACT_SUFFIX;
        }
        if (!this.triedFull) {
            this.triedFull = true;
            return this.remainder;
        }
        if (!this.choppedArgs) {
            this.choppedArgs = true;
            int argStart = this.remainder.indexOf(63);
            if (argStart != -1) {
                this.remainder = this.remainder.substring(0, argStart);
                return this.remainder;
            }
        }
        if (!this.choppedPath) {
            int lastSlash = this.remainder.lastIndexOf(47);
            if (lastSlash != -1) {
                this.remainder = this.remainder.substring(0, lastSlash);
                if (this.remainder.endsWith(")")) {
                    this.remainder = this.remainder.substring(0, this.remainder.length() - 1);
                }
                return this.remainder;
            }
            this.choppedPath = true;
        }
        if (!this.choppedLogin) {
            this.choppedLogin = true;
            int lastAt = this.remainder.lastIndexOf(64);
            if (lastAt != -1) {
                this.remainder = this.remainder.substring(0, lastAt);
                if (this.remainder.endsWith(",")) {
                    this.remainder = this.remainder.substring(0, this.remainder.length() - 1);
                }
                return this.remainder;
            }
        }
        if (!this.choppedPort) {
            this.choppedPort = true;
            int lastColon = this.remainder.lastIndexOf(58);
            if (lastColon != -1) {
                this.remainder = this.remainder.substring(0, lastColon);
                if (this.remainder.endsWith(",")) {
                    this.remainder = this.remainder.substring(0, this.remainder.length() - 1);
                }
                return this.remainder;
            }
        }
        if ((lastComma = this.remainder.lastIndexOf(44)) == -1) {
            return null;
        }
        this.remainder = this.remainder.substring(0, lastComma);
        return this.remainder;
    }

    public static String exactKey(String url) throws URIException {
        return SURTTokenizer.getKey(url, false);
    }

    public static String prefixKey(String url) throws URIException {
        return SURTTokenizer.getKey(url, true);
    }

    private static String getKey(String url, boolean prefix) throws URIException {
        String key = ArchiveUtils.addImpliedHttpIfNecessary(url);
        UURI uuri = UURIFactory.getInstance(key);
        key = uuri.getScheme() + "://" + uuri.getAuthority() + uuri.getEscapedPathQuery();
        int hashPos = (key = SURT.fromURI(key)).indexOf(35);
        if (hashPos != -1) {
            key = key.substring(0, hashPos);
        }
        if (key.startsWith("http://")) {
            key = key.substring(7);
        }
        if (prefix && key.endsWith(")/")) {
            key = key.substring(0, key.length() - 2);
        }
        return key;
    }
}

