/*
 * Decompiled with CFR 0.152.
 */
package org.archive.uid;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import org.archive.uid.Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratorFactory
implements Generator {
    public final String SYSTEM_PROPERTY_GENERATOR_KEY = this.getClass().toString() + ".generator";
    private static final String DEFAULT_GENERATOR = "org.archive.uid.UUIDGenerator";
    private static final GeneratorFactory factory = new GeneratorFactory();
    private final Generator generator;

    private GeneratorFactory() {
        String className = System.getProperty(this.SYSTEM_PROPERTY_GENERATOR_KEY, DEFAULT_GENERATOR);
        Generator ridg = null;
        try {
            Class<?> c = Class.forName(className);
            ridg = (Generator)c.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.generator = ridg;
    }

    @Override
    public URI getRecordID() throws URISyntaxException {
        return this.generator.getRecordID();
    }

    @Override
    public URI getQualifiedRecordID(Map<String, String> qualifiers) throws URISyntaxException {
        return this.generator.getQualifiedRecordID(qualifiers);
    }

    @Override
    public URI getQualifiedRecordID(String key, String value) throws URISyntaxException {
        return this.generator.getQualifiedRecordID(key, value);
    }

    @Override
    public URI qualifyRecordID(URI uri, Map<String, String> qualifiers) throws URISyntaxException {
        return this.generator.qualifyRecordID(uri, qualifiers);
    }

    public static GeneratorFactory getFactory() {
        return factory;
    }
}

