/*
 * Decompiled with CFR 0.152.
 */
package org.archive.uid;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.UUID;
import org.archive.uid.Generator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class UUIDGenerator
implements Generator {
    private static final String SCHEME = "urn:uuid";
    private static final String SCHEME_COLON = "urn:uuid:";

    UUIDGenerator() {
    }

    @Override
    public synchronized URI qualifyRecordID(URI recordId, Map<String, String> qualifiers) throws URISyntaxException {
        return this.getRecordID();
    }

    private String getUUID() {
        return UUID.randomUUID().toString();
    }

    @Override
    public URI getRecordID() throws URISyntaxException {
        return new URI(SCHEME_COLON + this.getUUID());
    }

    @Override
    public URI getQualifiedRecordID(String key, String value) throws URISyntaxException {
        return this.getRecordID();
    }

    @Override
    public URI getQualifiedRecordID(Map<String, String> qualifiers) throws URISyntaxException {
        return this.getRecordID();
    }
}

