/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.util.logging.Logger;
import org.archive.util.fingerprint.LongFPSet;

public abstract class AbstractLongFPSet
implements LongFPSet,
Serializable {
    private static Logger logger = Logger.getLogger("org.archive.util.AbstractLongFPSet");
    protected static byte EMPTY = (byte)-1;
    protected int capacityPowerOfTwo;
    protected float loadFactor;
    protected long count;

    public AbstractLongFPSet() {
    }

    public AbstractLongFPSet(int capacityPowerOfTwo, float loadFactor) {
        this.capacityPowerOfTwo = capacityPowerOfTwo;
        this.loadFactor = loadFactor;
        this.count = 0L;
    }

    public boolean contains(long val) {
        long i = this.indexFor(val);
        if (this.slotHasData(i)) {
            this.noteAccess(i);
            return true;
        }
        return false;
    }

    protected abstract int getSlotState(long var1);

    private void noteAccess(long index) {
    }

    public long count() {
        return this.count;
    }

    public boolean add(long val) {
        logger.finest("Adding " + val);
        long i = this.indexFor(val);
        if (this.slotHasData(i)) {
            return false;
        }
        if ((float)(this.count + 1L) > this.loadFactor * (float)(1 << this.capacityPowerOfTwo)) {
            this.makeSpace();
            i = this.indexFor(val);
            assert (i < 0L) : "slot should be empty";
        }
        i = this.asDataSlot(i);
        this.setAt(i, val);
        ++this.count;
        this.noteAccess(i);
        return true;
    }

    protected abstract void makeSpace();

    protected abstract void setAt(long var1, long var3);

    protected abstract long getAt(long var1);

    private long indexFor(long val) {
        long candidateIndex = this.startIndexFor(val);
        while (this.getSlotState(candidateIndex) >= 0) {
            if (this.getAt(candidateIndex) == val) {
                return candidateIndex;
            }
            if (++candidateIndex != (long)(1 << this.capacityPowerOfTwo)) continue;
            candidateIndex = 0L;
        }
        return this.asEmptySlot(candidateIndex);
    }

    private long startIndexFor(long val) {
        return val >>> 64 - this.capacityPowerOfTwo;
    }

    public boolean remove(long l) {
        long i = this.indexFor(l);
        if (!this.slotHasData(i)) {
            return false;
        }
        this.removeAt(i);
        return true;
    }

    protected void removeAt(long index) {
        --this.count;
        this.clearAt(index);
        long probeIndex = index + 1L;
        while (true) {
            if (probeIndex == (long)(1 << this.capacityPowerOfTwo)) {
                probeIndex = 0L;
            }
            if (this.getSlotState(probeIndex) < 0) break;
            long val = this.getAt(probeIndex);
            long newIndex = this.indexFor(val);
            if (newIndex != probeIndex) {
                newIndex = this.asDataSlot(newIndex);
                this.relocate(val, probeIndex, newIndex);
            }
            ++probeIndex;
        }
    }

    protected abstract void clearAt(long var1);

    protected abstract void relocate(long var1, long var3, long var5);

    public boolean quickContains(long fp) {
        return false;
    }

    private long asDataSlot(long index) {
        if (this.slotHasData(index)) {
            return index;
        }
        return -(index + 1L);
    }

    private long asEmptySlot(long index) {
        if (!this.slotHasData(index)) {
            return index;
        }
        return -index - 1L;
    }

    private boolean slotHasData(long index) {
        return index >= 0L;
    }
}

