/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import org.archive.util.IoUtils;
import org.archive.util.Reporter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArchiveUtils {
    public static final String VERSION = ArchiveUtils.loadVersion();
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP12 = ArchiveUtils.threadLocalDateFormat("yyyyMMddHHmm");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP14 = ArchiveUtils.threadLocalDateFormat("yyyyMMddHHmmss");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP17 = ArchiveUtils.threadLocalDateFormat("yyyyMMddHHmmssSSS");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP17ISO8601Z = ArchiveUtils.threadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static final ThreadLocal<SimpleDateFormat> TIMESTAMP14ISO8601Z = ArchiveUtils.threadLocalDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    private static final char DEFAULT_PAD_CHAR = ' ';
    private static final int HOUR_IN_MS = 3600000;
    private static final int DAY_IN_MS = 86400000;
    public static int MAX_INT_CHAR_WIDTH = Integer.toString(Integer.MAX_VALUE).length();
    public static Set<String> TLDS = new HashSet<String>();

    private static ThreadLocal<SimpleDateFormat> threadLocalDateFormat(final String pattern) {
        ThreadLocal<SimpleDateFormat> tl = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(pattern);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df;
            }
        };
        return tl;
    }

    public static String get17DigitDate() {
        return TIMESTAMP17.get().format(new Date());
    }

    public static String get14DigitDate() {
        return TIMESTAMP14.get().format(new Date());
    }

    public static String get12DigitDate() {
        return TIMESTAMP12.get().format(new Date());
    }

    public static String getLog17Date() {
        return TIMESTAMP17ISO8601Z.get().format(new Date());
    }

    public static String getLog17Date(long date) {
        return TIMESTAMP17ISO8601Z.get().format(new Date(date));
    }

    public static String getLog14Date() {
        return TIMESTAMP14ISO8601Z.get().format(new Date());
    }

    public static String getLog14Date(long date) {
        return TIMESTAMP14ISO8601Z.get().format(new Date(date));
    }

    public static String getLog14Date(Date date) {
        return TIMESTAMP14ISO8601Z.get().format(date);
    }

    public static String get17DigitDate(long date) {
        return TIMESTAMP17.get().format(new Date(date));
    }

    public static String get17DigitDate(Date date) {
        return TIMESTAMP17.get().format(date);
    }

    public static String get14DigitDate(long date) {
        return TIMESTAMP14.get().format(new Date(date));
    }

    public static String get14DigitDate(Date d) {
        return TIMESTAMP14.get().format(d);
    }

    public static String get12DigitDate(long date) {
        return TIMESTAMP12.get().format(new Date(date));
    }

    public static String get12DigitDate(Date d) {
        return TIMESTAMP12.get().format(d);
    }

    public static Date getDate(String d) throws ParseException {
        Date date = null;
        if (d == null) {
            throw new IllegalArgumentException("Passed date is null");
        }
        switch (d.length()) {
            case 14: {
                date = ArchiveUtils.parse14DigitDate(d);
                break;
            }
            case 17: {
                date = ArchiveUtils.parse17DigitDate(d);
                break;
            }
            case 12: {
                date = ArchiveUtils.parse12DigitDate(d);
                break;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                throw new ParseException("Date string must at least contain ayear: " + d, d.length());
            }
            default: {
                int i;
                if (!d.startsWith("19") && !d.startsWith("20")) {
                    throw new ParseException("Unrecognized century: " + d, 0);
                }
                if (d.length() < 8 && d.length() % 2 != 0) {
                    throw new ParseException("Incomplete month/date: " + d, d.length());
                }
                StringBuilder sb = new StringBuilder(d);
                if (sb.length() < 8) {
                    i = sb.length();
                    while (sb.length() < 8) {
                        sb.append("01");
                        i += 2;
                    }
                }
                if (sb.length() < 12) {
                    i = sb.length();
                    while (sb.length() < 12) {
                        sb.append("0");
                        ++i;
                    }
                }
                date = ArchiveUtils.parse12DigitDate(sb.toString());
            }
        }
        return date;
    }

    public static Date parse17DigitDate(String date) throws ParseException {
        return TIMESTAMP17.get().parse(date);
    }

    public static Date parse14DigitDate(String date) throws ParseException {
        return TIMESTAMP14.get().parse(date);
    }

    public static Date parse12DigitDate(String date) throws ParseException {
        return TIMESTAMP12.get().parse(date);
    }

    public static Calendar timestamp17ToCalendar(String timestamp17String) {
        GregorianCalendar calendar = new GregorianCalendar();
        int year = Integer.parseInt(timestamp17String.substring(0, 4));
        int dayOfMonth = Integer.parseInt(timestamp17String.substring(6, 8));
        int month = Integer.parseInt(timestamp17String.substring(4, 6)) - 1;
        int hourOfDay = Integer.parseInt(timestamp17String.substring(8, 10));
        int minute = Integer.parseInt(timestamp17String.substring(10, 12));
        int second = Integer.parseInt(timestamp17String.substring(12, 14));
        int milliseconds = Integer.parseInt(timestamp17String.substring(14, 17));
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, dayOfMonth);
        calendar.set(11, hourOfDay);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, milliseconds);
        return calendar;
    }

    public static String secondsSinceEpoch(String timestamp) throws ParseException {
        return ArchiveUtils.zeroPadInteger((int)(ArchiveUtils.getSecondsSinceEpoch(timestamp).getTime() / 1000L));
    }

    public static Date getSecondsSinceEpoch(String timestamp) throws ParseException {
        if (timestamp.length() < 14) {
            if (timestamp.length() < 10 && timestamp.length() % 2 == 1) {
                throw new IllegalArgumentException("Must have year, month, date, hour or second granularity: " + timestamp);
            }
            if (timestamp.length() == 4) {
                timestamp = timestamp + "01010000";
            }
            if (timestamp.length() == 6) {
                timestamp = timestamp + "010000";
            }
            if (timestamp.length() < 14) {
                timestamp = timestamp + ArchiveUtils.padTo("", 14 - timestamp.length(), '0');
            }
        }
        return ArchiveUtils.parse14DigitDate(timestamp);
    }

    public static String zeroPadInteger(int i) {
        return ArchiveUtils.padTo(Integer.toString(i), MAX_INT_CHAR_WIDTH, '0');
    }

    public static String padTo(int i, int pad) {
        String n = Integer.toString(i);
        return ArchiveUtils.padTo(n, pad);
    }

    public static String padTo(String s, int pad) {
        return ArchiveUtils.padTo(s, pad, ' ');
    }

    public static String padTo(String s, int pad, char padChar) {
        String result = s;
        int l = s.length();
        if (l < pad) {
            StringBuffer sb = new StringBuffer(pad);
            while (l < pad) {
                sb.append(padChar);
                ++l;
            }
            sb.append(s);
            result = sb.toString();
        }
        return result;
    }

    public static boolean byteArrayEquals(byte[] lhs, byte[] rhs) {
        if (lhs == null && rhs != null || lhs != null && rhs == null) {
            return false;
        }
        if (lhs == rhs) {
            return true;
        }
        if (lhs.length != rhs.length) {
            return false;
        }
        for (int i = 0; i < lhs.length; ++i) {
            if (lhs[i] == rhs[i]) continue;
            return false;
        }
        return true;
    }

    public static String doubleToString(double val, int maxFractionDigits) {
        return ArchiveUtils.doubleToString(val, maxFractionDigits, 0);
    }

    private static String doubleToString(double val, int maxFractionDigits, int minFractionDigits) {
        NumberFormat f = NumberFormat.getNumberInstance(Locale.US);
        f.setMaximumFractionDigits(maxFractionDigits);
        f.setMinimumFractionDigits(minFractionDigits);
        return f.format(val);
    }

    public static String formatBytesForDisplay(long amount) {
        int unitPowerOf1024;
        double displayAmount = amount;
        if (amount <= 0L) {
            return "0 B";
        }
        for (unitPowerOf1024 = 0; displayAmount >= 1024.0 && unitPowerOf1024 < 4; displayAmount /= 1024.0, ++unitPowerOf1024) {
        }
        String[] units = new String[]{" B", " KB", " MB", " GB", " TB"};
        int fractionDigits = displayAmount < 10.0 ? 1 : 0;
        return ArchiveUtils.doubleToString(displayAmount, fractionDigits, fractionDigits) + units[unitPowerOf1024];
    }

    public static String formatMillisecondsToConventional(long time) {
        return ArchiveUtils.formatMillisecondsToConventional(time, true);
    }

    public static String formatMillisecondsToConventional(long time, boolean toMs) {
        StringBuffer sb = new StringBuffer();
        if (time < 0L) {
            sb.append("-");
        }
        long absTime = Math.abs(time);
        if (!toMs && absTime < 1000L) {
            return "0s";
        }
        if (absTime > 86400000L) {
            sb.append(absTime / 86400000L + "d");
            absTime %= 86400000L;
        }
        if (absTime > 3600000L) {
            sb.append(absTime / 3600000L + "h");
            absTime %= 3600000L;
        }
        if (absTime > 60000L) {
            sb.append(absTime / 60000L + "m");
            absTime %= 60000L;
        }
        if (absTime > 1000L) {
            sb.append(absTime / 1000L + "s");
            absTime %= 1000L;
        }
        if (toMs) {
            sb.append(absTime + "ms");
        }
        return sb.toString();
    }

    public static long classnameBasedUID(Class class1, int version) {
        String callingClassname = class1.getName();
        return (long)callingClassname.hashCode() << 32 + version;
    }

    public static void longIntoByteArray(long l, byte[] array, int offset) {
        int i = 0;
        int shift = 56;
        while (i < 8) {
            array[offset + i] = (byte)(0xFFL & l >> shift);
            ++i;
            shift -= 8;
        }
    }

    public static long byteArrayIntoLong(byte[] bytearray) {
        return ArchiveUtils.byteArrayIntoLong(bytearray, 0);
    }

    public static long byteArrayIntoLong(byte[] bytearray, int offset) {
        long result = 0L;
        for (int i = offset; i < 8; ++i) {
            result = result << 8 | (long)(0xFF & (byte)(bytearray[i] & 0xFF));
        }
        return result;
    }

    public static String addImpliedHttpIfNecessary(String u) {
        int colon = u.indexOf(58);
        int period = u.indexOf(46);
        if (colon == -1 || period >= 0 && period < colon) {
            u = "http://" + u;
        }
        return u;
    }

    public static boolean startsWith(byte[] array, byte[] prefix) {
        if (prefix.length > array.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (array[i] == prefix[i]) continue;
            return false;
        }
        return true;
    }

    public static String singleLineReport(Reporter rep) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        try {
            rep.singleLineReportTo(pw);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        pw.flush();
        return sw.toString();
    }

    public static String writeReportToString(Reporter rep, String name) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        rep.reportTo(name, pw);
        pw.flush();
        return sw.toString();
    }

    public static String prettyString(Object obj) {
        return "<" + obj + ">";
    }

    public static String prettyString(Map map) {
        StringBuilder builder = new StringBuilder();
        builder.append("{ ");
        boolean needsComma = false;
        for (Object key : map.keySet()) {
            if (needsComma) {
                builder.append(", ");
            }
            builder.append(key);
            builder.append(": ");
            builder.append(ArchiveUtils.prettyString(map.get(key)));
            needsComma = true;
        }
        builder.append(" }");
        return builder.toString();
    }

    public static String prettyString(Map[] maps) {
        StringBuilder builder = new StringBuilder();
        builder.append("[ ");
        boolean needsComma = false;
        for (Map map : maps) {
            if (map == null) continue;
            if (needsComma) {
                builder.append(", ");
            }
            builder.append(ArchiveUtils.prettyString(map));
            needsComma = true;
        }
        builder.append(" ]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadVersion() {
        String timestamp;
        String version;
        InputStream input = ArchiveUtils.class.getResourceAsStream("/org/archive/util/version.txt");
        if (input == null) {
            return "UNKNOWN";
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(input));
            version = br.readLine();
            br.readLine();
        }
        catch (IOException e) {
            String string;
            try {
                string = e.getMessage();
            }
            catch (Throwable throwable) {
                IoUtils.close(br);
                throw throwable;
            }
            IoUtils.close(br);
            return string;
        }
        IoUtils.close(br);
        version = version.trim();
        if (!version.endsWith("SNAPSHOT")) {
            return version;
        }
        input = ArchiveUtils.class.getResourceAsStream("/org/archive/util/timestamp.txt");
        if (input == null) {
            return version;
        }
        br = null;
        try {
            br = new BufferedReader(new InputStreamReader(input));
            timestamp = br.readLine();
        }
        catch (IOException e) {
            String string = version;
            return string;
        }
        finally {
            IoUtils.close(br);
        }
        if (timestamp.startsWith("timestamp=")) {
            timestamp = timestamp.substring(10);
        }
        return version.trim() + "-" + timestamp.trim();
    }

    public static boolean isTld(String dom) {
        return TLDS.contains(dom.toUpperCase());
    }

    static {
        String[] tldsArray = new String[]{"AC", "AD", "AE", "AERO", "AF", "AG", "AI", "AL", "AM", "AN", "AO", "AQ", "AR", "ARPA", "AS", "ASIA", "AT", "AU", "AW", "AX", "AZ", "BA", "BB", "BD", "BE", "BF", "BG", "BH", "BI", "BIZ", "BJ", "BM", "BN", "BO", "BR", "BS", "BT", "BV", "BW", "BY", "BZ", "CA", "CAT", "CC", "CD", "CF", "CG", "CH", "CI", "CK", "CL", "CM", "CN", "CO", "COM", "COOP", "CR", "CU", "CV", "CX", "CY", "CZ", "DE", "DJ", "DK", "DM", "DO", "DZ", "EC", "EDU", "EE", "EG", "ER", "ES", "ET", "EU", "FI", "FJ", "FK", "FM", "FO", "FR", "GA", "GB", "GD", "GE", "GF", "GG", "GH", "GI", "GL", "GM", "GN", "GOV", "GP", "GQ", "GR", "GS", "GT", "GU", "GW", "GY", "HK", "HM", "HN", "HR", "HT", "HU", "ID", "IE", "IL", "IM", "IN", "INFO", "INT", "IO", "IQ", "IR", "IS", "IT", "JE", "JM", "JO", "JOBS", "JP", "KE", "KG", "KH", "KI", "KM", "KN", "KP", "KR", "KW", "KY", "KZ", "LA", "LB", "LC", "LI", "LK", "LR", "LS", "LT", "LU", "LV", "LY", "MA", "MC", "MD", "ME", "MG", "MH", "MIL", "MK", "ML", "MM", "MN", "MO", "MOBI", "MP", "MQ", "MR", "MS", "MT", "MU", "MUSEUM", "MV", "MW", "MX", "MY", "MZ", "NA", "NAME", "NC", "NE", "NET", "NF", "NG", "NI", "NL", "NO", "NP", "NR", "NU", "NZ", "OM", "ORG", "PA", "PE", "PF", "PG", "PH", "PK", "PL", "PM", "PN", "PR", "PRO", "PS", "PT", "PW", "PY", "QA", "RE", "RO", "RS", "RU", "RW", "SA", "SB", "SC", "SD", "SE", "SG", "SH", "SI", "SJ", "SK", "SL", "SM", "SN", "SO", "SR", "ST", "SU", "SV", "SY", "SZ", "TC", "TD", "TEL", "TF", "TG", "TH", "TJ", "TK", "TL", "TM", "TN", "TO", "TP", "TR", "TRAVEL", "TT", "TV", "TW", "TZ", "UA", "UG", "UK", "US", "UY", "UZ", "VA", "VC", "VE", "VG", "VI", "VN", "VU", "WF", "WS", "XN--0ZWM56D", "XN--11B5BS3A9AJ6G", "XN--80AKHBYKNJ4F", "XN--9T4B11YI5A", "XN--DEBA0AD", "XN--G6W251D", "XN--HGBK6AJ7F53BBA", "XN--HLCJ6AYA9ESC7A", "XN--JXALPDLP", "XN--KGBECHTV", "XN--ZCKZAH", "YE", "YT", "YU", "ZA", "ZM", "ZW"};
        TLDS.addAll(Arrays.asList(tldsArray));
    }
}

