/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import org.archive.util.BloomFilter;
import org.archive.util.BloomFilter32bit;
import org.archive.util.BloomFilter32bitSplit;
import org.archive.util.BloomFilter32bp2;
import org.archive.util.BloomFilter32bp2Split;
import org.archive.util.BloomFilter64bit;

public class BenchmarkBlooms {
    public static void main(String[] args) {
        new BenchmarkBlooms().instanceMain(args);
    }

    public void instanceMain(String[] args) {
        int reps = args.length > 0 ? Integer.parseInt(args[0]) : 3;
        int n_expected = args.length > 1 ? Integer.parseInt(args[1]) : 10000000;
        int d_hashes = args.length > 2 ? Integer.parseInt(args[2]) : 22;
        int adds = args.length > 3 ? Integer.parseInt(args[3]) : 5000000;
        String prefix = args.length > 4 ? args[4] : "http://www.archive.org/";
        System.out.println("reps=" + reps + " n_expected=" + n_expected + " d_hashes=" + d_hashes + " adds=" + adds + " prefix=" + prefix);
        for (int r = 0; r < reps; ++r) {
            BloomFilter32bit bloom32 = new BloomFilter32bit(n_expected, d_hashes);
            this.testBloom(bloom32, adds, prefix);
            bloom32 = null;
            BloomFilter32bitSplit bloom32split = new BloomFilter32bitSplit(n_expected, d_hashes);
            this.testBloom(bloom32split, adds, prefix);
            bloom32split = null;
            BloomFilter64bit bloom64 = new BloomFilter64bit(n_expected, d_hashes);
            this.testBloom(bloom64, adds, prefix);
            bloom64 = null;
            BloomFilter32bp2 bloom32p2 = new BloomFilter32bp2(n_expected, d_hashes);
            this.testBloom(bloom32p2, adds, prefix);
            bloom32p2 = null;
            BloomFilter32bp2Split bloom32p2split = new BloomFilter32bp2Split(n_expected, d_hashes);
            this.testBloom(bloom32p2split, adds, prefix);
            bloom32p2split = null;
        }
    }

    private void testBloom(BloomFilter bloom, int adds, String prefix) {
        System.gc();
        long startTime = System.currentTimeMillis();
        long falsePositives = 0L;
        for (int i = 0; i < adds; ++i) {
            if (bloom.add(prefix + Integer.toString(i))) continue;
            ++falsePositives;
        }
        long finishTime = System.currentTimeMillis();
        System.out.println(bloom.getClass().getName() + ": " + (finishTime - startTime) + "ms " + bloom.getSizeBytes() + "bytes " + falsePositives + "false");
    }
}

