/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.security.SecureRandom;
import org.archive.util.BloomFilter;

public class BloomFilter32bit
implements Serializable,
BloomFilter {
    private static final long serialVersionUID = -1567837798979475689L;
    public static final int NUMBER_OF_WEIGHTS = 2083;
    public final long m;
    public final int d;
    private final int[] bits;
    private final int[][] weight;
    private int size;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final boolean DEBUG = false;
    protected static final long ADDRESS_BITS_PER_UNIT = 5L;
    protected static final long BIT_INDEX_MASK = 31L;

    public BloomFilter32bit(int n, int d) {
        this.d = d;
        int len = (int)Math.ceil((double)((long)n * (long)d) / NATURAL_LOG_OF_2 / 32.0);
        this.m = (long)len * 32L;
        if (this.m >= 0x100000000L) {
            throw new IllegalArgumentException("This filter would require " + this.m + " bits");
        }
        this.bits = new int[len];
        SecureRandom random = new SecureRandom(new byte[]{19, 96});
        this.weight = new int[d][];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new int[2083];
            for (int j = 0; j < 2083; ++j) {
                this.weight[i][j] = random.nextInt();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private long hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        int h = 0;
        int i = l;
        while (i-- != 0) {
            h ^= s.charAt(i) * w[i % 2083];
        }
        return ((long)h - Integer.MIN_VALUE) % this.m;
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            if (this.getBit(this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        boolean result = false;
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            long h = this.hash(s, l, i);
            if (!this.getBit(h)) {
                result = true;
            }
            this.setBit(h);
        }
        if (result) {
            ++this.size;
        }
        return result;
    }

    protected boolean getBit(long bitIndex) {
        return (this.bits[(int)(bitIndex >> 5)] & 1 << (int)(bitIndex & 0x1FL)) != 0;
    }

    protected void setBit(long bitIndex) {
        int n = (int)(bitIndex >> 5);
        this.bits[n] = this.bits[n] | 1 << (int)(bitIndex & 0x1FL);
    }

    public long getSizeBytes() {
        return this.bits.length * 4;
    }
}

