/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.security.SecureRandom;
import org.archive.util.BloomFilter;

public class BloomFilter32bitSplit
implements Serializable,
BloomFilter {
    private static final long serialVersionUID = -164106965277863971L;
    public static final int NUMBER_OF_WEIGHTS = 2083;
    public final long m;
    public final int d;
    private final int[][] bits;
    private final int[][] weight;
    private int size;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final int ONE_MB_INTS = 262144;
    private static final boolean DEBUG = false;
    protected static final long ADDRESS_BITS_PER_UNIT = 5L;
    protected static final long BIT_INDEX_MASK = 31L;

    public BloomFilter32bitSplit(int n, int d) {
        this.d = d;
        int len = (int)Math.ceil((double)((long)n * (long)d) / NATURAL_LOG_OF_2 / 32.0);
        len = (len / 262144 + 1) * 262144;
        this.m = (long)len * 32L;
        if (this.m >= 0x40000000000000L) {
            throw new IllegalArgumentException("This filter would require " + this.m + " bits");
        }
        this.bits = new int[len / 262144][262144];
        SecureRandom random = new SecureRandom(new byte[]{19, 96});
        this.weight = new int[d][];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new int[2083];
            for (int j = 0; j < 2083; ++j) {
                this.weight[i][j] = random.nextInt();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private long hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        int h = 0;
        int i = l;
        while (i-- != 0) {
            h ^= s.charAt(i) * w[i % 2083];
        }
        return ((long)h - Integer.MIN_VALUE) % this.m;
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            if (this.getBit(this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        boolean result = false;
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            long h = this.hash(s, l, i);
            if (this.setGetBit(h)) continue;
            result = true;
        }
        if (result) {
            ++this.size;
        }
        return result;
    }

    protected boolean getBit(long bitIndex) {
        long intIndex = bitIndex >>> 5;
        return (this.bits[(int)(intIndex / 262144L)][(int)(intIndex % 262144L)] & 1 << (int)(bitIndex & 0x1FL)) != 0;
    }

    protected void setBit(long bitIndex) {
        long intIndex = bitIndex >>> 5;
        int[] nArray = this.bits[(int)(intIndex / 262144L)];
        int n = (int)(intIndex % 262144L);
        nArray[n] = nArray[n] | 1 << (int)(bitIndex & 0x1FL);
    }

    protected boolean setGetBit(long bitIndex) {
        long intIndex = (int)(bitIndex >>> 5);
        int a = (int)(intIndex / 262144L);
        int b = (int)(intIndex % 262144L);
        int mask = 1 << (int)(bitIndex & 0x1FL);
        boolean ret = (this.bits[a][b] & mask) != 0;
        int[] nArray = this.bits[a];
        int n = b;
        nArray[n] = nArray[n] | mask;
        return ret;
    }

    public long getSizeBytes() {
        return this.bits.length * this.bits[0].length * 4;
    }
}

