/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.security.SecureRandom;
import org.archive.util.BloomFilter;

public class BloomFilter32bp2
implements Serializable,
BloomFilter {
    private static final long serialVersionUID = -2292902803681146635L;
    public static final int NUMBER_OF_WEIGHTS = 2083;
    public final long m;
    public final long power;
    public final int d;
    private final int[] bits;
    private final int[][] weight;
    private int size;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final boolean DEBUG = false;
    protected static final int ADDRESS_BITS_PER_UNIT = 5;
    protected static final int BIT_INDEX_MASK = 31;

    public BloomFilter32bp2(int n, int d) {
        this.d = d;
        long minBits = (long)((double)((long)n * (long)d) / NATURAL_LOG_OF_2);
        long pow = 0L;
        while (1L << (int)pow < minBits) {
            ++pow;
        }
        this.power = pow;
        this.m = 1L << (int)pow;
        int len = (int)(this.m / 32L);
        if (this.m > 0x100000000L) {
            throw new IllegalArgumentException("This filter would require " + this.m + " bits");
        }
        System.out.println("power " + this.power + " bits " + this.m + " len " + len);
        this.bits = new int[len];
        SecureRandom random = new SecureRandom(new byte[]{19, 96});
        this.weight = new int[d][];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new int[2083];
            for (int j = 0; j < 2083; ++j) {
                this.weight[i][j] = random.nextInt();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private int hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        int h = 0;
        int i = l;
        while (i-- != 0) {
            h ^= s.charAt(i) * w[i % 2083];
        }
        return h >>> (int)(32L - this.power);
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            if (this.getBit(this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        boolean result = false;
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            int h = this.hash(s, l, i);
            if (!this.getBit(h)) {
                result = true;
            }
            this.setBit(h);
        }
        if (result) {
            ++this.size;
        }
        return result;
    }

    protected boolean getBit(int bitIndex) {
        return (this.bits[bitIndex >>> 5] & 1 << (bitIndex & 0x1F)) != 0;
    }

    protected void setBit(int bitIndex) {
        int n = bitIndex >>> 5;
        this.bits[n] = this.bits[n] | 1 << (bitIndex & 0x1F);
    }

    public long getSizeBytes() {
        return this.bits.length * 4;
    }
}

