/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.security.SecureRandom;
import org.archive.util.BloomFilter;

public class BloomFilter32bp2Split
implements Serializable,
BloomFilter {
    private static final long serialVersionUID = -1504889954381695129L;
    public static final int NUMBER_OF_WEIGHTS = 2083;
    public final long m;
    public final long power;
    public final int d;
    private final int[][] bits;
    private final int aShift;
    private final int bMask;
    private final int[][] weight;
    private int size;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final boolean DEBUG = false;
    protected static final int ADDRESS_BITS_PER_UNIT = 5;
    protected static final int BIT_INDEX_MASK = 31;

    public BloomFilter32bp2Split(int n, int d) {
        this.d = d;
        long minBits = (long)((double)((long)n * (long)d) / NATURAL_LOG_OF_2);
        long pow = 0L;
        while (1L << (int)pow < minBits) {
            ++pow;
        }
        this.power = pow;
        this.m = 1L << (int)pow;
        int len = (int)(this.m / 32L);
        if (this.m > 0x100000000L) {
            throw new IllegalArgumentException("This filter would require " + this.m + " bits");
        }
        this.aShift = (int)(pow - 5L - 8L);
        this.bMask = (1 << this.aShift) - 1;
        this.bits = new int[256][1 << this.aShift];
        System.out.println("power " + this.power + " bits " + this.m + " len " + len);
        System.out.println("aShift " + this.aShift + " bMask " + this.bMask);
        SecureRandom random = new SecureRandom(new byte[]{19, 96});
        this.weight = new int[d][];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new int[2083];
            for (int j = 0; j < 2083; ++j) {
                this.weight[i][j] = random.nextInt();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private int hash(CharSequence s, int l, int k) {
        int[] w = this.weight[k];
        int h = 0;
        int i = l;
        while (i-- != 0) {
            h ^= s.charAt(i) * w[i % 2083];
        }
        return h >>> (int)(32L - this.power);
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            if (this.getBit(this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        boolean result = false;
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            int h = this.hash(s, l, i);
            if (this.setGetBit(h)) continue;
            result = true;
        }
        if (result) {
            ++this.size;
        }
        return result;
    }

    protected boolean getBit(int bitIndex) {
        int intIndex = bitIndex >>> 5;
        return (this.bits[intIndex >>> this.aShift][intIndex & this.bMask] & 1 << (bitIndex & 0x1F)) != 0;
    }

    protected void setBit(int bitIndex) {
        int intIndex = bitIndex >>> 5;
        int[] nArray = this.bits[intIndex >>> this.aShift];
        int n = intIndex & this.bMask;
        nArray[n] = nArray[n] | 1 << (bitIndex & 0x1F);
    }

    protected boolean setGetBit(int bitIndex) {
        int intIndex = bitIndex >>> 5;
        int a = intIndex >>> this.aShift;
        int b = intIndex & this.bMask;
        int mask = 1 << (bitIndex & 0x1F);
        boolean ret = (this.bits[a][b] & mask) != 0;
        int[] nArray = this.bits[a];
        int n = b;
        nArray[n] = nArray[n] | mask;
        return ret;
    }

    public long getSizeBytes() {
        return this.bits.length * this.bits[0].length * 4;
    }
}

