/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.security.SecureRandom;
import org.archive.util.BloomFilter;

public class BloomFilter64bit
implements Serializable,
BloomFilter {
    private static final long serialVersionUID = 2317000663009608403L;
    public static final int NUMBER_OF_WEIGHTS = 2083;
    public final long m;
    public final int d;
    private final long[] bits;
    private final long[][] weight;
    private int size;
    private static final double NATURAL_LOG_OF_2 = Math.log(2.0);
    private static final boolean DEBUG = false;
    protected static final long ADDRESS_BITS_PER_UNIT = 6L;
    protected static final long BIT_INDEX_MASK = 63L;

    public BloomFilter64bit(int n, int d) {
        this.d = d;
        int len = (int)Math.ceil((double)((long)n * (long)d) / NATURAL_LOG_OF_2 / 64.0);
        if (len / 64 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This filter would require " + (long)len * 64L + " bits");
        }
        this.bits = new long[len];
        this.m = this.bits.length * 64;
        SecureRandom random = new SecureRandom(new byte[]{19, 96});
        this.weight = new long[d][];
        for (int i = 0; i < d; ++i) {
            this.weight[i] = new long[2083];
            for (int j = 0; j < 2083; ++j) {
                this.weight[i][j] = random.nextLong();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private long hash(CharSequence s, int l, int k) {
        long[] w = this.weight[k];
        long h = 0L;
        int i = l;
        while (i-- != 0) {
            h ^= (long)s.charAt(i) * w[i % 2083];
        }
        return (h & Long.MAX_VALUE) % this.m;
    }

    public boolean contains(CharSequence s) {
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            if (this.getBit(this.hash(s, l, i))) continue;
            return false;
        }
        return true;
    }

    public boolean add(CharSequence s) {
        boolean result = false;
        int i = this.d;
        int l = s.length();
        while (i-- != 0) {
            long h = this.hash(s, l, i);
            if (!this.getBit(h)) {
                result = true;
            }
            this.setBit(h);
        }
        if (result) {
            ++this.size;
        }
        return result;
    }

    protected boolean getBit(long bitIndex) {
        return (this.bits[(int)(bitIndex >> 6)] & 1L << (int)(bitIndex & 0x3FL)) != 0L;
    }

    protected void setBit(long bitIndex) {
        int n = (int)(bitIndex >> 6);
        this.bits[n] = this.bits[n] | 1L << (int)(bitIndex & 0x3FL);
    }

    public long getSizeBytes() {
        return this.bits.length * 8;
    }
}

