/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedBdbMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -8655539411367047332L;
    private static final Logger logger = Logger.getLogger(CachedBdbMap.class.getName());
    private static final String CLASS_CATALOG = "java_class_catalog";
    private static final Map<String, DbEnvironmentEntry> dbEnvironmentMap = new HashMap<String, DbEnvironmentEntry>();
    private transient DbEnvironmentEntry dbEnvironment;
    protected transient Database db;
    protected transient StoredSortedMap diskMap;
    private transient Map<K, SoftEntry<V>> memMap;
    protected transient ReferenceQueue<V> refQueue;
    protected int diskMapSize = 0;
    private long cacheHit = 0L;
    private long countOfGets = 0L;
    private long diskHit = 0L;
    private String dbName = null;
    private Class<K> keyClass;
    private Class<V> valueClass;
    protected static Field referentField;

    private CachedBdbMap() {
    }

    public CachedBdbMap(String dbName) {
        this();
        this.dbName = dbName;
    }

    public CachedBdbMap(File dbDir, String dbName, Class<K> keyClass, Class<V> valueClass) throws DatabaseException {
        this(dbName);
        this.dbEnvironment = super.getDbEnvironment(dbDir);
        ++this.dbEnvironment.openDbCount;
        this.initialize(this.dbEnvironment.environment, keyClass, valueClass, this.dbEnvironment.classCatalog);
        if (logger.isLoggable(Level.INFO)) {
            EnvironmentConfig cfg = this.dbEnvironment.environment.getConfig();
            logger.info("BdbConfiguration: Cache percentage " + cfg.getCachePercent() + ", cache size " + cfg.getCacheSize() + ", Map size: " + this.size());
        }
    }

    public synchronized void initialize(Environment env, Class keyClass, Class valueClass, StoredClassCatalog classCatalog) throws DatabaseException {
        this.initializeInstance();
        this.db = this.openDatabase(env, this.dbName);
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.diskMap = this.createDiskMap(this.db, classCatalog, keyClass, valueClass);
    }

    public Class<K> getKeyClass() {
        return this.keyClass;
    }

    public Class<V> getValueClass() {
        return this.valueClass;
    }

    protected void initializeInstance() {
        this.memMap = new HashMap<K, SoftEntry<V>>();
        this.refQueue = new ReferenceQueue();
    }

    protected StoredSortedMap createDiskMap(Database database, StoredClassCatalog classCatalog, Class keyClass, Class valueClass) {
        TupleBinding valueBinding;
        TupleBinding keyBinding = TupleBinding.getPrimitiveBinding((Class)keyClass);
        if (keyBinding == null) {
            keyBinding = new SerialBinding((ClassCatalog)classCatalog, keyClass);
        }
        if ((valueBinding = TupleBinding.getPrimitiveBinding((Class)valueClass)) == null) {
            valueBinding = new SerialBinding((ClassCatalog)classCatalog, valueClass);
        }
        return new StoredSortedMap(database, (EntryBinding)keyBinding, (EntryBinding)valueBinding, true);
    }

    private DbEnvironmentEntry getDbEnvironment(File dbDir) {
        if (dbEnvironmentMap.containsKey(dbDir.getAbsolutePath())) {
            return dbEnvironmentMap.get(dbDir.getAbsolutePath());
        }
        EnvironmentConfig envConfig = new EnvironmentConfig();
        envConfig.setAllowCreate(true);
        envConfig.setTransactional(false);
        envConfig.setCachePercent(1);
        DbEnvironmentEntry env = new DbEnvironmentEntry();
        try {
            env.environment = new Environment(dbDir, envConfig);
            env.dbDir = dbDir;
            dbEnvironmentMap.put(dbDir.getAbsolutePath(), env);
            DatabaseConfig dbConfig = new DatabaseConfig();
            dbConfig.setTransactional(false);
            dbConfig.setAllowCreate(true);
            dbConfig.setDeferredWrite(true);
            Database catalogDb = env.environment.openDatabase(null, CLASS_CATALOG, dbConfig);
            env.classCatalog = new StoredClassCatalog(catalogDb);
        }
        catch (DatabaseException e) {
            e.printStackTrace();
        }
        return env;
    }

    protected Database openDatabase(Environment environment, String dbName) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        dbConfig.setDeferredWrite(true);
        return environment.openDatabase(null, dbName, dbConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        if (this.db != null) {
            try {
                this.db.sync();
                this.db.close();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
            finally {
                this.db = null;
            }
        }
        if (this.dbEnvironment != null) {
            --this.dbEnvironment.openDbCount;
            if (this.dbEnvironment.openDbCount <= 0) {
                this.dbEnvironment.classCatalog.close();
                this.dbEnvironment.environment.close();
                dbEnvironmentMap.remove(this.dbEnvironment.dbDir.getAbsolutePath());
                this.dbEnvironment = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public Set<K> keySet() {
        return this.diskMap.keySet();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized V get(Object object) {
        V v;
        SoftEntry<V> entry;
        K key = this.toKey(object);
        ++this.countOfGets;
        this.expungeStaleEntries();
        if (this.countOfGets % 10000L == 0L) {
            this.logCacheSummary();
        }
        if ((entry = this.memMap.get(key)) != null) {
            Object val = entry.get();
            if (val != null) {
                ++this.cacheHit;
                return (V)val;
            }
            this.expungeStaleEntry(entry);
        }
        if ((v = this.diskMapGet(key)) != null) {
            ++this.diskHit;
            this.memMap.put(key, new SoftEntry<V>(key, v, this.refQueue));
        }
        return v;
    }

    private void logCacheSummary() {
        if (!logger.isLoggable(Level.FINE)) {
            return;
        }
        if (this.cacheHit + this.diskHit == 0L) {
            return;
        }
        try {
            long cacheHitPercent = this.cacheHit * 100L / (this.cacheHit + this.diskHit);
            logger.fine("DB name: " + this.db.getDatabaseName() + ", Cache Hit: " + cacheHitPercent + "%, Not in map: " + (this.countOfGets - (this.cacheHit + this.diskHit)) + ", Total number of gets: " + this.countOfGets);
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
    }

    @Override
    public synchronized V put(K key, V value) {
        V prevVal = this.get(key);
        this.memMap.put(key, new SoftEntry<V>(key, value, this.refQueue));
        this.diskMap.put(key, value);
        if (prevVal == null) {
            ++this.diskMapSize;
        }
        return prevVal;
    }

    @Override
    public synchronized void clear() {
        this.memMap.clear();
        if (this.db != null) {
            this.diskMap.clear();
            this.diskMapSize = 0;
            try {
                this.close();
            }
            catch (DatabaseException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public synchronized V remove(Object key) {
        V prevValue = this.get(key);
        this.memMap.remove(key);
        this.expungeStaleEntries();
        this.diskMap.remove(key);
        --this.diskMapSize;
        return prevValue;
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        if (this.quickContainsKey(key)) {
            return true;
        }
        return this.diskMap.containsKey(key);
    }

    public synchronized boolean quickContainsKey(Object key) {
        this.expungeStaleEntries();
        return this.memMap.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        if (this.quickContainsValue(value)) {
            return true;
        }
        return this.diskMap.containsValue(value);
    }

    public synchronized boolean quickContainsValue(Object value) {
        this.expungeStaleEntries();
        return this.memMap.containsValue(value);
    }

    @Override
    public int size() {
        return this.diskMapSize;
    }

    protected String getDatabaseName() {
        String name = "DbName-Lookup-Failed";
        try {
            if (this.db != null) {
                name = this.db.getDatabaseName();
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return name;
    }

    public synchronized void sync() {
        String dbName = null;
        long startTime = 0L;
        if (logger.isLoggable(Level.INFO)) {
            dbName = this.getDatabaseName();
            startTime = System.currentTimeMillis();
            logger.info(dbName + " start sizes: disk " + this.diskMapSize + ", mem " + this.memMap.size());
        }
        this.expungeStaleEntries();
        LinkedList<SoftEntry<V>> stale = new LinkedList<SoftEntry<V>>();
        for (K k : this.memMap.keySet()) {
            SoftEntry<V> entry = this.memMap.get(k);
            if (entry == null) continue;
            Object value = entry.get();
            if (value != null) {
                this.diskMap.put(k, value);
                continue;
            }
            stale.add(entry);
        }
        for (SoftEntry softEntry : stale) {
            this.expungeStaleEntry(softEntry);
        }
        try {
            this.db.sync();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info(dbName + " sync took " + (System.currentTimeMillis() - startTime) + "ms. " + "Finish sizes: disk " + this.diskMapSize + ", mem " + this.memMap.size());
        }
    }

    private void expungeStaleEntries() {
        SoftEntry<V> entry;
        int c = 0;
        while ((entry = this.refQueuePoll()) != null) {
            this.expungeStaleEntry(entry);
            ++c;
        }
        if (c > 0 && logger.isLoggable(Level.FINER)) {
            try {
                logger.finer("DB: " + this.db.getDatabaseName() + ",  Expunged: " + c + ", Diskmap size: " + this.diskMapSize + ", Cache size: " + this.memMap.size());
            }
            catch (DatabaseException databaseException) {
                // empty catch block
            }
        }
    }

    private void expungeStaleEntry(SoftEntry entry) {
        if (entry.getPhantom() == null) {
            return;
        }
        if (this.memMap.get(entry.getPhantom().getKey()) == entry) {
            this.memMap.remove(entry.getPhantom().getKey());
            this.diskMap.put(entry.getPhantom().getKey(), entry.getPhantom().doctoredGet());
        }
        entry.clearPhantom();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.initializeInstance();
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.getDatabaseName() + " diskMapSize: " + this.diskMapSize);
        }
    }

    private K toKey(Object o) {
        return (K)o;
    }

    private V diskMapGet(K k) {
        return (V)this.diskMap.get(k);
    }

    private SoftEntry<V> refQueuePoll() {
        return (SoftEntry)this.refQueue.poll();
    }

    static {
        try {
            referentField = Reference.class.getDeclaredField("referent");
            referentField.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SoftEntry<T>
    extends SoftReference<T> {
        private PhantomEntry<T> phantom;

        public SoftEntry(Object key, T referent, ReferenceQueue<T> q) {
            super(referent, q);
            this.phantom = new PhantomEntry<T>(key, referent);
        }

        public PhantomEntry getPhantom() {
            return this.phantom;
        }

        public void clearPhantom() {
            this.phantom.clear();
            this.phantom = null;
            super.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PhantomEntry<T>
    extends PhantomReference<T> {
        private final Object key;

        public PhantomEntry(Object key, T referent) {
            super(referent, null);
            this.key = key;
        }

        public Object doctoredGet() {
            try {
                return referentField.get(this);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        public Object getKey() {
            return this.key;
        }
    }

    protected static class DbEnvironmentEntry {
        Environment environment;
        StoredClassCatalog classCatalog;
        int openDbCount = 0;
        File dbDir;

        protected DbEnvironmentEntry() {
        }
    }
}

