/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class FileUtils {
    private static final Logger LOGGER = Logger.getLogger(FileUtils.class.getName());
    public static final File TMPDIR = new File(System.getProperty("java.io.tmpdir", "/tmp"));
    private static final boolean DEFAULT_OVERWRITE = true;

    private FileUtils() {
    }

    public static int copyFiles(File srcDir, Set srcFile, File dest) throws IOException {
        int count = 0;
        for (String name : srcFile) {
            File src = new File(srcDir, name);
            File tgt = new File(dest, name);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Before " + src.getAbsolutePath() + " " + src.exists() + ", " + tgt.getAbsolutePath() + " " + tgt.exists());
            }
            FileUtils.copyFiles(src, tgt);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("After " + src.getAbsolutePath() + " " + src.exists() + ", " + tgt.getAbsolutePath() + " " + tgt.exists());
            }
            ++count;
        }
        return count;
    }

    public static void copyFiles(File src, File dest) throws IOException {
        FileUtils.copyFiles(src, null, dest, false, true);
    }

    public static String[] getSortedDirContent(File src, FilenameFilter filter) {
        Object[] list;
        if (!src.exists()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(src.getAbsolutePath() + " does not exist");
            }
            return null;
        }
        if (!src.isDirectory()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(src.getAbsolutePath() + " is not directory.");
            }
            return null;
        }
        Object[] objectArray = list = filter == null ? src.list() : src.list(filter);
        if (list != null) {
            Arrays.sort(list);
        }
        return list;
    }

    public static void copyFiles(File src, FilenameFilter filter, File dest, boolean inSortedOrder, boolean overwrite) throws IOException {
        if (!src.exists()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(src.getAbsolutePath() + " does not exist");
            }
            return;
        }
        if (src.isDirectory()) {
            Object[] list;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(src.getAbsolutePath() + " is a directory.");
            }
            if (!dest.exists()) {
                dest.mkdirs();
            }
            Object[] objectArray = list = filter == null ? src.list() : src.list(filter);
            if (inSortedOrder) {
                Arrays.sort(list);
            }
            for (int i = 0; i < list.length; ++i) {
                FileUtils.copyFiles(new File(src, (String)list[i]), filter, new File(dest, (String)list[i]), inSortedOrder, overwrite);
            }
        } else {
            FileUtils.copyFile(src, dest, overwrite);
        }
    }

    public static boolean copyFile(File src, File dest) throws FileNotFoundException, IOException {
        return FileUtils.copyFile(src, dest, -1L, true);
    }

    public static boolean copyFile(File src, File dest, boolean overwrite) throws FileNotFoundException, IOException {
        return FileUtils.copyFile(src, dest, -1L, overwrite);
    }

    public static boolean copyFile(File src, File dest, long extent) throws FileNotFoundException, IOException {
        return FileUtils.copyFile(src, dest, extent, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File src, File dest, long extent, boolean overwrite) throws FileNotFoundException, IOException {
        boolean result;
        block16: {
            result = false;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Copying file " + src + " to " + dest + " extent " + extent + " exists " + dest.exists());
            }
            if (dest.exists()) {
                if (overwrite) {
                    dest.delete();
                    LOGGER.finer(dest.getAbsolutePath() + " removed before copy.");
                } else {
                    return result;
                }
            }
            FileInputStream fis = null;
            FileOutputStream fos = null;
            AbstractInterruptibleChannel fcin = null;
            AbstractInterruptibleChannel fcout = null;
            try {
                long trans;
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                fcin = fis.getChannel();
                fcout = fos.getChannel();
                if (extent < 0L) {
                    extent = ((FileChannel)fcin).size();
                }
                if ((trans = ((FileChannel)fcin).transferTo(0L, extent, (WritableByteChannel)((Object)fcout))) < extent) {
                    result = false;
                }
                result = true;
            }
            catch (IOException e) {
                String message = "Copying " + src.getAbsolutePath() + " to " + dest.getAbsolutePath() + " with extent " + extent + " got IOE: " + e.getMessage();
                if (e instanceof ClosedByInterruptException || e.getMessage() != null && e.getMessage().equals("Invalid argument")) {
                    LOGGER.severe("Failed copy, trying workaround: " + message);
                    FileUtils.workaroundCopyFile(src, dest);
                    break block16;
                }
                IOException newE = new IOException(message);
                newE.initCause(e);
                throw newE;
            }
            finally {
                if (fcin != null) {
                    fcin.close();
                }
                if (fcout != null) {
                    fcout.close();
                }
                if (fis != null) {
                    fis.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void workaroundCopyFile(File src, File dest) throws IOException {
        FileInputStream from = null;
        FileOutputStream to = null;
        try {
            int bytesRead;
            from = new FileInputStream(src);
            to = new FileOutputStream(dest);
            byte[] buffer = new byte[4096];
            while ((bytesRead = from.read(buffer)) != -1) {
                to.write(buffer, 0, bytesRead);
            }
        }
        finally {
            if (from != null) {
                try {
                    from.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (to != null) {
                try {
                    to.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileUtils.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileAsString(File file) throws IOException {
        StringBuffer sb = new StringBuffer((int)file.length());
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        try {
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                sb.append("\n");
                line = br.readLine();
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    public static File[] getFilesWithPrefix(File dir, final String prefix) {
        FileFilter prefixFilter = new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().startsWith(prefix.toLowerCase());
            }
        };
        return dir.listFiles(prefixFilter);
    }

    public static FileFilter getRegexpFileFilter(String regexp) {
        class RegexpFileFilter
        implements FileFilter {
            Pattern pattern;

            protected RegexpFileFilter(String re) {
                this.pattern = Pattern.compile(re);
            }

            public boolean accept(File pathname) {
                return this.pattern.matcher(pathname.getName()).matches();
            }
        }
        return new RegexpFileFilter(regexp);
    }

    public static void syncDirectories(File src, FilenameFilter filter, File tgt) throws IOException {
        HashSet<String> srcFilenames = null;
        do {
            srcFilenames = new HashSet<String>(Arrays.asList(src.list(filter)));
            List<String> tgtFilenames = Arrays.asList(tgt.list(filter));
            srcFilenames.removeAll(tgtFilenames);
            if (srcFilenames.size() <= 0) continue;
            int count = FileUtils.copyFiles(src, srcFilenames, tgt);
            if (!LOGGER.isLoggable(Level.FINE)) continue;
            LOGGER.fine("Copied " + count);
        } while (srcFilenames != null && srcFilenames.size() > 0);
    }

    public static File isReadable(File f) throws IOException {
        if (!f.exists()) {
            throw new FileNotFoundException(f.getAbsolutePath() + " does not exist.");
        }
        if (!f.canRead()) {
            throw new FileNotFoundException(f.getAbsolutePath() + " is not readable.");
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isReadableWithExtensionAndMagic(File f, String uncompressedExtension, String magic) throws IOException {
        boolean result = false;
        FileUtils.isReadable(f);
        if (f.getName().toLowerCase().endsWith(uncompressedExtension)) {
            FileInputStream fis = new FileInputStream(f);
            try {
                byte[] b = new byte[magic.length()];
                int read = fis.read(b, 0, magic.length());
                fis.close();
                if (read == magic.length()) {
                    StringBuffer beginStr = new StringBuffer(magic.length());
                    for (int i = 0; i < magic.length(); ++i) {
                        beginStr.append((char)b[i]);
                    }
                    if (beginStr.toString().equalsIgnoreCase(magic)) {
                        result = true;
                    }
                }
            }
            finally {
                fis.close();
            }
        }
        return result;
    }

    public static File maybeRelative(File context, String path) {
        File f = new File(path);
        if (f.isAbsolute()) {
            return f;
        }
        return new File(context, path);
    }
}

