/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import junit.framework.TestCase;
import org.archive.util.InterruptibleCharSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterruptibleCharSequenceTest
extends TestCase {
    public static String BACKTRACKER = "^(((((a+)*)*)*)*)*$";
    public static String INPUT = "aaaaab";

    public void xestOverhead() {
        String regex = BACKTRACKER;
        String inputNormal = INPUT;
        InterruptibleCharSequence inputWrapped = new InterruptibleCharSequence(inputNormal);
        this.tryMatch(inputNormal, regex);
        this.tryMatch(inputWrapped, regex);
        int trials = 5;
        long stringTally = 0L;
        long icsTally = 0L;
        for (int i = 1; i <= trials; ++i) {
            System.out.println("trial " + i + " of " + trials);
            long start = System.currentTimeMillis();
            System.out.print("String ");
            this.tryMatch(inputNormal, regex);
            long end = System.currentTimeMillis();
            System.out.println(end - start);
            stringTally += end - start;
            start = System.currentTimeMillis();
            System.out.print("InterruptibleCharSequence ");
            this.tryMatch(inputWrapped, regex);
            end = System.currentTimeMillis();
            System.out.println(end - start);
            icsTally += end - start;
        }
        System.out.println("InterruptibleCharSequence took " + (float)icsTally / (float)stringTally + " longer.");
    }

    public boolean tryMatch(CharSequence input, String regex) {
        return Pattern.matches(regex, input);
    }

    public Thread tryMatchInThread(final CharSequence input, final String regex, final BlockingQueue<Object> atFinish) {
        Thread t = new Thread(){

            public void run() {
                boolean result;
                try {
                    result = InterruptibleCharSequenceTest.this.tryMatch(input, regex);
                }
                catch (Exception e) {
                    atFinish.offer(e);
                    return;
                }
                atFinish.offer(result);
            }
        };
        t.start();
        return t;
    }

    public void testNoninterruptible() throws InterruptedException {
        LinkedBlockingQueue<Object> q = new LinkedBlockingQueue<Object>();
        Thread t = this.tryMatchInThread(INPUT, BACKTRACKER, q);
        Thread.sleep(1000L);
        t.interrupt();
        Object result = q.take();
        InterruptibleCharSequenceTest.assertTrue((String)"mismatch uncompleted", (boolean)Boolean.FALSE.equals(result));
    }

    public void testInterruptibility() throws InterruptedException {
        LinkedBlockingQueue<Object> q = new LinkedBlockingQueue<Object>();
        Thread t = this.tryMatchInThread(new InterruptibleCharSequence(INPUT), BACKTRACKER, q);
        Thread.sleep(1000L);
        t.interrupt();
        Object result = q.take();
        InterruptibleCharSequenceTest.assertTrue((String)"exception not thrown", (boolean)(result instanceof RuntimeException));
    }
}

