/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.SerializationUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoUtils {
    protected static Logger logger = Logger.getLogger(IoUtils.class.getName());

    public static String getClasspathPath(File file) {
        int index;
        String path = file.getPath();
        if (File.separatorChar != '/' && (index = (path = path.replace(File.separatorChar, '/')).indexOf(58)) > 0 && index < 3) {
            path = path.substring(index + 1);
        }
        return path;
    }

    public static File ensureWriteableDirectory(String dir) throws IOException {
        return IoUtils.ensureWriteableDirectory(new File(dir));
    }

    public static List ensureWriteableDirectory(List<File> dirs) throws IOException {
        Iterator<File> i = dirs.iterator();
        while (i.hasNext()) {
            IoUtils.ensureWriteableDirectory(i.next());
        }
        return dirs;
    }

    public static File ensureWriteableDirectory(File dir) throws IOException {
        if (!dir.exists()) {
            dir.mkdirs();
        } else {
            if (!dir.canWrite()) {
                throw new IOException("Dir " + dir.getAbsolutePath() + " not writeable.");
            }
            if (!dir.isDirectory()) {
                throw new IOException("Dir " + dir.getAbsolutePath() + " is not a directory.");
            }
        }
        return dir;
    }

    public static String readFullyAsString(InputStream inputStream) throws IOException {
        int c;
        StringBuffer sb = new StringBuffer();
        while ((c = inputStream.read()) > -1) {
            sb.append((char)c);
        }
        return sb.toString();
    }

    public static String readFullyAsString(Reader r) throws IOException {
        StringBuilder sb = new StringBuilder();
        int c = r.read();
        while (c >= 0) {
            sb.append((char)c);
            c = r.read();
        }
        return sb.toString();
    }

    public static void readFullyToFile(InputStream is, File toFile) throws IOException {
        IoUtils.readFullyToFile(is, toFile, new byte[4096]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readFullyToFile(InputStream is, File toFile, byte[] buffer) throws IOException {
        long totalcount = -1L;
        FastBufferedOutputStream os = new FastBufferedOutputStream((OutputStream)new FileOutputStream(toFile));
        InputStream localIs = is instanceof BufferedInputStream ? is : new BufferedInputStream(is);
        try {
            int count = -1;
            while ((count = localIs.read(buffer, 0, buffer.length)) != -1) {
                os.write(buffer, 0, count);
                totalcount += (long)count;
            }
        }
        finally {
            os.close();
            if (localIs != null) {
                localIs.close();
            }
        }
        return totalcount;
    }

    public static IOException wrapAsIOException(Throwable e) {
        IOException ioe = new IOException(e.toString());
        ioe.initCause(e);
        return ioe;
    }

    public static void readFully(InputStream input, byte[] buf) throws IOException {
        int l;
        int max = buf.length;
        for (int ofs = 0; ofs < max; ofs += l) {
            l = input.read(buf, ofs, max - ofs);
            if (l != 0) continue;
            throw new EOFException();
        }
    }

    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static float encodingMaxBytesPerChar(String encoding) {
        boolean isMultibyte = false;
        try {
            if (encoding != null && encoding.length() > 0) {
                Charset cs = Charset.forName(encoding);
                if (cs.canEncode()) {
                    return cs.newEncoder().maxBytesPerChar();
                }
                logger.info("Encoding not fully supported: " + encoding + ".  Defaulting to single byte.");
            }
        }
        catch (IllegalArgumentException e) {
            logger.log(Level.INFO, "Illegal encoding name: " + encoding, e);
        }
        logger.fine("Encoding " + encoding + " is multibyte: " + (isMultibyte ? Boolean.TRUE : Boolean.FALSE));
        return 0.0f;
    }

    public static void serializeToFile(Object object, File file) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
        oos.writeObject(object);
        oos.close();
    }

    public static Object deserializeFromFile(File file) throws IOException {
        Object object;
        ObjectInputStream ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(file)));
        try {
            object = ois.readObject();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ois.close();
        return object;
    }

    public static byte[] serializeToByteArray(Object object) {
        return SerializationUtils.serialize((Serializable)((Serializable)object));
    }

    public static Object deserializeFromByteArray(byte[] in) {
        return SerializationUtils.deserialize((byte[])in);
    }
}

