/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import java.lang.reflect.Constructor;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import org.archive.util.JEMBeanHelper;

public class JEApplicationMBean
implements DynamicMBean {
    private static final String DESCRIPTION = "A MBean for an application which uses JE. Provides open and close operations which configure and open a JE environment as part of the applications's resources. Also supports general JE monitoring.";
    private MBeanInfo mbeanInfo;
    private JEMBeanHelper jeHelper;
    private Environment targetEnv;
    public static final String OP_OPEN = "openJE";
    public static final String OP_CLOSE = "closeJE";

    public JEApplicationMBean(Environment env) throws DatabaseException {
        this.targetEnv = env;
        this.jeHelper = new JEMBeanHelper(env.getConfig(), env.getHome(), true);
        this.resetMBeanInfo();
    }

    public Object getAttribute(String attributeName) throws AttributeNotFoundException, MBeanException {
        return this.jeHelper.getAttribute(this.targetEnv, attributeName);
    }

    public void setAttribute(Attribute attribute) throws AttributeNotFoundException, InvalidAttributeValueException {
        this.jeHelper.setAttribute(this.targetEnv, attribute);
    }

    public AttributeList getAttributes(String[] attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("Attributes cannot be null");
        }
        AttributeList results = new AttributeList();
        for (int i = 0; i < attributes.length; ++i) {
            try {
                String name = attributes[i];
                Object value = this.jeHelper.getAttribute(this.targetEnv, name);
                results.add(new Attribute(name, value));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public AttributeList setAttributes(AttributeList attributes) {
        if (attributes == null) {
            throw new IllegalArgumentException("attribute list can't be null");
        }
        AttributeList results = new AttributeList();
        for (int i = 0; i < attributes.size(); ++i) {
            Attribute attr = (Attribute)attributes.get(i);
            try {
                this.jeHelper.setAttribute(this.targetEnv, attr);
                String name = attr.getName();
                Object newValue = this.jeHelper.getAttribute(this.targetEnv, name);
                results.add(new Attribute(name, newValue));
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public Object invoke(String actionName, Object[] params, String[] signature) throws MBeanException {
        Object result = null;
        if (actionName == null) {
            throw new IllegalArgumentException("actionName cannot be null");
        }
        result = this.jeHelper.invoke(this.targetEnv, actionName, params, signature);
        return result;
    }

    public MBeanInfo getMBeanInfo() {
        return this.mbeanInfo;
    }

    private synchronized void resetMBeanInfo() {
        List<MBeanAttributeInfo> attributeList = this.jeHelper.getAttributeList(this.targetEnv);
        MBeanAttributeInfo[] attributeInfo = new MBeanAttributeInfo[attributeList.size()];
        attributeList.toArray(attributeInfo);
        Constructor<?>[] constructors = this.getClass().getConstructors();
        MBeanConstructorInfo[] constructorInfo = new MBeanConstructorInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            constructorInfo[i] = new MBeanConstructorInfo(this.getClass().getName(), constructors[i]);
        }
        List<MBeanOperationInfo> operationList = this.jeHelper.getOperationList(this.targetEnv);
        MBeanOperationInfo[] operationInfo = new MBeanOperationInfo[operationList.size()];
        operationList.toArray(operationInfo);
        MBeanNotificationInfo[] notificationInfo = this.jeHelper.getNotificationInfo(this.targetEnv);
        this.mbeanInfo = new MBeanInfo(this.getClass().getName(), DESCRIPTION, attributeInfo, constructorInfo, operationInfo, notificationInfo);
    }
}

