/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.RuntimeOperationsException;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfo;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenMBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JmxUtils {
    private static final Logger LOGGER = Logger.getLogger(JmxUtils.class.getName());
    public static final String TYPE = "type";
    public static final String SERVICE = "CrawlService";
    public static final String JOB = "CrawlService.Job";
    public static final String NAME = "name";
    public static final String HOST = "host";
    public static final String JMX_PORT = "jmxport";
    public static final String GUI_PORT = "guiport";
    public static final String KEY = "key";
    public static final String MOTHER = "mother";
    public static final ObjectName MBEAN_SERVER_DELEGATE;
    private static final List OPENTYPES;

    protected JmxUtils() {
    }

    public static String getLogRegistrationMsg(String mbeanName, MBeanServer mbeanServer, boolean registrationDone) {
        return mbeanName + (registrationDone ? " " : " NOT ") + "registered to " + JmxUtils.getServerDetail(mbeanServer);
    }

    public static String getLogUnregistrationMsg(String mbeanName, MBeanServer mbeanServer) {
        return mbeanName + " unregistered from " + JmxUtils.getServerDetail(mbeanServer);
    }

    public static String getServerDetail(MBeanServer server) {
        ObjectName delegateName = null;
        try {
            delegateName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException e) {
            LOGGER.log(Level.SEVERE, "Failed to create ObjectName for JMImplementation:type=MBeanServerDelegate", e);
            return null;
        }
        StringBuffer buffer = new StringBuffer("MBeanServerId=");
        try {
            buffer.append((String)server.getAttribute(delegateName, "MBeanServerId"));
            buffer.append(", SpecificationVersion=");
            buffer.append((String)server.getAttribute(delegateName, "SpecificationVersion"));
            buffer.append(", ImplementationVersion=");
            buffer.append((String)server.getAttribute(delegateName, "ImplementationVersion"));
            buffer.append(", SpecificationVendor=");
            buffer.append((String)server.getAttribute(delegateName, "SpecificationVendor"));
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed gettting server detail for JMImplementation:type=MBeanServerDelegate", e);
        }
        return buffer.toString();
    }

    public static void checkParamsCount(String operationName, Object[] params, int count) {
        if (params.length != count) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Cannot invoke " + operationName + ": Passed " + Integer.toString(params.length) + " argument(s) " + "but expected " + Integer.toString(count)), "Wrong number of arguments passed: unable to invoke " + operationName + " method");
        }
    }

    public static OpenMBeanOperationInfo convertToOpenMBeanOperation(MBeanOperationInfo in) {
        return JmxUtils.convertToOpenMBeanOperation(in, null, null);
    }

    public static OpenMBeanOperationInfo convertToOpenMBeanOperation(MBeanOperationInfo in, String prefix, OpenType returnType) {
        MBeanParameterInfo[] params = in.getSignature();
        OpenMBeanParameterInfo[] signature = new OpenMBeanParameterInfo[params.length];
        for (int i = 0; i < params.length; ++i) {
            signature[i] = JmxUtils.convertToOpenMBeanOperationInfo(params[i]);
        }
        return new OpenMBeanOperationInfoSupport(prefix != null ? prefix + in.getName() : in.getName(), in.getDescription(), signature, returnType != null ? returnType : JmxUtils.getOpenType(in.getReturnType()), JmxUtils.convertImpact(in.getImpact()));
    }

    public static int convertImpact(int impact) {
        if (impact != 1 && impact != 2 && impact != 0) {
            return 2;
        }
        return impact;
    }

    public static OpenMBeanParameterInfo convertToOpenMBeanOperationInfo(MBeanParameterInfo in) {
        return new OpenMBeanParameterInfoSupport(in.getName(), in.getDescription(), JmxUtils.getOpenType(in.getType()));
    }

    public static boolean isOpenType(Class c) {
        return JmxUtils.isOpenType(c.getName());
    }

    public static boolean isOpenType(String classname) {
        return OPENTYPES.contains(classname);
    }

    public static OpenType getOpenType(String classString) {
        return JmxUtils.getOpenType(classString, null);
    }

    public static OpenType getOpenType(String classString, OpenType defaultType) {
        if (classString.equals("void")) {
            return SimpleType.VOID;
        }
        if (!JmxUtils.isOpenType(classString)) {
            throw new InvalidOpenTypeException(classString);
        }
        if (classString.equals(String.class.getName())) {
            return SimpleType.STRING;
        }
        if (classString.equals(Boolean.class.getName())) {
            return SimpleType.BOOLEAN;
        }
        if (classString.equals(Long.class.getName())) {
            return SimpleType.LONG;
        }
        if (classString.equals(Integer.class.getName())) {
            return SimpleType.INTEGER;
        }
        if (classString.equals(Float.class.getName())) {
            return SimpleType.FLOAT;
        }
        if (classString.equals(Double.class.getName())) {
            return SimpleType.DOUBLE;
        }
        if (defaultType != null) {
            return defaultType;
        }
        throw new RuntimeException("Unsupported type: " + classString);
    }

    public static OpenMBeanAttributeInfo convertToOpenMBeanAttribute(MBeanAttributeInfo in) {
        return JmxUtils.convertToOpenMBeanAttribute(in, null);
    }

    public static OpenMBeanAttributeInfo convertToOpenMBeanAttribute(MBeanAttributeInfo in, String prefix) {
        return JmxUtils.createOpenMBeanAttributeInfo(JmxUtils.getOpenType(in.getType()), in, prefix);
    }

    public static OpenMBeanAttributeInfo createOpenMBeanAttributeInfo(OpenType type, MBeanAttributeInfo in, String prefix) {
        return new OpenMBeanAttributeInfoSupport(prefix != null ? prefix + in.getName() : in.getName(), in.getDescription(), type, in.isReadable(), in.isWritable(), in.isIs());
    }

    public static CompositeType createCompositeType(Map m, String compositeTypeName, String compositeTypeDescription) throws OpenDataException {
        String[] keys = new String[m.size()];
        OpenType[] types = new OpenType[m.size()];
        int index = 0;
        Iterator i = m.keySet().iterator();
        while (i.hasNext()) {
            String key;
            keys[index] = key = (String)i.next();
            types[index] = JmxUtils.getOpenType(m.get(key).getClass().getName());
            ++index;
        }
        return new CompositeType(compositeTypeName, compositeTypeDescription, keys, keys, types);
    }

    public static InetSocketAddress extractAddress(ObjectName name) {
        return new InetSocketAddress(name.getKeyProperty(HOST), Integer.parseInt(name.getKeyProperty(JMX_PORT)));
    }

    public static String getUid(ObjectName on) {
        String name = on.getKeyProperty(NAME);
        return name.substring(name.indexOf("-") + 1);
    }

    public static ObjectName makeObjectName(String domain, String name, String type, String ... keyValuePairs) {
        if (keyValuePairs.length % 2 != 0) {
            throw new IllegalArgumentException("Missing value in key/value pairs.");
        }
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put(NAME, name);
        ht.put(TYPE, type);
        for (int i = 0; i < keyValuePairs.length; i += 2) {
            ht.put(keyValuePairs[i], keyValuePairs[i + 1]);
        }
        try {
            return new ObjectName(domain, ht);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Set<ObjectName> find(MBeanServerConnection conn, String query) {
        try {
            Set<ObjectName> set = conn.queryNames(null, new ObjectName(query));
            return set;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalStateException(e);
        }
    }

    public static ObjectName findUnique(MBeanServerConnection conn, String query) {
        Set<ObjectName> set = JmxUtils.find(conn, query);
        int size = set.size();
        if (size == 1) {
            return set.iterator().next();
        }
        throw new IllegalStateException("Expected unique MBean for " + query + " but found " + set);
    }

    static {
        try {
            MBEAN_SERVER_DELEGATE = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        OPENTYPES = Arrays.asList(OpenType.ALLOWED_CLASSNAMES);
    }
}

