/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PatternMatcherRecycler {
    private static final int MAXIMUM_STACK_SIZE = 10;
    private Pattern pattern;
    private Stack<Matcher> matchers;

    public PatternMatcherRecycler(Pattern p) {
        this.pattern = p;
        this.matchers = new Stack();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Matcher getMatcher(CharSequence input) {
        if (input == null) {
            throw new IllegalArgumentException("CharSequence 'input' must not be null");
        }
        try {
            return this.matchers.pop().reset(input);
        }
        catch (EmptyStackException e) {
            return this.pattern.matcher(input);
        }
    }

    public void freeMatcher(Matcher m) {
        if (this.matchers.size() < 10) {
            this.matchers.push(m);
        }
    }
}

