/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.RecordingInputStream;
import org.archive.io.RecordingOutputStream;
import org.archive.io.ReplayCharSequence;
import org.archive.io.ReplayInputStream;
import org.archive.util.DevUtils;
import org.archive.util.RecorderMarker;

public class Recorder {
    protected static Logger logger = Logger.getLogger("org.archive.util.HttpRecorder");
    private static final int DEFAULT_OUTPUT_BUFFER_SIZE = 4096;
    private static final int DEFAULT_INPUT_BUFFER_SIZE = 65536;
    private RecordingInputStream ris = null;
    private RecordingOutputStream ros = null;
    private String backingFileBasename = null;
    private static final String RECORDING_OUTPUT_STREAM_SUFFIX = ".ros";
    private static final String RECORDING_INPUT_STREAM_SUFFIX = ".ris";
    private String characterEncoding = null;

    public Recorder(File tempDir, String backingFilenameBase, int outBufferSize, int inBufferSize) {
        this(Recorder.ensure(new File(tempDir, backingFilenameBase)), outBufferSize, inBufferSize);
        tempDir.mkdirs();
    }

    private static File ensure(File tempDir) {
        tempDir.mkdirs();
        return tempDir;
    }

    public Recorder(File file, int outBufferSize, int inBufferSize) {
        this.backingFileBasename = file.getAbsolutePath();
        this.ris = new RecordingInputStream(inBufferSize, this.backingFileBasename + RECORDING_INPUT_STREAM_SUFFIX);
        this.ros = new RecordingOutputStream(outBufferSize, this.backingFileBasename + RECORDING_OUTPUT_STREAM_SUFFIX);
    }

    public Recorder(File tempDir, String backingFilenameBase) {
        this(tempDir, backingFilenameBase, 65536, 4096);
    }

    public InputStream inputWrap(InputStream is) throws IOException {
        logger.fine(Thread.currentThread().getName() + " wrapping input");
        this.ris.open(is);
        return this.ris;
    }

    public OutputStream outputWrap(OutputStream os) throws IOException {
        this.ros.open(os);
        return this.ros;
    }

    public void close() {
        logger.fine(Thread.currentThread().getName() + " closing");
        try {
            this.ris.close();
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, "close() ris" + DevUtils.extraInfo(), e);
        }
        try {
            this.ros.close();
        }
        catch (IOException e) {
            DevUtils.logger.log(Level.SEVERE, "close() ros" + DevUtils.extraInfo(), e);
        }
    }

    public RecordingInputStream getRecordedInput() {
        return this.ris;
    }

    public RecordingOutputStream getRecordedOutput() {
        return this.ros;
    }

    public void markContentBegin() {
        this.ris.markContentBegin();
    }

    public long getResponseContentLength() {
        return this.ris.getResponseContentLength();
    }

    public void closeRecorders() {
        try {
            this.ris.closeRecorder();
            this.ros.closeRecorder();
        }
        catch (IOException e) {
            DevUtils.warnHandle(e, "Convert to runtime exception?");
        }
    }

    public void cleanup() {
        this.close();
        this.delete(this.backingFileBasename + RECORDING_OUTPUT_STREAM_SUFFIX);
        this.delete(this.backingFileBasename + RECORDING_INPUT_STREAM_SUFFIX);
    }

    private void delete(String name) {
        File f = new File(name);
        if (f.exists()) {
            f.delete();
        }
    }

    public static Recorder getHttpRecorder() {
        Recorder recorder = null;
        Thread thread = Thread.currentThread();
        if (thread instanceof RecorderMarker) {
            recorder = ((RecorderMarker)((Object)thread)).getHttpRecorder();
        }
        return recorder;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public ReplayCharSequence getReplayCharSequence() throws IOException {
        return this.getRecordedInput().getReplayCharSequence(this.characterEncoding);
    }

    public ReplayInputStream getReplayInputStream() throws IOException {
        return this.getRecordedInput().getReplayInputStream();
    }

    public static Recorder wrapInputStreamWithHttpRecord(File dir, String basename, InputStream in, String encoding) throws IOException {
        int x;
        Recorder rec = new Recorder(dir, basename);
        if (encoding != null && encoding.length() > 0) {
            rec.setCharacterEncoding(encoding);
        }
        InputStream is = rec.inputWrap(new BufferedInputStream(in));
        rec.markContentBegin();
        int BUFFER_SIZE = 4096;
        byte[] buffer = new byte[4096];
        while ((x = is.read(buffer)) != -1) {
        }
        is.close();
        return rec;
    }
}

