/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubList<E>
extends AbstractList<E>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<E> delegate;
    private int start;
    private int end;

    public SubList(List<E> delegate, int start, int end) {
        if (start < 0 || start > delegate.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < 0 || end > delegate.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (end < start) {
            throw new IllegalArgumentException();
        }
        this.delegate = delegate;
        this.start = start;
        this.end = end;
    }

    private void ensureInside(int index) {
        if (index < 0 || index >= this.end - this.start) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void ensureBorder(int index) {
        if (index < 0 || index > this.end - this.start) {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    public E get(int index) {
        this.ensureInside(index);
        return this.delegate.get(this.start + index);
    }

    @Override
    public int size() {
        return this.end - this.start;
    }

    @Override
    public E set(int index, E value) {
        this.ensureInside(index);
        return this.delegate.set(this.start + index, value);
    }

    @Override
    public void add(int index, E value) {
        this.ensureBorder(index);
        this.delegate.add(this.start + index, value);
        ++this.end;
    }

    @Override
    public E remove(int index) {
        this.ensureInside(index);
        return this.delegate.remove(this.start + index);
    }
}

