/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Iterator;
import org.archive.net.UURI;
import org.archive.util.PrefixSet;
import org.archive.util.SURT;
import org.archive.util.iterator.LineReadingIterator;
import org.archive.util.iterator.RegexpLineIterator;

public class SurtPrefixSet
extends PrefixSet {
    private static final long serialVersionUID = 2598365040524933110L;
    private static final String SURT_PREFIX_DIRECTIVE = "+";

    public void importFrom(Reader r) {
        BufferedReader reader = new BufferedReader(r);
        RegexpLineIterator iter = new RegexpLineIterator(new LineReadingIterator(reader), "\\s*(#.*)?", "^\\s*(\\S+)\\s*(#.*)?$", "$1");
        while (iter.hasNext()) {
            String s = (String)iter.next();
            this.add(s.toLowerCase());
        }
    }

    public void importFromUris(Reader r) {
        BufferedReader reader = new BufferedReader(r);
        RegexpLineIterator iter = new RegexpLineIterator(new LineReadingIterator(reader), "\\s*(#.*)?", "^\\s*(\\S+)\\s*(#.*)?$", "$1");
        while (iter.hasNext()) {
            String s = (String)iter.next();
            this.addFromPlain(s);
        }
    }

    public void importFromMixed(Reader r, boolean deduceFromSeeds) {
        BufferedReader reader = new BufferedReader(r);
        RegexpLineIterator iter = new RegexpLineIterator(new LineReadingIterator(reader), "\\s*(#.*)?", "^\\s*(\\S+)\\s*(#.*)?$", "$1");
        while (iter.hasNext()) {
            String s = (String)iter.next();
            if (s.startsWith(SURT_PREFIX_DIRECTIVE)) {
                String u = s.substring(SURT_PREFIX_DIRECTIVE.length()).trim();
                if (u.indexOf("(") > 0) {
                    this.add(u.toLowerCase());
                    continue;
                }
                this.addFromPlain(u);
                continue;
            }
            if (!deduceFromSeeds) continue;
            this.addFromPlain(s);
        }
    }

    private void addFromPlain(String u) {
        u = SurtPrefixSet.prefixFromPlainForceHttp(u);
        this.add(u);
    }

    public static String prefixFromPlainForceHttp(String u) {
        u = SURT.prefixFromPlain(u);
        u = SurtPrefixSet.coerceFromHttpsForComparison(u);
        return u;
    }

    private static String coerceFromHttpsForComparison(String u) {
        if (u.startsWith("https://")) {
            u = "http" + u.substring("https".length());
        }
        return u;
    }

    public static String asPrefix(String s) {
        if (!(s = s.replaceAll("^(.*//.*/)[^/]*", "$1")).endsWith("/")) {
            s = s.replaceAll("^(.*)\\)", "$1");
        }
        return s;
    }

    public static String getCandidateSurt(UURI u) {
        if (u == null) {
            return null;
        }
        String candidateSurt = u.getSurtForm();
        candidateSurt = SurtPrefixSet.coerceFromHttpsForComparison(candidateSurt);
        return candidateSurt;
    }

    public void exportTo(FileWriter fw) throws IOException {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            fw.write((String)iter.next() + "\n");
        }
    }

    public void convertAllPrefixesToHosts() {
        SurtPrefixSet iterCopy = (SurtPrefixSet)this.clone();
        for (String prefix : iterCopy) {
            String convPrefix;
            if (prefix == (convPrefix = SurtPrefixSet.convertPrefixToHost(prefix))) continue;
            this.remove(prefix);
            this.add(convPrefix);
        }
    }

    public static String convertPrefixToHost(String prefix) {
        if (prefix.endsWith(")")) {
            return prefix;
        }
        if (prefix.indexOf(41) < 0) {
            if (!prefix.endsWith(",")) {
                prefix = prefix + ",";
            }
            prefix = prefix + ")";
        } else {
            prefix = prefix.substring(0, prefix.indexOf(41) + 1);
        }
        return prefix;
    }

    public void convertAllPrefixesToDomains() {
        SurtPrefixSet iterCopy = (SurtPrefixSet)this.clone();
        for (String prefix : iterCopy) {
            String convPrefix;
            if (prefix == (convPrefix = SurtPrefixSet.convertPrefixToDomain(prefix))) continue;
            this.remove(prefix);
            this.add(convPrefix);
        }
    }

    public static String convertPrefixToDomain(String prefix) {
        if (prefix.indexOf(41) >= 0) {
            prefix = prefix.substring(0, prefix.indexOf(41));
        }
        if (prefix.endsWith("www,")) {
            prefix = prefix.substring(0, prefix.length() - 4);
        }
        return prefix;
    }

    public static void main(String[] args) throws IOException {
        String line;
        InputStream in = args.length > 0 ? new BufferedInputStream(new FileInputStream(args[0])) : System.in;
        PrintStream out = args.length > 1 ? new PrintStream(new BufferedOutputStream(new FileOutputStream(args[1]))) : System.out;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            if (line.indexOf("#") > 0) {
                line = line.substring(0, line.indexOf("#"));
            }
            if ((line = line.trim()).length() == 0) continue;
            out.println(SurtPrefixSet.prefixFromPlainForceHttp(line));
        }
        br.close();
        out.close();
    }
}

