/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import org.archive.util.TransformIterator;
import org.archive.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Transform<Original, Transformed>
extends AbstractCollection<Transformed> {
    private final Collection<? extends Original> delegate;
    private final Transformer<Original, Transformed> transformer;

    public Transform(Collection<? extends Original> delegate, Transformer<Original, Transformed> transformer) {
        this.delegate = delegate;
        this.transformer = transformer;
    }

    @Override
    public int size() {
        int count = 0;
        Iterator<Transformed> iter = this.iterator();
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    @Override
    public Iterator<Transformed> iterator() {
        return new TransformIterator<Original, Transformed>(this.delegate.iterator(), this.transformer);
    }

    public static <Target> Collection<Target> subclasses(Collection<? extends Object> c, final Class<Target> cls) {
        Transformer t = new Transformer<Object, Target>(){

            @Override
            public Target transform(Object s) {
                if (cls.isInstance(s)) {
                    return cls.cast(s);
                }
                return null;
            }
        };
        return new Transform(c, t);
    }
}

