/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Iterator;
import org.archive.util.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformIterator<Original, Transformed>
implements Iterator<Transformed> {
    private final Iterator<? extends Original> iterator;
    private final Transformer<Original, Transformed> transformer;
    private Transformed next;

    public TransformIterator(Iterator<? extends Original> iterator, Transformer<Original, Transformed> transformer) {
        this.iterator = iterator;
        this.transformer = transformer;
    }

    @Override
    public boolean hasNext() {
        if (this.next != null) {
            return true;
        }
        while (this.iterator.hasNext()) {
            Original o = this.iterator.next();
            this.next = this.transformer.transform(o);
            if (this.next == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public Transformed next() {
        if (!this.hasNext()) {
            throw new IllegalStateException();
        }
        Transformed r = this.next;
        this.next = null;
        return r;
    }

    @Override
    public void remove() {
        this.iterator.remove();
    }
}

