/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.fingerprint;

import org.archive.util.fingerprint.LongFPSet;

public class ArrayLongFPCache
implements LongFPSet {
    public static final int DEFAULT_CAPACITY = 0x100000;
    public static final int DEFAULT_SMEAR = 5;
    long[] cache = new long[0x100000];
    int smear = 5;
    int count = 0;

    public void setCapacity(int newCapacity) {
        long[] oldCache = this.cache;
        this.cache = new long[newCapacity];
        for (int i = 0; i < oldCache.length; ++i) {
            this.add(oldCache[i]);
        }
    }

    public boolean add(long l) {
        if (this.contains(l)) {
            return false;
        }
        int index = (Math.abs((int)(l % (long)this.cache.length)) + this.count % this.smear) % this.cache.length;
        ++this.count;
        this.cache[index] = l;
        return true;
    }

    public boolean contains(long l) {
        int index;
        for (int i = index = Math.abs((int)(l % (long)this.cache.length)); i < index + this.smear; ++i) {
            if (this.cache[i % this.cache.length] != l) continue;
            return true;
        }
        return false;
    }

    public boolean remove(long l) {
        int index;
        for (int i = index = Math.abs((int)(l % (long)this.cache.length)); i < index + this.smear; ++i) {
            if (this.cache[i % this.cache.length] != l) continue;
            this.cache[i % this.cache.length] = 0L;
            this.count = Math.min(this.count, this.cache.length);
            --this.count;
            return true;
        }
        return false;
    }

    public long count() {
        return Math.min(this.count, this.cache.length);
    }

    public boolean quickContains(long fp) {
        return this.contains(fp);
    }

    public int cacheLength() {
        return this.cache.length;
    }
}

