/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.fingerprint;

import java.io.Serializable;
import java.util.logging.Logger;
import org.archive.util.AbstractLongFPSet;
import org.archive.util.fingerprint.LongFPSet;

public class MemLongFPSet
extends AbstractLongFPSet
implements LongFPSet,
Serializable {
    private static final long serialVersionUID = -4301879539092625698L;
    private static Logger logger = Logger.getLogger(MemLongFPSet.class.getName());
    private static final int DEFAULT_CAPACITY_POWER_OF_TWO = 10;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    protected byte[] slots;
    protected long[] values;

    public MemLongFPSet() {
        this(10, 0.75f);
    }

    public MemLongFPSet(int capacityPowerOfTwo, float loadFactor) {
        super(capacityPowerOfTwo, loadFactor);
        this.slots = new byte[1 << capacityPowerOfTwo];
        for (int i = 0; i < 1 << capacityPowerOfTwo; ++i) {
            this.slots[i] = EMPTY;
        }
        this.values = new long[1 << capacityPowerOfTwo];
    }

    protected void setAt(long i, long val) {
        this.slots[(int)i] = 1;
        this.values[(int)i] = val;
    }

    protected long getAt(long i) {
        return this.values[(int)i];
    }

    protected void makeSpace() {
        this.grow();
    }

    private void grow() {
        int i;
        logger.info("Doubling fingerprinting slots to " + (1 << this.capacityPowerOfTwo));
        long[] oldValues = this.values;
        byte[] oldSlots = this.slots;
        ++this.capacityPowerOfTwo;
        this.values = new long[1 << this.capacityPowerOfTwo];
        this.slots = new byte[1 << this.capacityPowerOfTwo];
        for (i = 0; i < 1 << this.capacityPowerOfTwo; ++i) {
            this.slots[i] = EMPTY;
        }
        this.count = 0L;
        for (i = 0; i < oldValues.length; ++i) {
            if (oldSlots[i] < 0) continue;
            this.add(oldValues[i]);
        }
    }

    protected void relocate(long val, long oldIndex, long newIndex) {
        this.values[(int)newIndex] = this.values[(int)oldIndex];
        this.slots[(int)newIndex] = this.slots[(int)oldIndex];
        this.slots[(int)oldIndex] = EMPTY;
    }

    protected int getSlotState(long i) {
        return this.slots[(int)i];
    }

    protected void clearAt(long index) {
        this.slots[(int)index] = EMPTY;
        this.values[(int)index] = 0L;
    }

    public boolean quickContains(long fp) {
        return this.contains(fp);
    }
}

