/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.util.Iterator;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.archive.util.iterator.TransformingIteratorWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegexpLineIterator
extends TransformingIteratorWrapper<String, String> {
    private static final Logger logger = Logger.getLogger(RegexpLineIterator.class.getName());
    public static final String COMMENT_LINE = "\\s*(#.*)?";
    public static final String NONWHITESPACE_ENTRY_TRAILING_COMMENT = "^\\s*(\\S+)\\s*(#.*)?$";
    public static final String TRIMMED_ENTRY_TRAILING_COMMENT = "^\\s*([^#]+?)\\s*(#.*)?$";
    public static final String ENTRY = "$1";
    protected Matcher ignoreLine = null;
    protected Matcher extractLine = null;
    protected String outputTemplate = null;

    public RegexpLineIterator(Iterator<String> inner, String ignore, String extract, String replace) {
        this.inner = inner;
        this.ignoreLine = Pattern.compile(ignore).matcher("");
        this.extractLine = Pattern.compile(extract).matcher("");
        this.outputTemplate = replace;
    }

    @Override
    protected String transform(String line) {
        this.ignoreLine.reset(line);
        if (this.ignoreLine.matches()) {
            return null;
        }
        this.extractLine.reset(line);
        if (this.extractLine.matches()) {
            StringBuffer output = new StringBuffer();
            this.extractLine.appendReplacement(output, this.outputTemplate);
            return output.toString();
        }
        logger.warning("line not extracted nor no-op: " + line);
        return null;
    }
}

