/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.io.IOException;
import org.archive.io.SeekInputStream;
import org.archive.util.ms.BlockFileSystem;

public class BlockInputStream
extends SeekInputStream {
    private int start;
    private int block;
    private BlockFileSystem bfs;
    private SeekInputStream raw;
    private long position;
    private long expectedRawPosition;
    private int blockBytesRead;

    public BlockInputStream(BlockFileSystem bfs, int block) throws IOException {
        this.raw = bfs.getRawInput();
        this.bfs = bfs;
        this.start = block;
        this.block = block;
        this.position = 0L;
        this.seek(block, 0L);
    }

    private void seek(long block, long rem) throws IOException {
        assert (rem < 512L);
        long pos = (block + 1L) * 512L + rem;
        this.blockBytesRead = (int)rem;
        this.expectedRawPosition = pos;
        this.raw.position(pos);
    }

    private void ensureRawPosition() throws IOException {
        if (this.raw.position() != this.expectedRawPosition) {
            this.raw.position(this.expectedRawPosition);
        }
    }

    private boolean ensureBuffer() throws IOException {
        if (this.block < 0) {
            return false;
        }
        this.ensureRawPosition();
        if (this.blockBytesRead < 512) {
            return true;
        }
        this.block = this.bfs.getNextBlock(this.block);
        if (this.block < 0) {
            return false;
        }
        this.seek(this.block, 0L);
        return true;
    }

    public long skip(long v) throws IOException {
        int r = this.read();
        return r < 0 ? 0L : 1L;
    }

    public int read() throws IOException {
        if (!this.ensureBuffer()) {
            return -1;
        }
        int r = this.raw.read();
        ++this.position;
        ++this.expectedRawPosition;
        ++this.blockBytesRead;
        return r;
    }

    public int read(byte[] b, int ofs, int len) throws IOException {
        if (!this.ensureBuffer()) {
            return 0;
        }
        int rem = 512 - (int)(this.position % 512L);
        len = Math.min(len, rem);
        int c = this.raw.read(b, ofs, len);
        this.position += (long)c;
        this.expectedRawPosition += (long)c;
        ++this.blockBytesRead;
        return len;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public long position() {
        return this.position;
    }

    public void position(long v) throws IOException {
        this.ensureRawPosition();
        if (v == this.position) {
            return;
        }
        if (v / 512L == this.position / 512L) {
            long rem = v % 512L;
            this.seek(this.block, rem);
            this.position = v;
            return;
        }
        if (v > this.position) {
            this.seekAfter(v);
        } else {
            this.seekBefore(v);
        }
    }

    private void seekAfter(long v) throws IOException {
        long currentBlock = this.position / 512L;
        long destBlock = v / 512L;
        long blockAdvance = destBlock - currentBlock;
        int i = 0;
        while ((long)i < blockAdvance) {
            this.block = this.bfs.getNextBlock(this.block);
            ++i;
        }
        this.seek(this.block, v % 512L);
        this.position = v;
    }

    private void seekBefore(long v) throws IOException {
        long blockAdvance = (v - 1L) / 512L;
        this.block = this.start;
        int i = 0;
        while ((long)i < blockAdvance) {
            this.block = this.bfs.getNextBlock(this.block);
            ++i;
        }
        this.seek(this.block, v % 512L);
    }
}

