/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import org.archive.io.SeekInputStream;
import org.archive.util.IoUtils;
import org.archive.util.LRU;
import org.archive.util.ms.BlockFileSystem;
import org.archive.util.ms.DefaultEntry;
import org.archive.util.ms.Entry;
import org.archive.util.ms.HeaderBlock;

public class DefaultBlockFileSystem
implements BlockFileSystem {
    private static final int POINTERS_PER_BAT = 128;
    private static final int BAT_POINTER_SIZE = 4;
    private static final int HEADER_BAT_LIMIT = 109;
    private static final int ENTRY_SIZE = 128;
    private static final int ENTRIES_PER_BLOCK = 4;
    private SeekInputStream input;
    private HeaderBlock header;
    private Map<Integer, ByteBuffer> cache;

    public DefaultBlockFileSystem(SeekInputStream input, int batCacheSize) throws IOException {
        this.input = input;
        byte[] temp = new byte[512];
        IoUtils.readFully(input, temp);
        this.header = new HeaderBlock(ByteBuffer.wrap(temp));
        this.cache = new LRU<Integer, ByteBuffer>(batCacheSize);
    }

    public Entry getRoot() throws IOException {
        int block = this.header.getEntriesStart();
        this.input.position((block + 1) * 512);
        return new DefaultEntry(this, this.input, 0);
    }

    Entry getEntry(int entryNumber) throws IOException {
        if (entryNumber < 0) {
            return null;
        }
        int blockCount = entryNumber / 4;
        int remainder = entryNumber % 4;
        int block = this.header.getEntriesStart();
        for (int i = 0; i < blockCount; ++i) {
            block = this.getNextBlock(block);
        }
        if (block < 0) {
            return null;
        }
        int filePos = (block + 1) * 512 + remainder * 128;
        this.input.position(filePos);
        return new DefaultEntry(this, this.input, entryNumber);
    }

    public int getNextBlock(int block) throws IOException {
        if (block < 0) {
            return block;
        }
        int headerIndex = block / 128;
        int batBlockIndex = block % 128;
        int batBlockNumber = this.batLookup(headerIndex);
        ByteBuffer batBlock = this.getBATBlock(batBlockNumber);
        return batBlock.getInt(batBlockIndex * 4);
    }

    private int batLookup(int headerIndex) throws IOException {
        if (headerIndex < 110) {
            return this.header.getBATBlockNumber(headerIndex);
        }
        int xbatBlockNumber = (headerIndex -= 109) / 128;
        ByteBuffer xbat = this.getBATBlock(xbatBlockNumber += this.header.getExtendedBATStart());
        int xbatBlockIndex = headerIndex % 128;
        return xbat.getInt(xbatBlockIndex * 4);
    }

    private ByteBuffer getBATBlock(int block) throws IOException {
        ByteBuffer r = this.cache.get(block);
        if (r != null) {
            return r;
        }
        byte[] buf = new byte[512];
        this.input.position((block + 1) * 512);
        IoUtils.readFully(this.input, buf);
        r = ByteBuffer.wrap(buf);
        r.order(ByteOrder.LITTLE_ENDIAN);
        this.cache.put(block, r);
        return r;
    }

    public SeekInputStream getRawInput() {
        return this.input;
    }
}

