/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import org.archive.io.SeekInputStream;
import org.archive.util.IoUtils;
import org.archive.util.ms.BlockInputStream;
import org.archive.util.ms.DefaultBlockFileSystem;
import org.archive.util.ms.Entry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultEntry
implements Entry {
    private DefaultBlockFileSystem origin;
    private String name;
    private Entry.EntryType type;
    private int previous;
    private int next;
    private int child;
    private int startBlock;
    private int size;
    private int index;

    public DefaultEntry(DefaultBlockFileSystem origin, SeekInputStream input, int index) throws IOException {
        this.index = index;
        this.origin = origin;
        byte[] temp = new byte[128];
        IoUtils.readFully(input, temp);
        ByteBuffer buf = ByteBuffer.wrap(temp);
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.position(0);
        StringBuilder nameBuf = new StringBuilder();
        char ch = buf.getChar();
        while (ch != '\u0000') {
            nameBuf.append(ch);
            ch = buf.getChar();
        }
        this.name = nameBuf.toString();
        byte typeFlag = buf.get(66);
        switch (typeFlag) {
            case 1: {
                this.type = Entry.EntryType.DIRECTORY;
                break;
            }
            case 2: {
                this.type = Entry.EntryType.FILE;
                break;
            }
            case 5: {
                this.type = Entry.EntryType.ROOT;
                break;
            }
            default: {
                throw new IllegalStateException("Invalid type: " + typeFlag);
            }
        }
        this.previous = buf.getInt(68);
        this.next = buf.getInt(72);
        this.child = buf.getInt(76);
        this.startBlock = buf.getInt(116);
        this.size = buf.getInt(120);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Entry.EntryType getType() {
        return this.type;
    }

    @Override
    public Entry getNext() throws IOException {
        return this.origin.getEntry(this.next);
    }

    @Override
    public Entry getPrevious() throws IOException {
        return this.origin.getEntry(this.previous);
    }

    @Override
    public Entry getChild() throws IOException {
        return this.origin.getEntry(this.child);
    }

    @Override
    public SeekInputStream open() throws IOException {
        return new BlockInputStream(this.origin, this.startBlock);
    }

    @Override
    public List<Entry> list() throws IOException {
        if (this.child < 0) {
            throw new IllegalStateException("Can't list non-directory.");
        }
        Entry child = this.getChild();
        ArrayList<Entry> r = new ArrayList<Entry>();
        DefaultEntry.list(r, child);
        return r;
    }

    public static void list(List<Entry> list, Entry e) throws IOException {
        if (e == null) {
            return;
        }
        list.add(e);
        DefaultEntry.list(list, e.getPrevious());
        DefaultEntry.list(list, e.getNext());
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder result = new StringBuilder("Entry{");
        result.append("name=").append(this.name);
        result.append(" index=").append(this.index);
        result.append(" type=").append((Object)this.type);
        result.append(" size=").append(this.size);
        result.append(" prev=").append(this.previous);
        result.append(" next=").append(this.next);
        result.append(" child=").append(this.child);
        result.append(" startBlock=").append(this.startBlock);
        result.append("}");
        return result.toString();
    }
}

