/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.urlfilter.domainblacklist;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.net.URLFilter;
import org.apache.nutch.plugin.Extension;
import org.apache.nutch.plugin.PluginRepository;
import org.apache.nutch.util.URLUtil;
import org.apache.nutch.util.domain.DomainSuffix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DomainBlacklistURLFilter
implements URLFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DomainBlacklistURLFilter.class);
    private static String attributeFile = null;
    private Configuration conf;
    private String domainFile = null;
    private Set<String> domainSet = new LinkedHashSet<String>();

    private void readConfiguration(Reader configReader) throws IOException {
        BufferedReader reader = new BufferedReader(configReader);
        String line = null;
        while ((line = reader.readLine()) != null) {
            if (!StringUtils.isNotBlank((String)line) || line.startsWith("#")) continue;
            this.domainSet.add(StringUtils.lowerCase((String)line.trim()));
        }
    }

    public DomainBlacklistURLFilter() {
    }

    public DomainBlacklistURLFilter(String domainFile) {
        this.domainFile = domainFile;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        String pluginName = "urlfilter-domainblacklist";
        Extension[] extensions = PluginRepository.get((Configuration)conf).getExtensionPoint(URLFilter.class.getName()).getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            Extension extension = extensions[i];
            if (!extension.getDescriptor().getPluginId().equals(pluginName)) continue;
            attributeFile = extension.getAttribute("file");
            break;
        }
        if (attributeFile != null && attributeFile.trim().equals("")) {
            attributeFile = null;
        }
        if (attributeFile != null) {
            if (LOG.isInfoEnabled()) {
                LOG.info("Attribute \"file\" is defined for plugin " + pluginName + " as " + attributeFile);
            }
        } else if (LOG.isWarnEnabled()) {
            LOG.warn("Attribute \"file\" is not defined in plugin.xml for plugin " + pluginName);
        }
        String file = conf.get("urlfilter.domainblacklist.file");
        String stringRules = conf.get("urlfilter.domainblacklist.rules");
        if (this.domainFile != null) {
            file = this.domainFile;
        } else if (attributeFile != null) {
            file = attributeFile;
        }
        Reader reader = null;
        reader = stringRules != null ? new StringReader(stringRules) : conf.getConfResourceAsReader(file);
        try {
            if (reader == null) {
                reader = new FileReader(file);
            }
            this.readConfiguration(reader);
        }
        catch (IOException e) {
            LOG.error(org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public String filter(String url) {
        try {
            String domain = URLUtil.getDomainName((String)url).toLowerCase().trim();
            String host = URLUtil.getHost((String)url);
            String suffix = null;
            DomainSuffix domainSuffix = URLUtil.getDomainSuffix((String)url);
            if (domainSuffix != null) {
                suffix = domainSuffix.getDomain();
            }
            if (this.domainSet.contains(suffix) || this.domainSet.contains(domain) || this.domainSet.contains(host)) {
                return null;
            }
            return url;
        }
        catch (Exception e) {
            LOG.error("Could not apply filter on url: " + url + "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return null;
        }
    }
}

