/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.common.Base64;
import org.apache.manifoldcf.core.common.XMLDoc;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class HttpPoster {
    public static final String _rcsid = "@(#)$Id: HttpPoster.java 991295 2010-08-31 19:12:14Z kwright $";
    public static String ingestBufferSizeProperty = "org.apache.manifoldcf.ingest.buffersize";
    public static String ingestCredentialsRealm = "org.apache.manifoldcf.ingest.credentialrealm";
    public static String ingestResponseRetryCount = "org.apache.manifoldcf.ingest.responseretrycount";
    public static String ingestResponseRetryInterval = "org.apache.manifoldcf.ingest.retryinterval";
    public static String ingestRescheduleInterval = "org.apache.manifoldcf.ingest.rescheduleinterval";
    public static String ingestURIProperty = "org.apache.manifoldcf.ingest.uri";
    public static String ingestUserProperty = "org.apache.manifoldcf.ingest.user";
    public static String ingestPasswordProperty = "org.apache.manifoldcf.ingest.password";
    public static String ingestMaxConnectionsProperty = "org.apache.manifoldcf.ingest.maxconnections";
    protected static final int HEADER_CHUNK = 4096;
    private String protocol;
    private String host;
    private SSLSocketFactory socketFactory;
    private int port;
    private String encodedCredentials;
    private String realm;
    private String postUpdateAction;
    private String postRemoveAction;
    private String postStatusAction;
    private String allowAttributeName;
    private String denyAttributeName;
    private String idAttributeName;
    private static final String LITERAL = "literal.";
    private static final String NOTHING = "__NOTHING__";
    private static final String ID_METADATA = "lcf_metadata_id";
    private int buffersize = 32768;
    double sizeCoefficient = 5.0E-4;
    int responseRetries = 9000;
    long responseRetryWait = 20L;
    long interruptionRetryTime = 60000L;
    protected static byte[] separatorBytes = null;
    protected static byte[] endBytes = null;
    protected static byte[] postambleBytes = null;
    protected static byte[] preambleBytes = null;
    protected static SSLSocketFactory openSecureSocketFactory;

    public HttpPoster(String protocol, String server, int port, String webappName, String updatePath, String removePath, String statusPath, String realm, String userID, String password, String allowAttributeName, String denyAttributeName, String idAttributeName, IKeystoreManager keystoreManager) throws ManifoldCFException {
        this.allowAttributeName = allowAttributeName;
        this.denyAttributeName = denyAttributeName;
        this.idAttributeName = idAttributeName;
        this.host = server;
        this.port = port;
        this.protocol = protocol;
        this.socketFactory = keystoreManager != null ? keystoreManager.getSecureSocketFactory() : openSecureSocketFactory;
        if (userID != null && userID.length() > 0 && password != null) {
            try {
                this.encodedCredentials = new Base64().encodeByteArray((userID + ":" + password).getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new ManifoldCFException("Couldn't convert to utf-8 bytes: " + e.getMessage(), (Throwable)e);
            }
            this.realm = realm;
        } else {
            this.encodedCredentials = null;
        }
        String postURI = protocol + "://" + server + ":" + Integer.toString(port);
        if (webappName.length() > 0) {
            webappName = "/" + webappName;
        }
        this.postUpdateAction = webappName + updatePath;
        this.postRemoveAction = webappName + removePath;
        this.postStatusAction = webappName + statusPath;
        String x = ManifoldCF.getProperty((String)ingestBufferSizeProperty);
        if (x != null && x.length() > 0) {
            this.buffersize = new Integer(x);
        }
        if ((x = ManifoldCF.getProperty((String)ingestResponseRetryCount)) != null && x.length() > 0) {
            this.responseRetries = new Integer(x);
        }
        if ((x = ManifoldCF.getProperty((String)ingestResponseRetryInterval)) != null && x.length() > 0) {
            this.responseRetryWait = new Long(x);
        }
        if ((x = ManifoldCF.getProperty((String)ingestRescheduleInterval)) != null && x.length() > 0) {
            this.interruptionRetryTime = new Long(x);
        }
    }

    public void commitPost() throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)"commitPost()");
        }
        int ioErrorRetry = 5;
        while (true) {
            try {
                CommitThread t = new CommitThread();
                try {
                    t.start();
                    t.join();
                    Throwable thr = t.getException();
                    if (thr != null) {
                        if (thr instanceof ServiceInterruption) {
                            throw (ServiceInterruption)thr;
                        }
                        if (thr instanceof ManifoldCFException) {
                            throw (ManifoldCFException)thr;
                        }
                        if (thr instanceof IOException) {
                            throw (IOException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                }
            }
            catch (IOException ioe) {
                if (ioErrorRetry == 0) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO exception committing: " + ioe.getMessage(), (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
                try {
                    ManifoldCF.sleep((long)10000L);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                --ioErrorRetry;
                continue;
            }
            break;
        }
    }

    public boolean indexPost(String documentURI, RepositoryDocument document, Map arguments, Map sourceTargets, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("indexPost(): '" + documentURI + "'"));
        }
        if (document.countDirectoryACLs() != 0) {
            return false;
        }
        String[] shareAcls = HttpPoster.convertACL(document.getShareACL(), authorityNameString, activities);
        String[] shareDenyAcls = HttpPoster.convertACL(document.getShareDenyACL(), authorityNameString, activities);
        String[] acls = HttpPoster.convertACL(document.getACL(), authorityNameString, activities);
        String[] denyAcls = HttpPoster.convertACL(document.getDenyACL(), authorityNameString, activities);
        boolean readFromDocumentStreamYet = false;
        int ioErrorRetry = 3;
        while (true) {
            block17: {
                try {
                    IngestThread t = new IngestThread(documentURI, document, arguments, sourceTargets, shareAcls, shareDenyAcls, acls, denyAcls);
                    try {
                        t.start();
                        t.join();
                        if (t.getActivityCode() != null) {
                            activities.recordActivity(t.getActivityStart(), "document ingest", t.getActivityBytes(), documentURI, t.getActivityCode(), t.getActivityDetails());
                        }
                        readFromDocumentStreamYet = readFromDocumentStreamYet || t.getReadFromDocumentStreamYet();
                        Throwable thr = t.getException();
                        if (thr != null) {
                            if (thr instanceof ServiceInterruption) {
                                throw (ServiceInterruption)thr;
                            }
                            if (thr instanceof ManifoldCFException) {
                                throw (ManifoldCFException)thr;
                            }
                            if (thr instanceof IOException) {
                                throw (IOException)thr;
                            }
                            if (thr instanceof RuntimeException) {
                                throw (RuntimeException)thr;
                            }
                            throw (Error)thr;
                        }
                        return t.getRval();
                    }
                    catch (InterruptedException e) {
                        t.interrupt();
                        throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                    }
                }
                catch (SocketTimeoutException ioe) {
                    if (readFromDocumentStreamYet || ioErrorRetry == 0) {
                        long currentTime = System.currentTimeMillis();
                        throw new ServiceInterruption("IO error connecting to ingestion API: " + ioe.getMessage() + "; ingestion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                    }
                }
                catch (IOException ioe) {
                    if (!readFromDocumentStreamYet && ioErrorRetry != 0) break block17;
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO error ingesting document: " + ioe.getMessage() + "; ingestion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
            }
            try {
                ManifoldCF.sleep((long)10000L);
            }
            catch (InterruptedException e) {
                throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
            }
            --ioErrorRetry;
        }
    }

    public void checkPost() throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)"checkPost()");
        }
        int ioErrorRetry = 5;
        while (true) {
            try {
                StatusThread t = new StatusThread();
                try {
                    t.start();
                    t.join();
                    Throwable thr = t.getException();
                    if (thr != null) {
                        if (thr instanceof ServiceInterruption) {
                            throw (ServiceInterruption)thr;
                        }
                        if (thr instanceof ManifoldCFException) {
                            throw (ManifoldCFException)thr;
                        }
                        if (thr instanceof IOException) {
                            throw (IOException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                }
            }
            catch (IOException ioe) {
                if (ioErrorRetry == 0) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO exception checking: " + ioe.getMessage(), (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
                try {
                    ManifoldCF.sleep((long)10000L);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                --ioErrorRetry;
                continue;
            }
            break;
        }
    }

    public void deletePost(String documentURI, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        if (Logging.ingest.isDebugEnabled()) {
            Logging.ingest.debug((Object)("deletePost(): '" + documentURI + "'"));
        }
        int ioErrorRetry = 5;
        while (true) {
            try {
                DeleteThread t = new DeleteThread(documentURI);
                try {
                    Throwable thr;
                    t.start();
                    t.join();
                    if (t.getActivityCode() != null) {
                        activities.recordActivity(t.getActivityStart(), "document deletion", null, documentURI, t.getActivityCode(), t.getActivityDetails());
                    }
                    if ((thr = t.getException()) != null) {
                        if (thr instanceof ServiceInterruption) {
                            throw (ServiceInterruption)thr;
                        }
                        if (thr instanceof ManifoldCFException) {
                            throw (ManifoldCFException)thr;
                        }
                        if (thr instanceof IOException) {
                            throw (IOException)thr;
                        }
                        if (thr instanceof RuntimeException) {
                            throw (RuntimeException)thr;
                        }
                        throw (Error)thr;
                    }
                    return;
                }
                catch (InterruptedException e) {
                    t.interrupt();
                    throw new ManifoldCFException("Interrupted: " + e.getMessage(), 2);
                }
            }
            catch (IOException ioe) {
                if (ioErrorRetry == 0) {
                    long currentTime = System.currentTimeMillis();
                    throw new ServiceInterruption("IO exception deleting: " + ioe.getMessage() + "; deletion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                }
                try {
                    ManifoldCF.sleep((long)10000L);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException("Interrupted", 2);
                }
                --ioErrorRetry;
                continue;
            }
            break;
        }
    }

    protected static String[] convertACL(String[] acl, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException {
        if (acl != null) {
            String[] rval = new String[acl.length];
            for (int i = 0; i < rval.length; ++i) {
                rval[i] = activities.qualifyAccessToken(authorityNameString, acl[i]);
            }
            return rval;
        }
        return new String[0];
    }

    protected static String readLine(InputStream in) throws IOException {
        ByteBuffer bb = new ByteBuffer();
        while (true) {
            int x;
            if ((x = in.read()) == -1) {
                throw new IOException("Unexpected EOF");
            }
            if (x == 13) continue;
            if (x == 10) break;
            bb.append((byte)x);
        }
        return bb.toString("ASCII");
    }

    protected CodeDetails getResponse(InputStream in) throws ManifoldCFException, ServiceInterruption {
        Logging.ingest.debug((Object)"Waiting for response stream");
        try {
            String headerLine;
            String responseCode = HttpPoster.readLine(in);
            if (Logging.ingest.isDebugEnabled()) {
                Logging.ingest.debug((Object)("Response code from ingest: '" + responseCode + "'"));
            }
            String contentType = "text/plain; charset=iso-8859-1";
            while ((headerLine = HttpPoster.readLine(in)).length() != 0) {
                int spaceIndex = headerLine.indexOf(" ");
                if (spaceIndex == -1) continue;
                String headerName = headerLine.substring(0, spaceIndex);
                String headerValue = headerLine.substring(spaceIndex).trim().toLowerCase();
                if (!headerName.toLowerCase().equals("content-type:")) continue;
                contentType = headerValue;
            }
            int charsetIndex = contentType.indexOf("charset=");
            String charsetName = "iso-8859-1";
            if (charsetIndex != -1) {
                charsetName = contentType.substring(charsetIndex + 8);
            }
            byte[] responseContent = HttpPoster.readInputStream(in);
            XMLDoc doc = null;
            String rawString = null;
            try {
                doc = new XMLDoc((InputStream)new ByteArrayInputStream(responseContent));
            }
            catch (ManifoldCFException e) {
                try {
                    rawString = new String(responseContent, charsetName);
                }
                catch (UnsupportedEncodingException e2) {
                    rawString = "Response had an illegal encoding: " + e2.getMessage();
                    e.printStackTrace();
                }
            }
            Logging.ingest.debug((Object)"Read of response stream complete");
            return new CodeDetails(responseCode, doc, rawString);
        }
        catch (SocketTimeoutException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Ingestion API socket timeout exception waiting for response code: " + e.getMessage() + "; ingestion will be retried again later", (Throwable)e, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
        }
        catch (InterruptedIOException e) {
            throw new ManifoldCFException("Interrupted", 2);
        }
        catch (ConnectException e) {
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("Timed out connecting to ingestion API: " + e.getMessage() + "; ingestion will be retried again later", (Throwable)e, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
        }
        catch (SocketException e) {
            return new CodeDetails("HTTP/1.0 400 Connection Reset", null, null);
        }
        catch (IOException ioe) {
            Logging.ingest.warn((Object)("IO exception trying to get response from ingestion API: " + ioe.getMessage()), (Throwable)ioe);
            long currentTime = System.currentTimeMillis();
            throw new ServiceInterruption("IO exception waiting for response code: " + ioe.getMessage() + "; ingestion will be retried again later", (Throwable)ioe, currentTime + this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
        }
    }

    protected static byte[] readInputStream(InputStream is) throws IOException {
        byte[] buffer;
        int amt;
        ArrayList<byte[]> array = new ArrayList<byte[]>();
        int count = 0;
        while ((amt = is.read(buffer = new byte[65536])) != -1) {
            count += amt;
            array.add(buffer);
        }
        byte[] rval = new byte[count];
        int pointer = 0;
        int index = 0;
        while (pointer < count) {
            byte[] buffer2;
            if ((buffer2 = (byte[])array.get(index++)).length > count - pointer) {
                System.arraycopy(buffer2, 0, rval, pointer, count - pointer);
                pointer = count;
                continue;
            }
            System.arraycopy(buffer2, 0, rval, pointer, buffer2.length);
            pointer += buffer2.length;
        }
        return rval;
    }

    protected void writeCredentials(OutputStream out) throws IOException {
        if (this.encodedCredentials != null) {
            Logging.ingest.debug((Object)"Applying credentials");
            byte[] tmp = ("Authorization: Basic " + this.encodedCredentials + "\r\n").getBytes("UTF-8");
            out.write(tmp, 0, tmp.length);
            tmp = ("WWW-Authenticate: Basic realm=\"" + (this.realm != null ? this.realm : "") + "\"\r\n").getBytes("UTF-8");
            out.write(tmp, 0, tmp.length);
        }
    }

    protected static SSLSocketFactory getOpenSecureSocketFactory() throws ManifoldCFException {
        try {
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new LaxTrustManager[]{new LaxTrustManager()}, secureRandom);
            return sslContext.getSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            throw new ManifoldCFException("No such algorithm: " + e.getMessage(), (Throwable)e);
        }
        catch (KeyManagementException e) {
            throw new ManifoldCFException("Key management exception: " + e.getMessage(), (Throwable)e);
        }
    }

    protected Socket createSocket(long responseRetryCount) throws IOException, ManifoldCFException {
        Socket socket;
        if (this.protocol.equals("https") && this.socketFactory != null) {
            try {
                socket = this.socketFactory.createSocket(this.host, this.port);
            }
            catch (InterruptedIOException e) {
                throw e;
            }
            catch (IOException e) {
                throw new ManifoldCFException("Couldn't set up SSL connection to ingestion API: " + e.getMessage(), (Throwable)e);
            }
        } else {
            socket = new Socket(this.host, this.port);
        }
        long timeoutMilliseconds = this.responseRetryWait * responseRetryCount;
        socket.setSoTimeout((int)timeoutMilliseconds);
        return socket;
    }

    protected static int lengthPreamble() throws IOException {
        return preambleBytes.length;
    }

    protected static int lengthBoundary(String contentType, String name, String fileName) throws IOException {
        int rval = 0;
        rval += separatorBytes.length;
        String value = "Content-Disposition: form-data";
        if (name != null) {
            value = value + "; name=\"" + name + "\"";
        }
        if (fileName != null) {
            value = value + "; filename=\"" + fileName + "\"";
        }
        value = value + "\r\n";
        byte[] tmp = value.getBytes("ASCII");
        rval += tmp.length;
        tmp = ("Content-Type: " + contentType + "\r\n\r\n").getBytes("ASCII");
        return rval += tmp.length;
    }

    protected static int lengthPostamble() throws IOException {
        return postambleBytes.length;
    }

    protected static int lengthField(String fieldName, String fieldValue) throws IOException {
        int rval = HttpPoster.lengthPreamble() + HttpPoster.lengthBoundary("text/plain; charset=UTF-8", fieldName, null);
        byte[] tmp = fieldValue.getBytes("UTF-8");
        rval += tmp.length;
        return rval += HttpPoster.lengthPostamble();
    }

    protected int lengthACLs(String aclType, String[] acl, String[] denyAcl) throws IOException {
        int totalLength = 0;
        String metadataACLName = LITERAL + this.allowAttributeName + aclType;
        int i = 0;
        while (i < acl.length) {
            totalLength += HttpPoster.lengthField(metadataACLName, acl[i++]);
        }
        String metadataDenyACLName = LITERAL + this.denyAttributeName + aclType;
        i = 0;
        while (i < denyAcl.length) {
            totalLength += HttpPoster.lengthField(metadataDenyACLName, denyAcl[i++]);
        }
        return totalLength;
    }

    protected static void writePreamble(OutputStream out) throws IOException {
        out.write(preambleBytes, 0, preambleBytes.length);
    }

    protected static void writeBoundary(OutputStream out, String contentType, String name, String fileName) throws IOException {
        out.write(separatorBytes, 0, separatorBytes.length);
        String value = "Content-Disposition: form-data";
        if (name != null) {
            value = value + "; name=\"" + name + "\"";
        }
        if (fileName != null) {
            value = value + "; filename=\"" + fileName + "\"";
        }
        value = value + "\r\n";
        byte[] tmp = value.getBytes("ASCII");
        out.write(tmp, 0, tmp.length);
        tmp = ("Content-Type: " + contentType + "\r\n\r\n").getBytes("ASCII");
        out.write(tmp, 0, tmp.length);
    }

    protected static void writePostamble(OutputStream out) throws IOException {
        out.write(postambleBytes, 0, postambleBytes.length);
    }

    protected static void writeField(OutputStream out, String fieldName, String fieldValue) throws IOException {
        HttpPoster.writePreamble(out);
        HttpPoster.writeBoundary(out, "text/plain; charset=UTF-8", fieldName, null);
        byte[] tmp = fieldValue.getBytes("UTF-8");
        out.write(tmp, 0, tmp.length);
        HttpPoster.writePostamble(out);
    }

    protected void writeACLs(OutputStream out, String aclType, String[] acl, String[] denyAcl) throws IOException {
        String metadataACLName = LITERAL + this.allowAttributeName + aclType;
        int i = 0;
        while (i < acl.length) {
            HttpPoster.writeField(out, metadataACLName, acl[i++]);
        }
        String metadataDenyACLName = LITERAL + this.denyAttributeName + aclType;
        i = 0;
        while (i < denyAcl.length) {
            HttpPoster.writeField(out, metadataDenyACLName, denyAcl[i++]);
        }
    }

    protected static String xmlEncode(String input) {
        StringBuffer sb = new StringBuffer("<![CDATA[");
        sb.append(input);
        sb.append("]]>");
        return sb.toString();
    }

    static {
        try {
            String separatorString = "------------------T-H-I-S--I-S--A--S-E-P-A-R-A-T-O-R--399123410141511";
            separatorBytes = (separatorString + "\r\n").getBytes("ASCII");
            endBytes = ("--" + separatorString + "--\r\n").getBytes("ASCII");
            postambleBytes = "\r\n".getBytes("ASCII");
            preambleBytes = "--".getBytes("ASCII");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            System.exit(1);
        }
        openSecureSocketFactory = null;
        try {
            openSecureSocketFactory = HttpPoster.getOpenSecureSocketFactory();
        }
        catch (ManifoldCFException e) {
            e.printStackTrace();
            System.exit(100);
        }
    }

    protected static class CodeDetails {
        protected String code;
        protected int codeValue;
        protected String details;
        protected String res;
        protected XMLDoc returnDoc;
        protected String rawString;

        public CodeDetails(String res, XMLDoc returnDoc, String rawString) {
            int secondSpace;
            this.res = res;
            this.returnDoc = returnDoc;
            this.rawString = rawString;
            this.codeValue = -100;
            this.code = "-100";
            this.details = "Http response was improperly formed";
            int firstSpace = res.indexOf(" ");
            if (firstSpace != -1 && (secondSpace = res.indexOf(" ", firstSpace + 1)) != -1) {
                this.code = res.substring(firstSpace + 1, secondSpace);
                this.details = res.substring(secondSpace + 1).trim();
                try {
                    this.codeValue = (int)new Double(this.code).doubleValue();
                    if (this.codeValue == 200) {
                        this.details = null;
                    }
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }

        public String getCode() {
            return this.code;
        }

        public int getCodeValue() {
            return this.codeValue;
        }

        public String getDetails() {
            return this.details;
        }

        public XMLDoc getReturnDoc() {
            return this.returnDoc;
        }

        public String getDescription() throws ManifoldCFException {
            return this.res + "\r\n" + (this.returnDoc != null ? this.returnDoc.getXML() : (this.rawString != null ? this.rawString : ""));
        }

        public void parseIngestionResponse() throws ManifoldCFException {
            String statusValue = "unknown";
            XMLDoc doc = this.getReturnDoc();
            if (doc != null) {
                if (Logging.ingest.isDebugEnabled()) {
                    Logging.ingest.debug((Object)("SOLR: Saw ingestion response document '" + doc.getXML() + "'"));
                }
                ArrayList list = doc.processPath("*", null);
                int k = 0;
                while (k < list.size()) {
                    Object listNode;
                    if (!doc.getNodeName(listNode = list.get(k++)).equals("response")) continue;
                    ArrayList list2 = doc.processPath("*", listNode);
                    int q = 0;
                    while (q < list2.size()) {
                        String lstName;
                        Object respNode;
                        if (!doc.getNodeName(respNode = list2.get(q++)).equals("lst") || !(lstName = doc.getValue(respNode, "name")).equals("responseHeader")) continue;
                        ArrayList list3 = doc.processPath("*", respNode);
                        int z = 0;
                        while (z < list3.size()) {
                            String value;
                            Object headerNode;
                            if (!doc.getNodeName(headerNode = list3.get(z++)).equals("int") || !(value = doc.getValue(headerNode, "name")).equals("status")) continue;
                            statusValue = doc.getData(headerNode).trim();
                        }
                    }
                }
                if (statusValue.equals("0")) {
                    return;
                }
                throw new ManifoldCFException("Ingestion returned error: " + statusValue);
            }
            throw new ManifoldCFException("XML parsing error on response");
        }

        public void parseRemovalResponse() throws ManifoldCFException {
            this.parseIngestionResponse();
        }

        public void parseCommitResponse() throws ManifoldCFException {
            this.parseIngestionResponse();
        }

        public void parseStatusResponse() throws ManifoldCFException {
            String statusValue = "unknown";
            XMLDoc doc = this.getReturnDoc();
            if (doc != null) {
                if (Logging.ingest.isDebugEnabled()) {
                    Logging.ingest.debug((Object)("SOLR: Saw status response document '" + doc.getXML() + "'"));
                }
                ArrayList list = doc.processPath("*", null);
                int k = 0;
                while (k < list.size()) {
                    Object listNode;
                    if (!doc.getNodeName(listNode = list.get(k++)).equals("response")) continue;
                    ArrayList list2 = doc.processPath("*", listNode);
                    int q = 0;
                    while (q < list2.size()) {
                        String value;
                        Object respNode;
                        if (!doc.getNodeName(respNode = list2.get(q++)).equals("str") || !(value = doc.getValue(respNode, "name")).equals("status")) continue;
                        statusValue = doc.getData(respNode).trim();
                    }
                }
                if (statusValue.equals("OK")) {
                    return;
                }
                throw new ManifoldCFException("Status error: " + statusValue);
            }
            throw new ManifoldCFException("XML parsing error on response");
        }
    }

    protected class StatusThread
    extends Thread {
        protected Throwable exception = null;

        public StatusThread() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                try {
                    Socket socket = HttpPoster.this.createSocket(HttpPoster.this.responseRetries);
                    try {
                        InputStream in = socket.getInputStream();
                        try {
                            OutputStream out = socket.getOutputStream();
                            try {
                                byte[] tmp = ("GET " + HttpPoster.this.postStatusAction + " HTTP/1.0\r\n").getBytes("ASCII");
                                out.write(tmp, 0, tmp.length);
                                HttpPoster.this.writeCredentials(out);
                                tmp = "Content-Length: 0\r\n\r\n".getBytes("ASCII");
                                out.write(tmp, 0, tmp.length);
                                if (Logging.ingest.isDebugEnabled()) {
                                    Logging.ingest.debug((Object)"Status request posted");
                                }
                                out.flush();
                                CodeDetails cd = HttpPoster.this.getResponse(in);
                                int codeValue = cd.getCodeValue();
                                if (codeValue < 0) {
                                    throw new ManifoldCFException("Http protocol error");
                                }
                                if (codeValue == 200) {
                                    cd.parseStatusResponse();
                                    return;
                                }
                                if (codeValue == 401) {
                                    throw new ManifoldCFException("Bad credentials for ingestion", 3);
                                }
                                throw new ManifoldCFException("Error connecting to ingestion API: '" + cd.getDescription() + "'");
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal ingestion error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error communicating with Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class CommitThread
    extends Thread {
        protected Throwable exception = null;

        public CommitThread() {
            this.setDaemon(true);
        }

        public void run() {
            try {
                try {
                    Socket socket = HttpPoster.this.createSocket(HttpPoster.this.responseRetries);
                    try {
                        InputStream in = socket.getInputStream();
                        try {
                            OutputStream out = socket.getOutputStream();
                            try {
                                byte[] tmp = ("GET " + HttpPoster.this.postUpdateAction + "?commit=true HTTP/1.0\r\n").getBytes("ASCII");
                                out.write(tmp, 0, tmp.length);
                                HttpPoster.this.writeCredentials(out);
                                tmp = "Content-Length: 0\r\n\r\n".getBytes("ASCII");
                                out.write(tmp, 0, tmp.length);
                                if (Logging.ingest.isDebugEnabled()) {
                                    Logging.ingest.debug((Object)"Commit request posted");
                                }
                                out.flush();
                                CodeDetails cd = HttpPoster.this.getResponse(in);
                                int codeValue = cd.getCodeValue();
                                if (codeValue < 0) {
                                    throw new ManifoldCFException("Http protocol error");
                                }
                                if (codeValue == 200) {
                                    cd.parseCommitResponse();
                                    return;
                                }
                                if (codeValue == 401) {
                                    throw new ManifoldCFException("Bad credentials for commit request", 3);
                                }
                                throw new ManifoldCFException("Error connecting to update request API: '" + cd.getDescription() + "'");
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal commit error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error communicating with update request handler: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }
    }

    protected class DeleteThread
    extends Thread {
        protected String documentURI;
        protected Long activityStart = null;
        protected String activityCode = null;
        protected String activityDetails = null;
        protected Throwable exception = null;

        public DeleteThread(String documentURI) {
            this.setDaemon(true);
            this.documentURI = documentURI;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            try {
                long fullStartTime = System.currentTimeMillis();
                try {
                    Socket socket = HttpPoster.this.createSocket(HttpPoster.this.responseRetries);
                    try {
                        CodeDetails cd;
                        InputStream in = socket.getInputStream();
                        OutputStream out = socket.getOutputStream();
                        byte[] requestBytes = ("<delete><id>" + HttpPoster.xmlEncode(this.documentURI) + "</id></delete>").getBytes("UTF-8");
                        long startTime = System.currentTimeMillis();
                        byte[] tmp = ("POST " + HttpPoster.this.postRemoveAction + " HTTP/1.0\r\n").getBytes("ASCII");
                        out.write(tmp, 0, tmp.length);
                        HttpPoster.this.writeCredentials(out);
                        tmp = ("Content-Length: " + Integer.toString(requestBytes.length) + "\r\n").getBytes("ASCII");
                        out.write(tmp, 0, tmp.length);
                        tmp = "Content-Type: text/xml; charset=UTF-8\r\n\r\n".getBytes("ASCII");
                        out.write(tmp, 0, tmp.length);
                        out.write(requestBytes);
                        out.flush();
                        if (Logging.ingest.isDebugEnabled()) {
                            Logging.ingest.debug((Object)"Delete posted");
                        }
                        try {
                            cd = HttpPoster.this.getResponse(in);
                        }
                        catch (ServiceInterruption si) {
                            this.activityStart = new Long(startTime);
                            this.activityCode = "-2";
                            this.activityDetails = si.getMessage();
                            throw si;
                        }
                        this.activityStart = new Long(startTime);
                        this.activityCode = cd.getCode();
                        this.activityDetails = cd.getDetails();
                        int codeValue = cd.getCodeValue();
                        if (codeValue < 0) {
                            throw new ManifoldCFException("Http protocol error");
                        }
                        if (codeValue == 200) {
                            cd.parseRemovalResponse();
                            return;
                        }
                        if (codeValue == 401) {
                            throw new ManifoldCFException("Bad credentials for ingestion", 3);
                        }
                        if (codeValue < 400 || codeValue >= 500) throw new ManifoldCFException("Error deleting document: '" + cd.getDescription() + "'");
                        return;
                        {
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal ingestion error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (InterruptedIOException ioe) {
                    return;
                }
                catch (IOException ioe) {
                    Logging.ingest.warn((Object)("Error communicating with Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = "-1";
                    this.activityDetails = ioe.getMessage();
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Long getActivityStart() {
            return this.activityStart;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public String getActivityDetails() {
            return this.activityDetails;
        }
    }

    protected class IngestThread
    extends Thread {
        protected String documentURI;
        protected RepositoryDocument document;
        protected Map arguments;
        protected Map sourceTargets;
        protected String[] shareAcls;
        protected String[] shareDenyAcls;
        protected String[] acls;
        protected String[] denyAcls;
        protected Long activityStart = null;
        protected Long activityBytes = null;
        protected String activityCode = null;
        protected String activityDetails = null;
        protected Throwable exception = null;
        protected boolean readFromDocumentStreamYet = false;
        protected boolean rval = false;

        public IngestThread(String documentURI, RepositoryDocument document, Map arguments, Map sourceTargets, String[] shareAcls, String[] shareDenyAcls, String[] acls, String[] denyAcls) {
            this.setDaemon(true);
            this.documentURI = documentURI;
            this.document = document;
            this.arguments = arguments;
            this.shareAcls = shareAcls;
            this.shareDenyAcls = shareDenyAcls;
            this.acls = acls;
            this.denyAcls = denyAcls;
            this.sourceTargets = sourceTargets;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            long length = this.document.getBinaryLength();
            InputStream is = this.document.getBinaryStream();
            try {
                long fullStartTime = System.currentTimeMillis();
                try {
                    long responseRetryCount = (long)HttpPoster.this.responseRetries + (long)((double)length * HttpPoster.this.sizeCoefficient);
                    Socket socket = HttpPoster.this.createSocket(responseRetryCount);
                    try {
                        InputStream in = socket.getInputStream();
                        try {
                            OutputStream out = socket.getOutputStream();
                            try {
                                CodeDetails cd;
                                long now;
                                block57: {
                                    long later;
                                    String value;
                                    String newFieldName;
                                    String fieldName;
                                    List values;
                                    byte[] tmp = ("POST " + HttpPoster.this.postUpdateAction + " HTTP/1.0\r\n").getBytes("ASCII");
                                    out.write(tmp, 0, tmp.length);
                                    HttpPoster.this.writeCredentials(out);
                                    int totalLength = 0;
                                    totalLength += HttpPoster.lengthField(HttpPoster.LITERAL + HttpPoster.this.idAttributeName, this.documentURI);
                                    totalLength += HttpPoster.this.lengthACLs("share", this.shareAcls, this.shareDenyAcls);
                                    totalLength += HttpPoster.this.lengthACLs("document", this.acls, this.denyAcls);
                                    for (String name : this.arguments.keySet()) {
                                        values = (List)this.arguments.get(name);
                                        int j = 0;
                                        while (j < values.size()) {
                                            String value2 = (String)values.get(j++);
                                            totalLength += HttpPoster.lengthField(name, value2);
                                        }
                                    }
                                    Iterator iter = this.document.getFields();
                                    while (iter.hasNext()) {
                                        fieldName = (String)iter.next();
                                        newFieldName = (String)this.sourceTargets.get(fieldName);
                                        if (newFieldName == null) {
                                            newFieldName = fieldName;
                                        }
                                        if (newFieldName.length() <= 0) continue;
                                        if (newFieldName.toLowerCase().equals(HttpPoster.this.idAttributeName.toLowerCase())) {
                                            newFieldName = HttpPoster.ID_METADATA;
                                        }
                                        Object[] values2 = this.document.getField(fieldName);
                                        int k = 0;
                                        while (k < values2.length) {
                                            value = (String)values2[k++];
                                            totalLength += HttpPoster.lengthField(HttpPoster.LITERAL + newFieldName, value);
                                        }
                                    }
                                    totalLength += HttpPoster.lengthPreamble();
                                    totalLength += HttpPoster.lengthBoundary("application/octet-stream", "myfile", "docname");
                                    totalLength = (int)((long)totalLength + length);
                                    totalLength += HttpPoster.lengthPostamble();
                                    tmp = ("Content-Length: " + Integer.toString(totalLength += endBytes.length) + "\r\n").getBytes("ASCII");
                                    out.write(tmp, 0, tmp.length);
                                    tmp = "Content-Type: multipart/form-data; boundary=".getBytes("ASCII");
                                    out.write(tmp, 0, tmp.length);
                                    out.write(separatorBytes, 0, separatorBytes.length);
                                    tmp = "\r\n".getBytes("ASCII");
                                    out.write(tmp, 0, tmp.length);
                                    HttpPoster.writeField(out, HttpPoster.LITERAL + HttpPoster.this.idAttributeName, this.documentURI);
                                    HttpPoster.this.writeACLs(out, "share", this.shareAcls, this.shareDenyAcls);
                                    HttpPoster.this.writeACLs(out, "document", this.acls, this.denyAcls);
                                    for (String name : this.arguments.keySet()) {
                                        values = (List)this.arguments.get(name);
                                        int j = 0;
                                        while (j < values.size()) {
                                            String value3 = (String)values.get(j++);
                                            HttpPoster.writeField(out, name, value3);
                                        }
                                    }
                                    iter = this.document.getFields();
                                    while (iter.hasNext()) {
                                        fieldName = (String)iter.next();
                                        newFieldName = (String)this.sourceTargets.get(fieldName);
                                        if (newFieldName == null) {
                                            newFieldName = fieldName;
                                        }
                                        if (newFieldName.length() <= 0) continue;
                                        if (newFieldName.toLowerCase().equals(HttpPoster.this.idAttributeName.toLowerCase())) {
                                            newFieldName = HttpPoster.ID_METADATA;
                                        }
                                        Object[] values3 = this.document.getField(fieldName);
                                        int k = 0;
                                        while (k < values3.length) {
                                            value = (String)values3[k++];
                                            HttpPoster.writeField(out, HttpPoster.LITERAL + newFieldName, value);
                                        }
                                    }
                                    HttpPoster.writePreamble(out);
                                    HttpPoster.writeBoundary(out, "application/octet-stream", "myfile", "docname");
                                    long total = 0L;
                                    now = System.currentTimeMillis();
                                    byte[] bytes = new byte[HttpPoster.this.buffersize];
                                    while (true) {
                                        int count;
                                        try {
                                            count = is.read(bytes);
                                        }
                                        catch (SocketTimeoutException ioe) {
                                            Logging.ingest.warn((Object)("Error reading data for transmission to Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                                            this.activityStart = new Long(fullStartTime);
                                            this.activityCode = "-1";
                                            this.activityDetails = "Couldn't read document: " + ioe.getMessage();
                                            long currentTime = System.currentTimeMillis();
                                            throw new ServiceInterruption("IO error reading document for ingestion: " + ioe.getMessage() + "; read will be retried again later", (Throwable)ioe, currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                        }
                                        catch (InterruptedIOException ioe) {
                                            if (ioe.getClass().getName().equals("java.io.InterruptedIOException")) throw ioe;
                                            Logging.ingest.warn((Object)("Error reading data for transmission to Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                                            this.activityStart = new Long(fullStartTime);
                                            this.activityCode = "-1";
                                            this.activityDetails = "Couldn't read document: " + ioe.getMessage();
                                            long currentTime = System.currentTimeMillis();
                                            throw new ServiceInterruption("IO error reading document for ingestion: " + ioe.getMessage() + "; read will be retried again later", (Throwable)ioe, currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                        }
                                        catch (IOException ioe) {
                                            Logging.ingest.warn((Object)("Error reading data for transmission to Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                                            this.activityStart = new Long(fullStartTime);
                                            this.activityCode = "-1";
                                            this.activityDetails = "Couldn't read document: " + ioe.getMessage();
                                            long currentTime = System.currentTimeMillis();
                                            throw new ServiceInterruption("IO error reading document for ingestion: " + ioe.getMessage() + "; read will be retried again later", (Throwable)ioe, currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                                        }
                                        if (count == -1) {
                                            HttpPoster.writePostamble(out);
                                            out.write(endBytes, 0, endBytes.length);
                                            out.flush();
                                            later = System.currentTimeMillis();
                                            if (Logging.ingest.isDebugEnabled()) {
                                                break;
                                            }
                                            break block57;
                                        }
                                        this.readFromDocumentStreamYet = true;
                                        out.write(bytes, 0, count);
                                        total += (long)count;
                                    }
                                    Logging.ingest.debug((Object)("Total bytes posted: " + new Long(total).toString() + ", total time: " + (later - now)));
                                }
                                try {
                                    cd = HttpPoster.this.getResponse(in);
                                }
                                catch (ServiceInterruption si) {
                                    this.activityStart = new Long(now);
                                    this.activityCode = "-2";
                                    this.activityDetails = si.getMessage();
                                    throw si;
                                }
                                this.activityStart = new Long(now);
                                this.activityBytes = new Long(length);
                                this.activityCode = cd.getCode();
                                this.activityDetails = cd.getDetails();
                                int codeValue = cd.getCodeValue();
                                if (codeValue < 0) {
                                    throw new ManifoldCFException("Http protocol error");
                                }
                                if (codeValue == 200) {
                                    cd.parseIngestionResponse();
                                    this.rval = true;
                                    return;
                                }
                                if (codeValue == 401) {
                                    throw new ManifoldCFException("Bad credentials for ingestion", 3);
                                }
                                if (codeValue >= 400 && codeValue < 500) {
                                    this.rval = false;
                                    return;
                                }
                                long currentTime = System.currentTimeMillis();
                                throw new ServiceInterruption("Error " + Integer.toString(codeValue) + " from ingestion request; ingestion will be retried again later", (Throwable)new ManifoldCFException("Ingestion HTTP error code " + Integer.toString(codeValue)), currentTime + HttpPoster.this.interruptionRetryTime, currentTime + 0x6DDD00L, -1, true);
                            }
                            finally {
                                out.close();
                            }
                        }
                        finally {
                            in.close();
                        }
                    }
                    finally {
                        try {
                            socket.close();
                        }
                        catch (InterruptedIOException e) {
                            throw e;
                        }
                        catch (IOException e) {
                            Logging.ingest.debug((Object)("Error closing socket: " + e.getMessage()), (Throwable)e);
                        }
                    }
                }
                catch (UnsupportedEncodingException ioe) {
                    throw new ManifoldCFException("Fatal ingestion error: " + ioe.getMessage(), (Throwable)ioe);
                }
                catch (SocketTimeoutException ioe) {
                    Logging.ingest.warn((Object)("Error connecting to ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    this.activityStart = new Long(fullStartTime);
                    this.activityCode = "-1";
                    this.activityDetails = ioe.getMessage();
                    throw ioe;
                }
                catch (InterruptedIOException e) {
                    return;
                }
                catch (IOException ioe) {
                    this.activityStart = new Long(fullStartTime);
                    if (ioe.getClass().getName().equals("java.net.SocketException") && ioe.getMessage().toLowerCase().indexOf("broken pipe") != -1) {
                        this.activityCode = "-103";
                        this.activityDetails = "Presuming an ingestion rejection: " + ioe.getMessage();
                        this.rval = false;
                        return;
                    }
                    this.activityCode = "-1";
                    this.activityDetails = ioe.getMessage();
                    Logging.ingest.warn((Object)("Error communicating with Ingestion API: " + ioe.getMessage()), (Throwable)ioe);
                    throw ioe;
                }
            }
            catch (Throwable e) {
                this.exception = e;
                return;
            }
        }

        public Throwable getException() {
            return this.exception;
        }

        public Long getActivityStart() {
            return this.activityStart;
        }

        public Long getActivityBytes() {
            return this.activityBytes;
        }

        public String getActivityCode() {
            return this.activityCode;
        }

        public String getActivityDetails() {
            return this.activityDetails;
        }

        public boolean getReadFromDocumentStreamYet() {
            return this.readFromDocumentStreamYet;
        }

        public boolean getRval() {
            return this.rval;
        }
    }

    protected static class LaxTrustManager
    implements X509TrustManager {
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }

        public void checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        }
    }

    protected static class ByteBuffer {
        byte[] theBuffer;
        int bufferAmt;

        public ByteBuffer() {
            this.createBuffer(64);
        }

        protected void createBuffer(int size) {
            this.theBuffer = new byte[size];
        }

        public void append(byte b) {
            if (this.bufferAmt == this.theBuffer.length) {
                byte[] oldBuffer = this.theBuffer;
                this.createBuffer(this.bufferAmt * 2);
                for (int i = 0; i < this.bufferAmt; ++i) {
                    this.theBuffer[i] = oldBuffer[i];
                }
            }
            this.theBuffer[this.bufferAmt++] = b;
        }

        public String toString(String encoding) throws UnsupportedEncodingException {
            return new String(this.theBuffer, 0, this.bufferAmt, encoding);
        }
    }
}

