/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.output.solr;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.manifoldcf.agents.interfaces.IOutputAddActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputNotifyActivity;
import org.apache.manifoldcf.agents.interfaces.IOutputRemoveActivity;
import org.apache.manifoldcf.agents.interfaces.OutputSpecification;
import org.apache.manifoldcf.agents.interfaces.RepositoryDocument;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.agents.output.BaseOutputConnector;
import org.apache.manifoldcf.agents.output.solr.HttpPoster;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.IDFactory;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.SpecificationNode;
import org.apache.manifoldcf.ui.util.Encoder;

public class SolrConnector
extends BaseOutputConnector {
    public static final String _rcsid = "@(#)$Id: SolrConnector.java 998081 2010-09-17 11:33:15Z kwright $";
    public static final String INGEST_ACTIVITY = "document ingest";
    public static final String REMOVE_ACTIVITY = "document deletion";
    protected HttpPoster poster = null;
    protected String allowAttributeName = "allow_token_";
    protected String denyAttributeName = "deny_token_";
    protected boolean doCommits = false;

    public String[] getActivitiesList() {
        return new String[]{INGEST_ACTIVITY, REMOVE_ACTIVITY};
    }

    public String getJSPFolder() {
        return "solr";
    }

    public void connect(ConfigParams configParameters) {
        super.connect(configParameters);
    }

    public void disconnect() throws ManifoldCFException {
        this.poster = null;
        super.disconnect();
    }

    protected void getSession() throws ManifoldCFException {
        if (this.poster == null) {
            String commits;
            String idAttributeName;
            String statusPath;
            String removePath;
            String updatePath;
            String core;
            String webapp;
            String protocol = this.params.getParameter("Server protocol");
            if (protocol == null || protocol.length() == 0) {
                throw new ManifoldCFException("Missing parameter: Server protocol");
            }
            String server = this.params.getParameter("Server name");
            if (server == null || server.length() == 0) {
                throw new ManifoldCFException("Missing parameter: Server name");
            }
            String port = this.params.getParameter("Server port");
            if (port == null || port.length() == 0) {
                port = "80";
            }
            if ((webapp = this.params.getParameter("Server web application")) == null || webapp.length() == 0) {
                webapp = "";
            }
            if ((core = this.params.getParameter("Solr core name")) != null && core.length() == 0) {
                core = null;
            }
            if ((updatePath = this.params.getParameter("Server update handler")) == null || updatePath.length() == 0) {
                updatePath = "";
            }
            if ((removePath = this.params.getParameter("Server remove handler")) == null || removePath.length() == 0) {
                removePath = "";
            }
            if ((statusPath = this.params.getParameter("Server status handler")) == null || statusPath.length() == 0) {
                statusPath = "";
            }
            if ((idAttributeName = this.params.getParameter("Solr id field name")) == null || idAttributeName.length() == 0) {
                idAttributeName = "id";
            }
            if ((commits = this.params.getParameter("Commits")) == null || commits.length() == 0) {
                commits = "true";
            }
            this.doCommits = commits.equals("true");
            String userID = this.params.getParameter("User ID");
            String password = this.params.getObfuscatedParameter("Password");
            String realm = this.params.getParameter("Realm");
            String keystoreData = this.params.getParameter("Keystore");
            IKeystoreManager keystoreManager = keystoreData != null ? KeystoreManagerFactory.make((String)"", (String)keystoreData) : null;
            if (core != null) {
                if (webapp.length() == 0) {
                    throw new ManifoldCFException("Webapp must be specified if core is specified.");
                }
                webapp = webapp + "/" + core;
            }
            try {
                this.poster = new HttpPoster(protocol, server, Integer.parseInt(port), webapp, updatePath, removePath, statusPath, realm, userID, password, this.allowAttributeName, this.denyAttributeName, idAttributeName, keystoreManager);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException(e.getMessage());
            }
        }
    }

    public String check() throws ManifoldCFException {
        try {
            this.getSession();
            this.poster.checkPost();
            return super.check();
        }
        catch (ServiceInterruption e) {
            return "Transient error: " + e.getMessage();
        }
    }

    public String getOutputDescription(OutputSpecification spec) throws ManifoldCFException {
        String target;
        StringBuffer pairBuffer;
        StringBuffer sb = new StringBuffer();
        HashMap<String, ArrayList<String>> args = new HashMap<String, ArrayList<String>>();
        int i = 0;
        while (i < this.params.getChildCount()) {
            ConfigNode node;
            if (!(node = this.params.getChild(i++)).getType().equals("argument")) continue;
            String attrName = node.getAttributeValue("name");
            ArrayList<String> list = (ArrayList<String>)args.get(attrName);
            if (list == null) {
                list = new ArrayList<String>();
                args.put(attrName, list);
            }
            list.add(node.getAttributeValue("value"));
        }
        Object[] sortArray = new String[args.size()];
        Iterator iter = args.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            sortArray[i++] = (String)iter.next();
        }
        Arrays.sort(sortArray);
        String[] fixedList = new String[2];
        ArrayList<String> nameValues = new ArrayList<String>();
        i = 0;
        while (i < sortArray.length) {
            Object name = sortArray[i++];
            ArrayList values = (ArrayList)args.get(name);
            int j = 0;
            while (j < values.size()) {
                String value = (String)values.get(j++);
                fixedList[0] = name;
                fixedList[1] = value;
                pairBuffer = new StringBuffer();
                SolrConnector.packFixedList(pairBuffer, fixedList, '=');
                nameValues.add(pairBuffer.toString());
            }
        }
        SolrConnector.packList(sb, nameValues, '+');
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        i = 0;
        while (i < spec.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = spec.getChild(i++)).getType().equals("fieldmap")) continue;
            String source = sn.getAttributeValue("source");
            target = sn.getAttributeValue("target");
            if (target == null) {
                target = "";
            }
            fieldMap.put(source, target);
        }
        sortArray = new String[fieldMap.size()];
        i = 0;
        iter = fieldMap.keySet().iterator();
        while (iter.hasNext()) {
            sortArray[i++] = (String)iter.next();
        }
        Arrays.sort(sortArray);
        ArrayList<String> sourceTargets = new ArrayList<String>();
        i = 0;
        while (i < sortArray.length) {
            Object source = sortArray[i++];
            target = (String)fieldMap.get(source);
            fixedList[0] = source;
            fixedList[1] = target;
            pairBuffer = new StringBuffer();
            SolrConnector.packFixedList(pairBuffer, fixedList, '=');
            sourceTargets.add(pairBuffer.toString());
        }
        SolrConnector.packList(sb, sourceTargets, '+');
        return sb.toString();
    }

    public int addOrReplaceDocument(String documentURI, String outputDescription, RepositoryDocument document, String authorityNameString, IOutputAddActivity activities) throws ManifoldCFException, ServiceInterruption {
        String x;
        HashMap<String, ArrayList<String>> args = new HashMap<String, ArrayList<String>>();
        HashMap<String, String> sourceTargets = new HashMap<String, String>();
        int index = 0;
        ArrayList nameValues = new ArrayList();
        index = SolrConnector.unpackList(nameValues, outputDescription, index, '+');
        ArrayList sts = new ArrayList();
        index = SolrConnector.unpackList(sts, outputDescription, index, '+');
        String[] fixedBuffer = new String[2];
        int i = 0;
        while (i < nameValues.size()) {
            x = (String)nameValues.get(i++);
            SolrConnector.unpackFixedList(fixedBuffer, x, 0, '=');
            String attrName = fixedBuffer[0];
            ArrayList<String> list = (ArrayList<String>)args.get(attrName);
            if (list == null) {
                list = new ArrayList<String>();
                args.put(attrName, list);
            }
            list.add(fixedBuffer[1]);
        }
        i = 0;
        while (i < sts.size()) {
            x = (String)sts.get(i++);
            SolrConnector.unpackFixedList(fixedBuffer, x, 0, '=');
            sourceTargets.put(fixedBuffer[0], fixedBuffer[1]);
        }
        this.getSession();
        if (this.poster.indexPost(documentURI, document, args, sourceTargets, authorityNameString, activities)) {
            return 0;
        }
        return 1;
    }

    public void removeDocument(String documentURI, String outputDescription, IOutputRemoveActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        this.poster.deletePost(documentURI, activities);
    }

    public void noteJobComplete(IOutputNotifyActivity activities) throws ManifoldCFException, ServiceInterruption {
        this.getSession();
        if (this.doCommits) {
            this.poster.commitPost();
        }
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Server");
        tabsArray.add("Schema");
        tabsArray.add("Arguments");
        tabsArray.add("Commits");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction SolrDeleteCertificate(aliasName)\n{\n  editconnection.solrkeystorealias.value = aliasName;\n  editconnection.configop.value = \"Delete\";\n  postForm();\n}\n\nfunction SolrAddCertificate()\n{\n  if (editconnection.solrcertificate.value == \"\")\n  {\n    alert(\"Choose a certificate file\");\n    editconnection.solrcertificate.focus();\n  }\n  else\n  {\n    editconnection.configop.value = \"Add\";\n    postForm();\n  }\n}\n\nfunction checkConfig()\n{\n  if (editconnection.servername.value == \"\")\n  {\n    alert(\"Please supply a valid Solr server name\");\n    editconnection.servername.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"Solr server port must be a valid integer\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.webappname.value != \"\" && editconnection.webappname.value.indexOf(\"/\") != -1)\n  {\n    alert(\"Web application name cannot have '/' characters\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (editconnection.core.value != \"\" && editconnection.core.value.indexOf(\"/\") != -1)\n  {\n    alert(\"Core name cannot have '/' characters\");\n    editconnection.core.focus();\n    return false;\n  }\n  if (editconnection.webappname.value == \"\" && editconnection.core.value != \"\")\n  {\n    alert(\"Web application must be specified if core is specified\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (editconnection.updatepath.value != \"\" && editconnection.updatepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"Update path must start with a  '/' character\");\n    editconnection.updatepath.focus();\n    return false;\n  }\n  if (editconnection.removepath.value != \"\" && editconnection.removepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"Remove path must start with a  '/' character\");\n    editconnection.removepath.focus();\n    return false;\n  }\n  if (editconnection.statuspath.value != \"\" && editconnection.statuspath.value.substring(0,1) != \"/\")\n  {\n    alert(\"Status path must start with a  '/' character\");\n    editconnection.statuspath.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.servername.value == \"\")\n  {\n    alert(\"Please supply a valid Solr server name\");\n    SelectTab(\"Server\");\n    editconnection.servername.focus();\n    return false;\n  }\n  if (editconnection.serverport.value != \"\" && !isInteger(editconnection.serverport.value))\n  {\n    alert(\"Solr server port must be a valid integer\");\n    SelectTab(\"Server\");\n    editconnection.serverport.focus();\n    return false;\n  }\n  if (editconnection.webappname.value != \"\" && editconnection.webappname.value.indexOf(\"/\") != -1)\n  {\n    alert(\"Web application name cannot have '/' characters\");\n    SelectTab(\"Server\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (editconnection.core.value != \"\" && editconnection.core.value.indexOf(\"/\") != -1)\n  {\n    alert(\"Core name cannot have '/' characters\");\n    SelectTab(\"Server\");\n    editconnection.core.focus();\n    return false;\n  }\n  if (editconnection.webappname.value == \"\" && editconnection.core.value != \"\")\n  {\n    alert(\"Web application must be specified if core is specified\");\n    SelectTab(\"Server\");\n    editconnection.webappname.focus();\n    return false;\n  }\n  if (editconnection.updatepath.value != \"\" && editconnection.updatepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"Update path must start with a  '/' character\");\n    SelectTab(\"Server\");\n    editconnection.updatepath.focus();\n    return false;\n  }\n  if (editconnection.removepath.value != \"\" && editconnection.removepath.value.substring(0,1) != \"/\")\n  {\n    alert(\"Remove path must start with a  '/' character\");\n    SelectTab(\"Server\");\n    editconnection.removepath.focus();\n    return false;\n  }\n  if (editconnection.statuspath.value != \"\" && editconnection.statuspath.value.substring(0,1) != \"/\")\n  {\n    alert(\"Status path must start with a  '/' character\");\n    SelectTab(\"Server\");\n    editconnection.statuspath.focus();\n    return false;\n  }\n  return true;\n}\n\nfunction deleteArgument(i)\n{\n  // Set the operation\n  eval(\"editconnection.argument_\"+i+\"_op.value=\\\"Delete\\\"\");\n  // Submit\n  if (editconnection.argument_count.value==i)\n    postFormSetAnchor(\"argument\");\n  else\n    postFormSetAnchor(\"argument_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editconnection.argument_\"+i+\"_op.value=\\\"Continue\\\"\");\n}\n\nfunction addArgument()\n{\n  if (editconnection.argument_name.value == \"\")\n  {\n    alert(\"Argument name cannot be an empty string\");\n    editconnection.argument_name.focus();\n    return;\n  }\n  editconnection.argument_op.value=\"Add\";\n  postFormSetAnchor(\"argument\");\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        int i;
        String solrKeystore;
        String commits;
        String password;
        String userID;
        String realm;
        String idField;
        String statusPath;
        String removePath;
        String updatePath;
        String core;
        String webapp;
        String port;
        String server;
        String protocol = parameters.getParameter("Server protocol");
        if (protocol == null) {
            protocol = "http";
        }
        if ((server = parameters.getParameter("Server name")) == null) {
            server = "localhost";
        }
        if ((port = parameters.getParameter("Server port")) == null) {
            port = "8983";
        }
        if ((webapp = parameters.getParameter("Server web application")) == null) {
            webapp = "solr";
        }
        if ((core = parameters.getParameter("Solr core name")) == null) {
            core = "";
        }
        if ((updatePath = parameters.getParameter("Server update handler")) == null) {
            updatePath = "/update/extract";
        }
        if ((removePath = parameters.getParameter("Server remove handler")) == null) {
            removePath = "/update";
        }
        if ((statusPath = parameters.getParameter("Server status handler")) == null) {
            statusPath = "/admin/ping";
        }
        if ((idField = parameters.getParameter("Solr id field name")) == null) {
            idField = "id";
        }
        if ((realm = parameters.getParameter("Realm")) == null) {
            realm = "";
        }
        if ((userID = parameters.getParameter("User ID")) == null) {
            userID = "";
        }
        if ((password = parameters.getObfuscatedParameter("Password")) == null) {
            password = "";
        }
        if ((commits = parameters.getParameter("Commits")) == null) {
            commits = "true";
        }
        IKeystoreManager localKeystore = (solrKeystore = parameters.getParameter("Keystore")) == null ? KeystoreManagerFactory.make((String)"") : KeystoreManagerFactory.make((String)"", (String)solrKeystore);
        if (solrKeystore != null) {
            out.print("<input type=\"hidden\" name=\"keystoredata\" value=\"" + Encoder.attributeEscape((String)solrKeystore) + "\"/>\n");
        }
        out.print("<input name=\"configop\" type=\"hidden\" value=\"Continue\"/>\n");
        if (tabName.equals("Server")) {
            out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>Protocol:</nobr></td>\n    <td class=\"value\">\n      <select name=\"serverprotocol\">\n        <option value=\"http\"" + (protocol.equals("http") ? " selected=\"true\"" : "") + ">http</option>\n" + "        <option value=\"https\"" + (protocol.equals("https") ? " selected=\"true\"" : "") + ">https</option>\n" + "      </select>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Server name:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"servername\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Port:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"serverport\" type=\"text\" size=\"5\" value=\"" + Encoder.attributeEscape((String)port) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Web application name:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"webappname\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)webapp) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Core name:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"core\" type=\"text\" size=\"16\" value=\"" + Encoder.attributeEscape((String)core) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Update handler:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"updatepath\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)updatePath) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Remove handler:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"removepath\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)removePath) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Status handler:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"statuspath\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)statusPath) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr><td colspan=\"2\" class=\"separator\"><hr/></td></tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Realm:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"realm\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)realm) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>User ID:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input name=\"userid\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Password:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>SSL trust certificate list:</nobr></td>\n" + "    <td class=\"value\">\n" + "      <input type=\"hidden\" name=\"solrkeystorealias\" value=\"\"/>\n" + "      <table class=\"displaytable\">\n");
            String[] contents = localKeystore.getContents();
            if (contents.length == 0) {
                out.print("        <tr><td class=\"message\" colspan=\"2\"><nobr>No certificates present</nobr></td></tr>\n");
            } else {
                for (i = 0; i < contents.length; ++i) {
                    String alias = contents[i];
                    String description = localKeystore.getDescription(alias);
                    if (description.length() > 128) {
                        description = description.substring(0, 125) + "...";
                    }
                    out.print("        <tr>\n          <td class=\"value\"><input type=\"button\" onclick='Javascript:SolrDeleteCertificate(\"" + Encoder.attributeJavascriptEscape((String)alias) + "\")' alt=\"" + "Delete cert " + Encoder.attributeEscape((String)alias) + "\" value=\"Delete\"/></td>\n" + "          <td>" + Encoder.bodyEscape((String)description) + "</td>\n" + "        </tr>\n");
                }
            }
            out.print("      </table>\n      <input type=\"button\" onclick='Javascript:SolrAddCertificate()' alt=\"Add cert\" value=\"Add\"/>&nbsp;\n      Certificate:&nbsp;<input name=\"solrcertificate\" size=\"50\" type=\"file\"/>\n    </td>\n  </tr>\n</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"serverprotocol\" value=\"" + Encoder.attributeEscape((String)protocol) + "\"/>\n" + "<input type=\"hidden\" name=\"servername\" value=\"" + Encoder.attributeEscape((String)server) + "\"/>\n" + "<input type=\"hidden\" name=\"serverport\" value=\"" + Encoder.attributeEscape((String)port) + "\"/>\n" + "<input type=\"hidden\" name=\"webappname\" value=\"" + Encoder.attributeEscape((String)webapp) + "\"/>\n" + "<input type=\"hidden\" name=\"core\" value=\"" + Encoder.attributeEscape((String)core) + "\"/>\n" + "<input type=\"hidden\" name=\"updatepath\" value=\"" + Encoder.attributeEscape((String)updatePath) + "\"/>\n" + "<input type=\"hidden\" name=\"removepath\" value=\"" + Encoder.attributeEscape((String)removePath) + "\"/>\n" + "<input type=\"hidden\" name=\"statuspath\" value=\"" + Encoder.attributeEscape((String)statusPath) + "\"/>\n" + "<input type=\"hidden\" name=\"realm\" value=\"" + Encoder.attributeEscape((String)realm) + "\"/>\n" + "<input type=\"hidden\" name=\"userid\" value=\"" + Encoder.attributeEscape((String)userID) + "\"/>\n" + "<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
        if (tabName.equals("Schema")) {
            out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>ID field name:</nobr></td>\n    <td class=\"value\">\n      <input name=\"idfield\" type=\"text\" size=\"32\" value=\"" + Encoder.attributeEscape((String)idField) + "\"/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"idfield\" value=\"" + Encoder.attributeEscape((String)idField) + "\"/>\n");
        }
        HashMap<String, ArrayList<String>> argumentMap = new HashMap<String, ArrayList<String>>();
        i = 0;
        while (i < parameters.getChildCount()) {
            ConfigNode sn;
            if (!(sn = parameters.getChild(i++)).getType().equals("argument")) continue;
            String name = sn.getAttributeValue("name");
            String value = sn.getAttributeValue("value");
            ArrayList<String> values = (ArrayList<String>)argumentMap.get(name);
            if (values == null) {
                values = new ArrayList<String>();
                argumentMap.put(name, values);
            }
            values.add(value);
        }
        if (tabName.equals("Commits")) {
            out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>Commit at end of every job:</nobr></td>\n    <td class=\"value\">\n      <input name=\"commits_present\" type=\"hidden\" value=\"true\"/>\n      <input name=\"commits\" type=\"checkbox\" value=\"true\"" + (commits.equals("true") ? " checked=\"yes\"" : "") + "/>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"commits_present\" value=\"true\"/>\n<input name=\"commits\" type=\"hidden\" value=\"" + commits + "\"/>\n");
        }
        if (tabName.equals("Arguments")) {
            Object[] sortArray = new String[argumentMap.size()];
            i = 0;
            Iterator iter = argumentMap.keySet().iterator();
            while (iter.hasNext()) {
                sortArray[i++] = (String)iter.next();
            }
            Arrays.sort(sortArray);
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Arguments:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>Name</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Value</nobr></td>\n        </tr>\n");
            i = 0;
            int k = 0;
            while (k < sortArray.length) {
                Object name = sortArray[k++];
                ArrayList values = (ArrayList)argumentMap.get(name);
                int j = 0;
                while (j < values.size()) {
                    String value = (String)values.get(j++);
                    String prefix = "argument_" + Integer.toString(i);
                    out.print("        <tr class=\"" + (i % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix + "\"><input type=\"button\" value=\"Delete\" alt=\"Delete argument #" + Integer.toString(i + 1) + "\" onclick=\"javascript:deleteArgument(" + Integer.toString(i) + ");" + "\"/>\n" + "              <input type=\"hidden\" name=\"" + prefix + "_op" + "\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"" + prefix + "_name" + "\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)name) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"" + prefix + "_value" + "\" value=\"" + Encoder.attributeEscape((String)value) + "\"</nobr>\n" + "          </td>\n" + "        </tr>\n");
                    ++i;
                }
            }
            if (i == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">No arguments specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"argument\"><input type=\"button\" value=\"Add\" alt=\"Add argument\" onclick=\"javascript:addArgument();\"/></a>\n              <input type=\"hidden\" name=\"argument_count\" value=\"" + Integer.toString(i) + "\"/>\n" + "              <input type=\"hidden\" name=\"argument_op\" value=\"Continue\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"argument_name\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"30\" name=\"argument_value\" value=\"\"/></nobr>\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            i = 0;
            for (String name : argumentMap.keySet()) {
                ArrayList values = (ArrayList)argumentMap.get(name);
                int j = 0;
                while (j < values.size()) {
                    String value = (String)values.get(j++);
                    String prefix = "argument_" + Integer.toString(i++);
                    out.print("<input type=\"hidden\" name=\"" + prefix + "_name\" value=\"" + Encoder.attributeEscape((String)name) + "\"/>\n" + "<input type=\"hidden\" name=\"" + prefix + "_value\" value=\"" + Encoder.attributeEscape((String)value) + "\"/>\n");
                }
            }
            out.print("<input type=\"hidden\" name=\"argument_count\" value=\"" + Integer.toString(i) + "\"/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String configOp;
        String keystoreValue;
        String commitsPresent;
        String password;
        String userID;
        String realm;
        String idField;
        String statusPath;
        String removePath;
        String updatePath;
        String core;
        String webapp;
        String port;
        String server;
        String protocol = variableContext.getParameter("serverprotocol");
        if (protocol != null) {
            parameters.setParameter("Server protocol", protocol);
        }
        if ((server = variableContext.getParameter("servername")) != null) {
            parameters.setParameter("Server name", server);
        }
        if ((port = variableContext.getParameter("serverport")) != null) {
            parameters.setParameter("Server port", port);
        }
        if ((webapp = variableContext.getParameter("webappname")) != null) {
            parameters.setParameter("Server web application", webapp);
        }
        if ((core = variableContext.getParameter("core")) != null) {
            parameters.setParameter("Solr core name", core);
        }
        if ((updatePath = variableContext.getParameter("updatepath")) != null) {
            parameters.setParameter("Server update handler", updatePath);
        }
        if ((removePath = variableContext.getParameter("removepath")) != null) {
            parameters.setParameter("Server remove handler", removePath);
        }
        if ((statusPath = variableContext.getParameter("statuspath")) != null) {
            parameters.setParameter("Server status handler", statusPath);
        }
        if ((idField = variableContext.getParameter("idfield")) != null) {
            parameters.setParameter("Solr id field name", idField);
        }
        if ((realm = variableContext.getParameter("realm")) != null) {
            parameters.setParameter("Realm", realm);
        }
        if ((userID = variableContext.getParameter("userid")) != null) {
            parameters.setParameter("User ID", userID);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", password);
        }
        if ((commitsPresent = variableContext.getParameter("commits_present")) != null) {
            String commits = variableContext.getParameter("commits");
            if (commits == null) {
                commits = "false";
            }
            parameters.setParameter("Commits", commits);
        }
        IKeystoreManager mgr = (keystoreValue = variableContext.getParameter("keystoredata")) != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
        parameters.setParameter("Keystore", mgr.getString());
        String x = variableContext.getParameter("argument_count");
        if (x != null && x.length() > 0) {
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode node = parameters.getChild(i);
                if (node.getType().equals("argument")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String prefix = "argument_" + Integer.toString(i);
                String op = variableContext.getParameter(prefix + "_op");
                if (op != null && op.equals("Delete")) continue;
                String name = variableContext.getParameter(prefix + "_name");
                String value = variableContext.getParameter(prefix + "_value");
                ConfigNode node = new ConfigNode("argument");
                node.setAttribute("name", name);
                node.setAttribute("value", value);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
            String addop = variableContext.getParameter("argument_op");
            if (addop != null && addop.equals("Add")) {
                String name = variableContext.getParameter("argument_name");
                String value = variableContext.getParameter("argument_value");
                ConfigNode node = new ConfigNode("argument");
                node.setAttribute("name", name);
                node.setAttribute("value", value);
                parameters.addChild(parameters.getChildCount(), (ConfigurationNode)node);
            }
        }
        if ((configOp = variableContext.getParameter("configop")) != null) {
            if (configOp.equals("Delete")) {
                String alias = variableContext.getParameter("solrkeystorealias");
                keystoreValue = parameters.getParameter("Keystore");
                mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                mgr.remove(alias);
                parameters.setParameter("Keystore", mgr.getString());
            } else if (configOp.equals("Add")) {
                String alias = IDFactory.make((IThreadContext)threadContext);
                byte[] certificateValue = variableContext.getBinaryBytes("solrcertificate");
                keystoreValue = parameters.getParameter("Keystore");
                mgr = keystoreValue != null ? KeystoreManagerFactory.make((String)"", (String)keystoreValue) : KeystoreManagerFactory.make((String)"");
                ByteArrayInputStream is = new ByteArrayInputStream(certificateValue);
                String certError = null;
                try {
                    mgr.importCertificate(alias, (InputStream)is);
                }
                catch (Throwable e) {
                    certError = e.getMessage();
                }
                finally {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException e) {}
                }
                if (certError != null) {
                    return "Illegal certificate: " + certError;
                }
                parameters.setParameter("Keystore", mgr.getString());
            }
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Parameters:</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=<" + Integer.toString(kmanager.getContents().length) + " certificate(s)></nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Arguments:</nobr></td>\n    <td class=\"boxcell\" colspan=\"3\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>Name</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Value</nobr></td>\n        </tr>\n");
        int i = 0;
        int instanceNumber = 0;
        while (i < parameters.getChildCount()) {
            ConfigNode cn;
            if (!(cn = parameters.getChild(i++)).getType().equals("argument")) continue;
            String name = cn.getAttributeValue("name");
            String value = cn.getAttributeValue("value");
            out.print("        <tr class=\"" + (instanceNumber % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)name) + "</nobr></td>\n" + "          <td class=\"formcolumncell\"><nobr>" + Encoder.bodyEscape((String)value) + "</nobr></td>\n" + "        </tr>\n");
            ++instanceNumber;
        }
        if (instanceNumber == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"5\">No arguments</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n</table>\n");
    }

    public void outputSpecificationHeader(IHTTPOutput out, OutputSpecification os, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Field Mapping");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkOutputSpecification()\n{\n  return true;\n}\n\nfunction addFieldMapping()\n{\n  if (editjob.solr_fieldmapping_source.value == \"\")\n  {\n    alert(\"Field map must have non-null source\");\n    editjob.solr_fieldmapping_source.focus();\n    return;\n  }\n  editjob.solr_fieldmapping_op.value=\"Add\";\n  postFormSetAnchor(\"solr_fieldmapping\");\n}\n\nfunction deleteFieldMapping(i)\n{\n  // Set the operation\n  eval(\"editjob.solr_fieldmapping_\"+i+\"_op.value=\\\"Delete\\\"\");\n  // Submit\n  if (editjob.solr_fieldmapping_count.value==i)\n    postFormSetAnchor(\"solr_fieldmapping\");\n  else\n    postFormSetAnchor(\"solr_fieldmapping_\"+i)\n  // Undo, so we won't get two deletes next time\n  eval(\"editjob.solr_fieldmapping_\"+i+\"_op.value=\\\"Continue\\\"\");\n}\n\n//-->\n</script>\n");
    }

    public void outputSpecificationBody(IHTTPOutput out, OutputSpecification os, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        int i = 0;
        while (i < os.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = os.getChild(i++)).getType().equals("fieldmap")) continue;
            String source = sn.getAttributeValue("source");
            String target = sn.getAttributeValue("target");
            if (target != null && target.length() == 0) {
                target = null;
            }
            fieldMap.put(source, target);
        }
        if (tabName.equals("Field Mapping")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Field mappings:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"></td>\n          <td class=\"formcolumnheader\"><nobr>Metadata field name</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Solr field name</nobr></td>\n        </tr>\n");
            Object[] sourceFieldNames = new String[fieldMap.size()];
            Iterator iter = fieldMap.keySet().iterator();
            i = 0;
            while (iter.hasNext()) {
                sourceFieldNames[i++] = (String)iter.next();
            }
            Arrays.sort(sourceFieldNames);
            int fieldCounter = 0;
            i = 0;
            while (i < sourceFieldNames.length) {
                String target;
                Object source = sourceFieldNames[i++];
                String targetDisplay = target = (String)fieldMap.get(source);
                if (target == null) {
                    target = "";
                    targetDisplay = "(remove)";
                }
                String prefix = "solr_fieldmapping_" + Integer.toString(fieldCounter);
                out.print("        <tr class=\"" + (fieldCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <a name=\"" + prefix + "\">\n" + "              <input type=\"button\" value=\"Delete\" alt=\"" + "Delete field mapping #" + Integer.toString(fieldCounter + 1) + "\" onclick='javascript:deleteFieldMapping(" + Integer.toString(fieldCounter) + ");'/>\n" + "              <input type=\"hidden\" name=\"" + prefix + "_op\" value=\"Continue\"/>\n" + "              <input type=\"hidden\" name=\"" + prefix + "_source\" value=\"" + Encoder.attributeEscape((String)source) + "\"/>\n" + "              <input type=\"hidden\" name=\"" + prefix + "_target\" value=\"" + Encoder.attributeEscape((String)target) + "\"/>\n" + "            </a>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)source) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)targetDisplay) + "</nobr>\n" + "          </td>\n" + "        </tr>\n");
                ++fieldCounter;
            }
            if (fieldCounter == 0) {
                out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">No field mapping specified</td></tr>\n");
            }
            out.print("        <tr class=\"formrow\"><td class=\"formseparator\" colspan=\"3\"><hr/></td></tr>\n        <tr class=\"formrow\">\n          <td class=\"formcolumncell\">\n            <a name=\"solr_fieldmapping\">\n              <input type=\"button\" value=\"Add\" alt=\"Add field mapping\" onclick=\"javascript:addFieldMapping();\"/>\n            </a>\n            <input type=\"hidden\" name=\"solr_fieldmapping_count\" value=\"" + fieldCounter + "\"/>\n" + "            <input type=\"hidden\" name=\"solr_fieldmapping_op\" value=\"Continue\"/>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"15\" name=\"solr_fieldmapping_source\" value=\"\"/></nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr><input type=\"text\" size=\"15\" name=\"solr_fieldmapping_target\" value=\"\"/></nobr>\n" + "          </td>\n" + "        </tr>\n" + "      </table>\n" + "    </td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"solr_fieldmapping_count\" value=\"" + Integer.toString(fieldMap.size()) + "\"/>\n");
            Iterator iter = fieldMap.keySet().iterator();
            int fieldCounter = 0;
            while (iter.hasNext()) {
                String source = (String)iter.next();
                String target = (String)fieldMap.get(source);
                if (target == null) {
                    target = "";
                }
                String prefix = "solr_fieldmapping_" + Integer.toString(fieldCounter);
                out.print("<input type=\"hidden\" name=\"" + prefix + "_source\" value=\"" + Encoder.attributeEscape((String)source) + "\"/>\n" + "<input type=\"hidden\" name=\"" + prefix + "_target\" value=\"" + Encoder.attributeEscape((String)target) + "\"/>\n");
                ++fieldCounter;
            }
        }
    }

    public String processSpecificationPost(IPostParameters variableContext, OutputSpecification os) throws ManifoldCFException {
        String x = variableContext.getParameter("solr_fieldmapping_count");
        if (x != null && x.length() > 0) {
            int i = 0;
            while (i < os.getChildCount()) {
                SpecificationNode node = os.getChild(i);
                if (node.getType().equals("fieldmap")) {
                    os.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            for (i = 0; i < count; ++i) {
                String prefix = "solr_fieldmapping_" + Integer.toString(i);
                String op = variableContext.getParameter(prefix + "_op");
                if (op != null && op.equals("Delete")) continue;
                String source = variableContext.getParameter(prefix + "_source");
                String target = variableContext.getParameter(prefix + "_target");
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
            String addop = variableContext.getParameter("solr_fieldmapping_op");
            if (addop != null && addop.equals("Add")) {
                String source = variableContext.getParameter("solr_fieldmapping_source");
                String target = variableContext.getParameter("solr_fieldmapping_target");
                if (target == null) {
                    target = "";
                }
                SpecificationNode node = new SpecificationNode("fieldmap");
                node.setAttribute("source", source);
                node.setAttribute("target", target);
                os.addChild(os.getChildCount(), (ConfigurationNode)node);
            }
        }
        return null;
    }

    public void viewSpecification(IHTTPOutput out, OutputSpecification os) throws ManifoldCFException, IOException {
        int fieldCounter;
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        int i = 0;
        while (i < os.getChildCount()) {
            SpecificationNode sn;
            if (!(sn = os.getChild(i++)).getType().equals("fieldmap")) continue;
            String source = sn.getAttributeValue("source");
            String target = sn.getAttributeValue("target");
            if (target != null && target.length() == 0) {
                target = null;
            }
            fieldMap.put(source, target);
        }
        Object[] sourceFieldNames = new String[fieldMap.size()];
        Iterator iter = fieldMap.keySet().iterator();
        i = 0;
        while (iter.hasNext()) {
            sourceFieldNames[i++] = (String)iter.next();
        }
        Arrays.sort(sourceFieldNames);
        out.print("\n<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\"><nobr>Field mappings:</nobr></td>\n    <td class=\"boxcell\">\n      <table class=\"formtable\">\n        <tr class=\"formheaderrow\">\n          <td class=\"formcolumnheader\"><nobr>Metadata field name</nobr></td>\n          <td class=\"formcolumnheader\"><nobr>Solr field name</nobr></td>\n        </tr>\n");
        for (fieldCounter = 0; fieldCounter < sourceFieldNames.length; ++fieldCounter) {
            String target;
            Object source = sourceFieldNames[fieldCounter++];
            String targetDisplay = target = (String)fieldMap.get(source);
            if (target == null) {
                target = "";
                targetDisplay = "(remove)";
            }
            out.print("        <tr class=\"" + (fieldCounter % 2 == 0 ? "evenformrow" : "oddformrow") + "\">\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)source) + "</nobr>\n" + "          </td>\n" + "          <td class=\"formcolumncell\">\n" + "            <nobr>" + Encoder.bodyEscape((String)targetDisplay) + "</nobr>\n" + "          </td>\n" + "        </tr>\n");
        }
        if (fieldCounter == 0) {
            out.print("        <tr class=\"formrow\"><td class=\"formmessage\" colspan=\"3\">No field mapping specified</td></tr>\n");
        }
        out.print("      </table>\n    </td>\n  </tr>\n</table>\n");
    }

    protected static void pack(StringBuffer output, String value, char delimiter) {
        int i = 0;
        while (i < value.length()) {
            char x;
            if ((x = value.charAt(i++)) == '\\' || x == delimiter) {
                output.append('\\');
            }
            output.append(x);
        }
        output.append(delimiter);
    }

    protected static int unpack(StringBuffer sb, String value, int startPosition, char delimiter) {
        while (startPosition < value.length()) {
            char x;
            if ((x = value.charAt(startPosition++)) == '\\') {
                if (startPosition < value.length()) {
                    x = value.charAt(startPosition++);
                }
            } else if (x == delimiter) break;
            sb.append(x);
        }
        return startPosition;
    }

    protected static void packFixedList(StringBuffer output, String[] values, char delimiter) {
        int i = 0;
        while (i < values.length) {
            SolrConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackFixedList(String[] output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < output.length) {
            sb.setLength(0);
            startPosition = SolrConnector.unpack(sb, value, startPosition, delimiter);
            output[i++] = sb.toString();
        }
        return startPosition;
    }

    protected static void packList(StringBuffer output, ArrayList values, char delimiter) {
        SolrConnector.pack(output, Integer.toString(values.size()), delimiter);
        int i = 0;
        while (i < values.size()) {
            SolrConnector.pack(output, values.get(i++).toString(), delimiter);
        }
    }

    protected static void packList(StringBuffer output, String[] values, char delimiter) {
        SolrConnector.pack(output, Integer.toString(values.length), delimiter);
        int i = 0;
        while (i < values.length) {
            SolrConnector.pack(output, values[i++], delimiter);
        }
    }

    protected static int unpackList(ArrayList output, String value, int startPosition, char delimiter) {
        StringBuffer sb = new StringBuffer();
        startPosition = SolrConnector.unpack(sb, value, startPosition, delimiter);
        try {
            int count = Integer.parseInt(sb.toString());
            for (int i = 0; i < count; ++i) {
                sb.setLength(0);
                startPosition = SolrConnector.unpack(sb, value, startPosition, delimiter);
                output.add(sb.toString());
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return startPosition;
    }
}

