/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.parse;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.nutch.metadata.Metadata;
import org.apache.nutch.parse.HTMLMetaTags;
import org.apache.nutch.parse.HtmlParseFilter;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseResult;
import org.apache.nutch.protocol.Content;
import org.w3c.dom.DocumentFragment;

public class MetaTagsParser
implements HtmlParseFilter {
    private static final Log LOG = LogFactory.getLog((String)MetaTagsParser.class.getName());
    private Configuration conf;
    private Set<String> metatagset = new HashSet<String>();

    public void setConf(Configuration conf) {
        String[] values;
        this.conf = conf;
        String metatags = conf.get("metatags.names", "*");
        for (String val : values = metatags.split(";")) {
            this.metatagset.add(val.toLowerCase());
        }
    }

    public Configuration getConf() {
        return this.conf;
    }

    public ParseResult filter(Content content, ParseResult parseResult, HTMLMetaTags metaTags, DocumentFragment doc) {
        String value;
        Parse parse = parseResult.get(content.getUrl());
        Metadata metadata = parse.getData().getParseMeta();
        for (String mdName : metadata.names()) {
            value = metadata.get(mdName);
            if (!this.metatagset.contains("*") && !this.metatagset.contains(mdName.toLowerCase())) continue;
            LOG.debug((Object)("Found meta tag : " + mdName + "\t" + value));
            metadata.add("metatag." + mdName.toLowerCase(), value);
        }
        Metadata generalMetaTags = metaTags.getGeneralTags();
        for (String tagName : generalMetaTags.names()) {
            String[] tagValues;
            for (String tagValue : tagValues = generalMetaTags.getValues(tagName)) {
                if (!this.metatagset.contains("*") && !this.metatagset.contains(tagName.toLowerCase())) continue;
                LOG.debug((Object)("Found meta tag : " + tagName + "\t" + tagValue));
                metadata.add("metatag." + tagName.toLowerCase(), tagValue);
            }
        }
        Properties httpequiv = metaTags.getHttpEquivTags();
        Enumeration<?> tagNames = httpequiv.propertyNames();
        while (tagNames.hasMoreElements()) {
            String name = (String)tagNames.nextElement();
            value = httpequiv.getProperty(name);
            if (!this.metatagset.contains("*") && !this.metatagset.contains(name.toLowerCase())) continue;
            LOG.debug((Object)("Found meta tag : " + name + "\t" + value));
            metadata.add("metatag." + name.toLowerCase(), value);
        }
        return parseResult;
    }
}

