/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.activedirectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IKeystoreManager;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.KeystoreManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.ui.util.Encoder;

public class ActiveDirectoryAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: ActiveDirectoryAuthority.java 988245 2010-08-23 18:39:35Z kwright $";
    private String domainControllerName = null;
    private String userName = null;
    private String password = null;
    private LdapContext ctx = null;
    private long expiration = -1L;
    private static final long expirationInterval = 300000L;
    private static final String globalDenyToken = "DEAD_AUTHORITY";
    private static final AuthorizationResponse unreachableResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 1);
    private static final AuthorizationResponse userNotFoundResponse = new AuthorizationResponse(new String[]{"DEAD_AUTHORITY"}, 2);

    public String getJSPFolder() {
        return "activedirectory";
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.domainControllerName = configParams.getParameter("Domain controller");
        this.userName = configParams.getParameter("User name");
        this.password = configParams.getObfuscatedParameter("Password");
    }

    public String check() throws ManifoldCFException {
        this.getSession();
        return super.check();
    }

    public void poll() throws ManifoldCFException {
        if (this.expiration != -1L && System.currentTimeMillis() > this.expiration) {
            this.closeConnection();
        }
        super.poll();
    }

    protected void closeConnection() {
        if (this.ctx != null) {
            try {
                this.ctx.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
            this.ctx = null;
            this.expiration = -1L;
        }
    }

    public void disconnect() throws ManifoldCFException {
        this.closeConnection();
        this.domainControllerName = null;
        this.userName = null;
        this.password = null;
        super.disconnect();
    }

    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSession();
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(0);
        String searchFilter = "(objectClass=user)";
        String searchBase = ActiveDirectoryAuthority.parseUser(userName);
        String[] returnedAtts = new String[]{"tokenGroups", "objectSid"};
        searchCtls.setReturningAttributes(returnedAtts);
        try {
            NamingEnumeration<SearchResult> answer = this.ctx.search(searchBase, searchFilter, searchCtls);
            ArrayList<String> theGroups = new ArrayList<String>();
            theGroups.add("S-1-1-0");
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                try {
                    NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                    while (ae.hasMore()) {
                        Attribute attr = ae.next();
                        NamingEnumeration<?> e = attr.getAll();
                        while (e.hasMore()) {
                            theGroups.add(ActiveDirectoryAuthority.sid2String((byte[])e.next()));
                        }
                    }
                }
                catch (NamingException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                }
            }
            String[] tokens = new String[theGroups.size()];
            for (int k = 0; k < tokens.length; ++k) {
                tokens[k] = (String)theGroups.get(k);
            }
            return new AuthorizationResponse(tokens, 0);
        }
        catch (NameNotFoundException e) {
            return userNotFoundResponse;
        }
        catch (NamingException e) {
            return unreachableResponse;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return unreachableResponse;
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, ArrayList tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add("Domain Controller");
        out.print("<script type=\"text/javascript\">\n<!--\nfunction checkConfig()\n{\n  return true;\n}\n\nfunction checkConfigForSave()\n{\n  if (editconnection.domaincontrollername.value == \"\")\n  {\n    alert(\"Enter a domain controller server name\");\n    SelectTab(\"Domain Controller\");\n    editconnection.domaincontrollername.focus();\n    return false;\n  }\n  if (editconnection.username.value == \"\")\n  {\n    alert(\"Administrative user name cannot be null\");\n    SelectTab(\"Domain Controller\");\n    editconnection.username.focus();\n    return false;\n  }\n  return true;\n}\n\n//-->\n</script>\n");
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        String password;
        String userName;
        String domainControllerName = parameters.getParameter("Domain controller");
        if (domainControllerName == null) {
            domainControllerName = "";
        }
        if ((userName = parameters.getParameter("User name")) == null) {
            userName = "";
        }
        if ((password = parameters.getObfuscatedParameter("Password")) == null) {
            password = "";
        }
        if (tabName.equals("Domain Controller")) {
            out.print("<table class=\"displaytable\">\n  <tr><td class=\"separator\" colspan=\"2\"><hr/></td></tr>\n  <tr>\n    <td class=\"description\"><nobr>Domain controller name:</nobr></td>\n    <td class=\"value\"><input type=\"text\" size=\"64\" name=\"domaincontrollername\" value=\"" + Encoder.attributeEscape((String)domainControllerName) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Administrative user name:</nobr></td>\n" + "    <td class=\"value\"><input type=\"text\" size=\"32\" name=\"username\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/></td>\n" + "  </tr>\n" + "  <tr>\n" + "    <td class=\"description\"><nobr>Administrative password:</nobr></td>\n" + "    <td class=\"value\"><input type=\"password\" size=\"32\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/></td>\n" + "  </tr>\n" + "</table>\n");
        } else {
            out.print("<input type=\"hidden\" name=\"domaincontrollername\" value=\"" + Encoder.attributeEscape((String)domainControllerName) + "\"/>\n" + "<input type=\"hidden\" name=\"username\" value=\"" + Encoder.attributeEscape((String)userName) + "\"/>\n" + "<input type=\"hidden\" name=\"password\" value=\"" + Encoder.attributeEscape((String)password) + "\"/>\n");
        }
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, ConfigParams parameters) throws ManifoldCFException {
        String password;
        String userName;
        String domainControllerName = variableContext.getParameter("domaincontrollername");
        if (domainControllerName != null) {
            parameters.setParameter("Domain controller", domainControllerName);
        }
        if ((userName = variableContext.getParameter("username")) != null) {
            parameters.setParameter("User name", userName);
        }
        if ((password = variableContext.getParameter("password")) != null) {
            parameters.setObfuscatedParameter("Password", password);
        }
        return null;
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, ConfigParams parameters) throws ManifoldCFException, IOException {
        out.print("<table class=\"displaytable\">\n  <tr>\n    <td class=\"description\" colspan=\"1\"><nobr>Parameters:</nobr></td>\n    <td class=\"value\" colspan=\"3\">\n");
        Iterator iter = parameters.listParameters();
        while (iter.hasNext()) {
            String param = (String)iter.next();
            String value = parameters.getParameter(param);
            if (param.length() >= "password".length() && param.substring(param.length() - "password".length()).equalsIgnoreCase("password")) {
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=********</nobr><br/>\n");
                continue;
            }
            if (param.length() >= "keystore".length() && param.substring(param.length() - "keystore".length()).equalsIgnoreCase("keystore")) {
                IKeystoreManager kmanager = KeystoreManagerFactory.make((String)"", (String)value);
                out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=<" + Integer.toString(kmanager.getContents().length) + " certificate(s)></nobr><br/>\n");
                continue;
            }
            out.print("      <nobr>" + Encoder.bodyEscape((String)param) + "=" + Encoder.bodyEscape((String)value) + "</nobr><br/>\n");
        }
        out.print("    </td>\n  </tr>\n</table>\n");
    }

    protected void getSession() throws ManifoldCFException {
        if (this.ctx == null) {
            String ldapURL = "ldap://" + this.domainControllerName + ":389";
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            env.put("java.naming.security.authentication", "DIGEST-MD5 GSSAPI");
            env.put("java.naming.security.principal", this.userName);
            env.put("java.naming.security.credentials", this.password);
            env.put("java.naming.provider.url", ldapURL);
            env.put("java.naming.ldap.attributes.binary", "tokenGroups objectSid");
            try {
                this.ctx = new InitialLdapContext(env, null);
            }
            catch (AuthenticationException e) {
                throw new ManifoldCFException("Authentication problem authenticating admin user '" + this.userName + "': " + e.getMessage(), (Throwable)e);
            }
            catch (CommunicationException e) {
                throw new ManifoldCFException("Couldn't communicate with domain controller '" + this.domainControllerName + "': " + e.getMessage(), (Throwable)e);
            }
            catch (NamingException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            this.ctx.reconnect(null);
        }
        catch (AuthenticationException e) {
            throw new ManifoldCFException("Authentication problem authenticating admin user '" + this.userName + "': " + e.getMessage(), (Throwable)e);
        }
        catch (CommunicationException e) {
            throw new ManifoldCFException("Couldn't communicate with domain controller '" + this.domainControllerName + "': " + e.getMessage(), (Throwable)e);
        }
        catch (NamingException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
        this.expiration = System.currentTimeMillis() + 300000L;
    }

    protected static String parseUser(String userName) throws ManifoldCFException {
        int index = userName.indexOf("@");
        if (index == -1) {
            throw new ManifoldCFException("Username is in unexpected form (no @): '" + userName + "'");
        }
        String userPart = userName.substring(0, index);
        String domainPart = userName.substring(index + 1);
        StringBuffer sb = new StringBuffer();
        sb.append("CN=").append(userPart).append(",CN=Users");
        int j = 0;
        while (true) {
            int k;
            if ((k = domainPart.indexOf(".", j)) == -1) break;
            sb.append(",DC=").append(domainPart.substring(j, k));
            j = k + 1;
        }
        sb.append(",DC=").append(domainPart.substring(j));
        return sb.toString();
    }

    protected static String sid2String(byte[] SID) {
        StringBuffer strSID = new StringBuffer("S");
        long version = SID[0];
        strSID.append("-").append(Long.toString(version));
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID.append("-").append(Long.toString(authority));
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID.append("-").append(Long.toString(rid));
            ++j;
        }
        return strSID.toString();
    }
}

