/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.scoring.tld;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.indexer.NutchField;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.parse.ParseData;
import org.apache.nutch.protocol.Content;
import org.apache.nutch.scoring.ScoringFilter;
import org.apache.nutch.scoring.ScoringFilterException;
import org.apache.nutch.util.domain.DomainSuffix;
import org.apache.nutch.util.domain.DomainSuffixes;

public class TLDScoringFilter
implements ScoringFilter {
    private Configuration conf;
    private DomainSuffixes tldEntries = DomainSuffixes.getInstance();

    public float indexerScore(Text url, NutchDocument doc, CrawlDatum dbDatum, CrawlDatum fetchDatum, Parse parse, Inlinks inlinks, float initScore) throws ScoringFilterException {
        NutchField tlds = doc.getField("tld");
        float boost = 1.0f;
        if (tlds != null) {
            for (Object tld : tlds.getValues()) {
                DomainSuffix entry = this.tldEntries.get(tld.toString());
                if (entry == null) continue;
                boost *= entry.getBoost();
            }
        }
        return initScore * boost;
    }

    public CrawlDatum distributeScoreToOutlink(Text fromUrl, Text toUrl, ParseData parseData, CrawlDatum target, CrawlDatum adjust, int allCount, int validCount) throws ScoringFilterException {
        return adjust;
    }

    public float generatorSortValue(Text url, CrawlDatum datum, float initSort) throws ScoringFilterException {
        return initSort;
    }

    public void initialScore(Text url, CrawlDatum datum) throws ScoringFilterException {
    }

    public void injectedScore(Text url, CrawlDatum datum) throws ScoringFilterException {
    }

    public void passScoreAfterParsing(Text url, Content content, Parse parse) throws ScoringFilterException {
    }

    public void passScoreBeforeParsing(Text url, CrawlDatum datum, Content content) throws ScoringFilterException {
    }

    public void updateDbScore(Text url, CrawlDatum old, CrawlDatum datum, List<CrawlDatum> inlinked) throws ScoringFilterException {
    }

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    public CrawlDatum distributeScoreToOutlinks(Text fromUrl, ParseData parseData, Collection<Map.Entry<Text, CrawlDatum>> targets, CrawlDatum adjust, int allCount) throws ScoringFilterException {
        return adjust;
    }
}

