/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocFieldConsumerPerField;
import org.apache.lucene.index.DocFieldProcessor;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.RamUsageEstimator;

final class DocFieldProcessorPerField {
    final DocFieldConsumerPerField consumer;
    final FieldInfo fieldInfo;
    private final Counter bytesUsed;
    DocFieldProcessorPerField next;
    int lastGen = -1;
    int fieldCount;
    IndexableField[] fields = new IndexableField[1];
    private final Map<FieldInfo, String> dvFields = new HashMap<FieldInfo, String>();

    public DocFieldProcessorPerField(DocFieldProcessor docFieldProcessor, FieldInfo fieldInfo) {
        this.consumer = docFieldProcessor.consumer.addField(fieldInfo);
        this.fieldInfo = fieldInfo;
        this.bytesUsed = docFieldProcessor.bytesUsed;
    }

    public void addField(IndexableField field) {
        if (this.fieldCount == this.fields.length) {
            int newSize = ArrayUtil.oversize(this.fieldCount + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            IndexableField[] newArray = new IndexableField[newSize];
            System.arraycopy(this.fields, 0, newArray, 0, this.fieldCount);
            this.fields = newArray;
        }
        this.fields[this.fieldCount++] = field;
    }

    public void abort() {
        this.consumer.abort();
    }
}

