/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public abstract class SorterTemplate {
    private static final int TIMSORT_MINRUN = 32;
    private static final int TIMSORT_THRESHOLD = 64;
    private static final int TIMSORT_STACKSIZE = 40;
    private static final int MERGESORT_THRESHOLD = 12;
    private static final int QUICKSORT_THRESHOLD = 7;

    protected abstract void swap(int var1, int var2);

    protected abstract int compare(int var1, int var2);

    protected abstract void setPivot(int var1);

    protected abstract int comparePivot(int var1);

    public final void insertionSort(int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            for (int j = i; j > lo && this.compare(j - 1, j) > 0; --j) {
                this.swap(j - 1, j);
            }
        }
    }

    public final void binarySort(int lo, int hi) {
        for (int i = lo + 1; i <= hi; ++i) {
            int l = lo;
            int h = i - 1;
            this.setPivot(i);
            while (l <= h) {
                int mid = l + h >>> 1;
                int cmp = this.comparePivot(mid);
                if (cmp < 0) {
                    h = mid - 1;
                    continue;
                }
                l = mid + 1;
            }
            for (int j = i; j > l; --j) {
                this.swap(j - 1, j);
            }
        }
    }

    public final void quickSort(int lo, int hi) {
        if (hi <= lo) {
            return;
        }
        this.quickSort(lo, hi, 32 - Integer.numberOfLeadingZeros(hi - lo) << 1);
    }

    private void quickSort(int lo, int hi, int maxDepth) {
        int diff = hi - lo;
        if (diff <= 7) {
            this.insertionSort(lo, hi);
            return;
        }
        if (--maxDepth == 0) {
            this.mergeSort(lo, hi);
            return;
        }
        int mid = lo + (diff >>> 1);
        if (this.compare(lo, mid) > 0) {
            this.swap(lo, mid);
        }
        if (this.compare(mid, hi) > 0) {
            this.swap(mid, hi);
            if (this.compare(lo, mid) > 0) {
                this.swap(lo, mid);
            }
        }
        int left = lo + 1;
        int right = hi - 1;
        this.setPivot(mid);
        while (true) {
            if (this.comparePivot(right) < 0) {
                --right;
                continue;
            }
            while (left < right && this.comparePivot(left) >= 0) {
                ++left;
            }
            if (left >= right) break;
            this.swap(left, right);
            --right;
        }
        this.quickSort(lo, left, maxDepth);
        this.quickSort(left + 1, hi, maxDepth);
    }

    public final void timSort(int lo, int hi) {
        if (hi - lo <= 64) {
            this.binarySort(lo, hi);
            return;
        }
        new TimSort(lo, hi).sort();
    }

    public final void mergeSort(int lo, int hi) {
        int diff = hi - lo;
        if (diff <= 12) {
            this.insertionSort(lo, hi);
            return;
        }
        int mid = lo + (diff >>> 1);
        this.mergeSort(lo, mid);
        this.mergeSort(mid, hi);
        this.runMerge(lo, mid, hi, mid - lo, hi - mid);
    }

    private void runMerge(int lo, int pivot, int hi, int len1, int len2) {
        if (len1 == 0 || len2 == 0) {
            return;
        }
        this.setPivot(pivot - 1);
        if (this.comparePivot(pivot) <= 0) {
            return;
        }
        while (this.comparePivot(hi - 1) <= 0) {
            --hi;
            --len2;
        }
        this.setPivot(pivot);
        while (this.comparePivot(lo) >= 0) {
            ++lo;
            --len1;
        }
        if (len1 + len2 == 2) {
            assert (len1 == len2);
            assert (this.compare(lo, pivot) > 0);
            this.swap(pivot, lo);
            return;
        }
        this.merge(lo, pivot, hi, len1, len2);
    }

    protected void merge(int lo, int pivot, int hi, int len1, int len2) {
        int len22;
        int second_cut;
        int first_cut;
        int len11;
        if (len1 > len2) {
            len11 = len1 >>> 1;
            first_cut = lo + len11;
            second_cut = this.lower(pivot, hi, first_cut);
            len22 = second_cut - pivot;
        } else {
            len22 = len2 >>> 1;
            second_cut = pivot + len22;
            first_cut = this.upper(lo, pivot, second_cut);
            len11 = first_cut - lo;
        }
        this.rotate(first_cut, pivot, second_cut);
        int new_mid = first_cut + len22;
        this.runMerge(lo, first_cut, new_mid, len11, len22);
        this.runMerge(new_mid, second_cut, hi, len1 - len11, len2 - len22);
    }

    private void rotate(int lo, int mid, int hi) {
        int lot = lo;
        int hit = mid - 1;
        while (lot < hit) {
            this.swap(lot++, hit--);
        }
        lot = mid;
        hit = hi - 1;
        while (lot < hit) {
            this.swap(lot++, hit--);
        }
        lot = lo;
        hit = hi - 1;
        while (lot < hit) {
            this.swap(lot++, hit--);
        }
    }

    private int lower(int lo, int hi, int val) {
        int len = hi - lo;
        while (len > 0) {
            int half = len >>> 1;
            int mid = lo + half;
            if (this.compare(mid, val) < 0) {
                lo = mid + 1;
                len = len - half - 1;
                continue;
            }
            len = half;
        }
        return lo;
    }

    private int upper(int lo, int hi, int val) {
        int len = hi - lo;
        while (len > 0) {
            int half = len >>> 1;
            int mid = lo + half;
            if (this.compare(val, mid) < 0) {
                len = half;
                continue;
            }
            lo = mid + 1;
            len = len - half - 1;
        }
        return lo;
    }

    static {
        long[] lengths = new long[40];
        lengths[0] = 32L;
        lengths[1] = lengths[0] + 1L;
        for (int i = 2; i < 40; ++i) {
            lengths[i] = lengths[i - 2] + lengths[i - 1] + 1L;
        }
        if (lengths[39] < Integer.MAX_VALUE) {
            throw new Error("TIMSORT_STACKSIZE is too small");
        }
    }

    private class TimSort {
        final int hi;
        final int minRun;
        final int[] runEnds;
        int stackSize;

        TimSort(int lo, int hi) {
            assert (hi > lo);
            this.runEnds = new int[41];
            this.runEnds[0] = lo;
            this.stackSize = 0;
            this.hi = hi;
            this.minRun = this.minRun(hi - lo + 1);
        }

        int minRun(int length) {
            int n;
            assert (length >= 32);
            int r = 0;
            for (n = length; n >= 64; n >>>= 1) {
                r |= n & 1;
            }
            int minRun = n + r;
            assert (minRun >= 32 && minRun <= 64);
            return minRun;
        }

        int runLen(int i) {
            int off = this.stackSize - i;
            return this.runEnds[off] - this.runEnds[off - 1];
        }

        int runBase(int i) {
            return this.runEnds[this.stackSize - i - 1];
        }

        int runEnd(int i) {
            return this.runEnds[this.stackSize - i];
        }

        void setRunEnd(int i, int runEnd) {
            this.runEnds[this.stackSize - i] = runEnd;
        }

        void pushRunLen(int len) {
            this.runEnds[this.stackSize + 1] = this.runEnds[this.stackSize] + len;
            ++this.stackSize;
        }

        void mergeAt(int i) {
            assert (this.stackSize > i + 1);
            int l = this.runBase(i + 1);
            int pivot = this.runBase(i);
            int h = this.runEnd(i);
            SorterTemplate.this.runMerge(l, pivot, h, pivot - l, h - pivot);
            for (int j = i + 1; j > 0; --j) {
                this.setRunEnd(j, this.runEnd(j - 1));
            }
            --this.stackSize;
        }

        int nextRun() {
            int runBase = this.runEnd(0);
            if (runBase == this.hi) {
                return 1;
            }
            int l = 1;
            if (SorterTemplate.this.compare(runBase, runBase + 1) > 0) {
                while (runBase + l <= this.hi && SorterTemplate.this.compare(runBase + l - 1, runBase + l) > 0) {
                    ++l;
                }
                if (l < this.minRun && runBase + l <= this.hi) {
                    l = Math.min(this.hi - runBase + 1, this.minRun);
                    SorterTemplate.this.binarySort(runBase, runBase + l - 1);
                } else {
                    int halfL = l >>> 1;
                    for (int i = 0; i < halfL; ++i) {
                        SorterTemplate.this.swap(runBase + i, runBase + l - i - 1);
                    }
                }
            } else {
                while (runBase + l <= this.hi && SorterTemplate.this.compare(runBase + l - 1, runBase + l) <= 0) {
                    ++l;
                }
                if (l < this.minRun && runBase + l <= this.hi) {
                    l = Math.min(this.hi - runBase + 1, this.minRun);
                    SorterTemplate.this.binarySort(runBase, runBase + l - 1);
                }
            }
            return l;
        }

        void ensureInvariants() {
            while (this.stackSize > 1) {
                int runLen2;
                int runLen0 = this.runLen(0);
                int runLen1 = this.runLen(1);
                if (this.stackSize > 2 && (runLen2 = this.runLen(2)) <= runLen1 + runLen0) {
                    if (runLen2 < runLen0) {
                        this.mergeAt(1);
                        continue;
                    }
                    this.mergeAt(0);
                    continue;
                }
                if (runLen1 > runLen0) break;
                this.mergeAt(0);
            }
        }

        void exhaustStack() {
            while (this.stackSize > 1) {
                this.mergeAt(0);
            }
        }

        void sort() {
            do {
                this.ensureInvariants();
                this.pushRunLen(this.nextRun());
            } while (this.runEnd(0) <= this.hi);
            this.exhaustStack();
            assert (this.runEnd(0) == this.hi + 1);
        }
    }
}

