/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jets3t.service.Jets3tProperties;
import org.jets3t.service.S3ObjectsChunk;
import org.jets3t.service.S3ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.acl.GrantAndPermission;
import org.jets3t.service.acl.GroupGrantee;
import org.jets3t.service.acl.Permission;
import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.model.S3BucketLoggingStatus;
import org.jets3t.service.model.S3Object;
import org.jets3t.service.security.AWSCredentials;
import org.jets3t.service.utils.RestUtils;
import org.jets3t.service.utils.ServiceUtils;

public abstract class S3Service
implements Serializable {
    private static final Log log = LogFactory.getLog((Class)S3Service.class);
    public static final String VERSION_NO__JETS3T_TOOLKIT = "0.5.0";
    private AWSCredentials awsCredentials = null;
    private String invokingApplicationDescription = null;
    private boolean isHttpsOnly = true;
    private int internalErrorRetryMax = 5;

    protected S3Service(AWSCredentials awsCredentials, String invokingApplicationDescription) throws S3ServiceException {
        this.awsCredentials = awsCredentials;
        this.invokingApplicationDescription = invokingApplicationDescription;
        this.isHttpsOnly = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("s3service.https-only", true);
        this.internalErrorRetryMax = Jets3tProperties.getInstance("jets3t.properties").getIntProperty("s3service.internal-error-retry-max", 5);
        System.setProperty("networkaddress.cache.ttl", "300");
    }

    protected S3Service(AWSCredentials awsCredentials) throws S3ServiceException {
        this(awsCredentials, null);
    }

    public boolean isAuthenticatedConnection() {
        return this.awsCredentials != null;
    }

    public boolean isHttpsOnly() {
        return this.isHttpsOnly;
    }

    public int getInternalErrorRetryMax() {
        return this.internalErrorRetryMax;
    }

    public static String getS3EndpointHost() {
        return Jets3tProperties.getInstance("jets3t.properties").getStringProperty("s3service.end-point-host", "s3.amazonaws.com");
    }

    public static void setS3EndpointHost(String endpointHost) {
        Jets3tProperties.getInstance("jets3t.properties").setProperty("s3service.end-point-host", endpointHost);
    }

    protected void sleepOnInternalError(int internalErrorCount) throws S3ServiceException, InterruptedException {
        if (internalErrorCount > this.internalErrorRetryMax) {
            throw new S3ServiceException("Encountered too many S3 Internal Server errors (" + internalErrorCount + "), aborting request.");
        }
        long delayMs = 50L * (long)((int)Math.pow(internalErrorCount, 2.0));
        log.warn((Object)("Encountered " + internalErrorCount + " S3 Internal Server error(s), will retry in " + delayMs + "ms"));
        Thread.sleep(delayMs);
    }

    public AWSCredentials getAWSCredentials() {
        return this.awsCredentials;
    }

    public String getInvokingApplicationDescription() {
        return this.invokingApplicationDescription;
    }

    public static String createSignedUrl(String method, String bucketName, String objectKey, Map headersMap, AWSCredentials awsCredentials, long secondsSinceEpoch) throws S3ServiceException {
        String fullKey = bucketName + (objectKey != null ? "/" + RestUtils.encodeUrlPath(objectKey, "/") : "");
        fullKey = fullKey + "?AWSAccessKeyId=" + awsCredentials.getAccessKey();
        fullKey = fullKey + "&Expires=" + secondsSinceEpoch;
        String canonicalString = RestUtils.makeCanonicalString(method, "/" + fullKey, RestUtils.renameMetadataKeys(headersMap), String.valueOf(secondsSinceEpoch));
        log.debug((Object)("Signing canonical string:\n" + canonicalString));
        String signedCanonical = ServiceUtils.signWithHmacSha1(awsCredentials.getSecretKey(), canonicalString);
        String encodedCanonical = RestUtils.encodeUrlString(signedCanonical);
        fullKey = fullKey + "&Signature=" + encodedCanonical;
        boolean isHttpsOnly = Jets3tProperties.getInstance("jets3t.properties").getBoolProperty("s3service.https-only", true);
        if (isHttpsOnly) {
            return "https://" + S3Service.getS3EndpointHost() + "/" + fullKey;
        }
        return "http://" + S3Service.getS3EndpointHost() + "/" + fullKey;
    }

    public static String createSignedGetUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("GET", bucketName, objectKey, null, awsCredentials, secondsSinceEpoch);
    }

    public static String createSignedPutUrl(String bucketName, String objectKey, Map headersMap, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("PUT", bucketName, objectKey, headersMap, awsCredentials, secondsSinceEpoch);
    }

    public static String createSignedDeleteUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("DELETE", bucketName, objectKey, null, awsCredentials, secondsSinceEpoch);
    }

    public static String createSignedHeadUrl(String bucketName, String objectKey, AWSCredentials awsCredentials, Date expiryTime) throws S3ServiceException {
        long secondsSinceEpoch = expiryTime.getTime() / 1000L;
        return S3Service.createSignedUrl("HEAD", bucketName, objectKey, null, awsCredentials, secondsSinceEpoch);
    }

    public static String createTorrentUrl(String bucketName, String objectKey) {
        return "http://" + S3Service.getS3EndpointHost() + "/" + bucketName + "/" + objectKey + "?torrent";
    }

    protected void assertAuthenticatedConnection(String action) throws S3ServiceException {
        if (!this.isAuthenticatedConnection()) {
            throw new S3ServiceException("The requested action cannot be performed with a non-authenticated S3 Service: " + action);
        }
    }

    protected void assertValidBucket(S3Bucket bucket, String action) throws S3ServiceException {
        if (bucket == null || bucket.getName() == null || bucket.getName().length() == 0) {
            throw new S3ServiceException("The action " + action + " cannot be performed with an invalid bucket: " + bucket);
        }
    }

    protected void assertValidObject(S3Object object, String action) throws S3ServiceException {
        if (object == null || object.getKey() == null || object.getKey().length() == 0) {
            throw new S3ServiceException("The action " + action + " cannot be performed with an invalid object: " + object);
        }
    }

    public S3Object[] listObjects(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "listObjects");
        return this.listObjects(bucket, null, null, 1000L);
    }

    public S3Object[] listObjects(S3Bucket bucket, String prefix, String delimiter) throws S3ServiceException {
        this.assertValidBucket(bucket, "listObjects");
        return this.listObjects(bucket, prefix, delimiter, 1000L);
    }

    public S3Bucket createBucket(String bucketName) throws S3ServiceException {
        this.assertAuthenticatedConnection("createBucket");
        if (this.isBucketAccessible(bucketName)) {
            log.debug((Object)("Bucket with name '" + bucketName + "' already exists, it will not be created"));
            return new S3Bucket(bucketName);
        }
        S3Bucket bucket = new S3Bucket();
        bucket.setName(bucketName);
        return this.createBucket(bucket);
    }

    public S3Object getObject(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "getObject");
        return this.getObject(bucket, objectKey, null, null, null, null, null, null);
    }

    public S3Object getObjectDetails(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "getObjectDetails");
        return this.getObjectDetails(bucket, objectKey, null, null, null, null);
    }

    public S3Bucket[] listAllBuckets() throws S3ServiceException {
        this.assertAuthenticatedConnection("List all buckets");
        return this.listAllBucketsImpl();
    }

    public S3Object[] listObjects(S3Bucket bucket, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        this.assertValidBucket(bucket, "List objects in bucket");
        return this.listObjects(bucket.getName(), prefix, delimiter, maxListingLength);
    }

    public S3Object[] listObjects(String bucketName, String prefix, String delimiter, long maxListingLength) throws S3ServiceException {
        return this.listObjectsImpl(bucketName, prefix, delimiter, maxListingLength);
    }

    public S3ObjectsChunk listObjectsChunked(String bucketName, String prefix, String delimiter, long maxListingLength, String priorLastKey) throws S3ServiceException {
        return this.listObjectsChunkedImpl(bucketName, prefix, delimiter, maxListingLength, priorLastKey);
    }

    public S3Bucket createBucket(S3Bucket bucket) throws S3ServiceException {
        this.assertAuthenticatedConnection("Create Bucket");
        this.assertValidBucket(bucket, "Create Bucket");
        return this.createBucketImpl(bucket.getName(), bucket.getAcl());
    }

    public void deleteBucket(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "Delete bucket");
        this.deleteBucketImpl(bucket.getName());
    }

    public void deleteBucket(String bucketName) throws S3ServiceException {
        this.deleteBucketImpl(bucketName);
    }

    public S3Object putObject(String bucketName, S3Object object) throws S3ServiceException {
        this.assertValidObject(object, "Create Object in bucket " + bucketName);
        return this.putObjectImpl(bucketName, object);
    }

    public S3Object putObject(S3Bucket bucket, S3Object object) throws S3ServiceException {
        this.assertValidBucket(bucket, "Create Object in bucket");
        return this.putObject(bucket.getName(), object);
    }

    public void deleteObject(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "deleteObject");
        this.deleteObject(bucket.getName(), objectKey);
    }

    public void deleteObject(String bucketName, String objectKey) throws S3ServiceException {
        this.deleteObjectImpl(bucketName, objectKey);
    }

    public S3Object getObjectDetails(S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Object Details");
        return this.getObjectDetailsImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public S3Object getObjectDetails(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags) throws S3ServiceException {
        return this.getObjectDetailsImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags);
    }

    public S3Object getObject(S3Bucket bucket, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Object");
        return this.getObjectImpl(bucket.getName(), objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    public S3Object getObject(String bucketName, String objectKey, Calendar ifModifiedSince, Calendar ifUnmodifiedSince, String[] ifMatchTags, String[] ifNoneMatchTags, Long byteRangeStart, Long byteRangeEnd) throws S3ServiceException {
        return this.getObjectImpl(bucketName, objectKey, ifModifiedSince, ifUnmodifiedSince, ifMatchTags, ifNoneMatchTags, byteRangeStart, byteRangeEnd);
    }

    public void putObjectAcl(S3Bucket bucket, S3Object object) throws S3ServiceException {
        this.assertValidBucket(bucket, "Put Object Access Control List");
        this.assertValidObject(object, "Put Object Access Control List");
        this.putObjectAcl(bucket.getName(), object.getKey(), object.getAcl());
    }

    public void putObjectAcl(String bucketName, String objectKey, AccessControlList acl) throws S3ServiceException {
        if (acl == null) {
            throw new S3ServiceException("The object '" + objectKey + "' does not include ACL information");
        }
        this.putObjectAclImpl(bucketName, objectKey, acl);
    }

    public void putBucketAcl(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "Put Bucket Access Control List");
        this.putBucketAcl(bucket.getName(), bucket.getAcl());
    }

    public void putBucketAcl(String bucketName, AccessControlList acl) throws S3ServiceException {
        if (acl == null) {
            throw new S3ServiceException("The bucket '" + bucketName + "' does not include ACL information");
        }
        this.putBucketAclImpl(bucketName, acl);
    }

    public AccessControlList getObjectAcl(S3Bucket bucket, String objectKey) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Object Access Control List");
        return this.getObjectAclImpl(bucket.getName(), objectKey);
    }

    public AccessControlList getObjectAcl(String bucketName, String objectKey) throws S3ServiceException {
        return this.getObjectAclImpl(bucketName, objectKey);
    }

    public AccessControlList getBucketAcl(S3Bucket bucket) throws S3ServiceException {
        this.assertValidBucket(bucket, "Get Bucket Access Control List");
        return this.getBucketAclImpl(bucket.getName());
    }

    public AccessControlList getBucketAcl(String bucketName) throws S3ServiceException {
        return this.getBucketAclImpl(bucketName);
    }

    public S3BucketLoggingStatus getBucketLoggingStatus(String bucketName) throws S3ServiceException {
        return this.getBucketLoggingStatusImpl(bucketName);
    }

    public void setBucketLoggingStatus(String bucketName, S3BucketLoggingStatus status, boolean updateTargetACLifRequired) throws S3ServiceException {
        this.setBucketLoggingStatusImpl(bucketName, status);
        if (status.isLoggingEnabled() && updateTargetACLifRequired) {
            log.debug((Object)("Checking whether the target logging bucket '" + status.getTargetBucketName() + "' has the appropriate ACL settings"));
            boolean isSetLoggingGroupWrite = false;
            boolean isSetLoggingGroupReadACP = false;
            String groupIdentifier = GroupGrantee.LOG_DELIVERY.getIdentifier();
            AccessControlList logBucketACL = this.getBucketAcl(status.getTargetBucketName());
            Iterator grantIter = logBucketACL.getGrants().iterator();
            while (grantIter.hasNext()) {
                GrantAndPermission gap = (GrantAndPermission)grantIter.next();
                if (!groupIdentifier.equals(gap.getGrantee().getIdentifier())) continue;
                if (gap.getPermission().equals(Permission.PERMISSION_WRITE)) {
                    isSetLoggingGroupWrite = true;
                    log.debug((Object)("Target bucket '" + status.getTargetBucketName() + "' has ACL " + "permission " + Permission.PERMISSION_WRITE + " for group " + groupIdentifier));
                    continue;
                }
                if (!gap.getPermission().equals(Permission.PERMISSION_READ_ACP)) continue;
                isSetLoggingGroupReadACP = true;
                log.debug((Object)("Target bucket '" + status.getTargetBucketName() + "' has ACL " + "permission " + Permission.PERMISSION_READ_ACP + " for group " + groupIdentifier));
            }
            if (!isSetLoggingGroupWrite || !isSetLoggingGroupReadACP) {
                log.warn((Object)("Target logging bucket '" + status.getTargetBucketName() + "' does not have the necessary ACL settings, updating ACL now"));
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_WRITE);
                logBucketACL.grantPermission(GroupGrantee.LOG_DELIVERY, Permission.PERMISSION_READ_ACP);
                this.putBucketAcl(status.getTargetBucketName(), logBucketACL);
            } else {
                log.debug((Object)("Target logging bucket '" + status.getTargetBucketName() + "' has the necessary ACL settings"));
            }
        }
    }

    public abstract boolean isBucketAccessible(String var1) throws S3ServiceException;

    protected abstract S3BucketLoggingStatus getBucketLoggingStatusImpl(String var1) throws S3ServiceException;

    protected abstract void setBucketLoggingStatusImpl(String var1, S3BucketLoggingStatus var2) throws S3ServiceException;

    protected abstract S3Bucket[] listAllBucketsImpl() throws S3ServiceException;

    protected abstract S3Object[] listObjectsImpl(String var1, String var2, String var3, long var4) throws S3ServiceException;

    protected abstract S3ObjectsChunk listObjectsChunkedImpl(String var1, String var2, String var3, long var4, String var6) throws S3ServiceException;

    protected abstract S3Bucket createBucketImpl(String var1, AccessControlList var2) throws S3ServiceException;

    protected abstract void deleteBucketImpl(String var1) throws S3ServiceException;

    protected abstract S3Object putObjectImpl(String var1, S3Object var2) throws S3ServiceException;

    protected abstract void deleteObjectImpl(String var1, String var2) throws S3ServiceException;

    protected abstract S3Object getObjectDetailsImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6) throws S3ServiceException;

    protected abstract S3Object getObjectImpl(String var1, String var2, Calendar var3, Calendar var4, String[] var5, String[] var6, Long var7, Long var8) throws S3ServiceException;

    protected abstract void putBucketAclImpl(String var1, AccessControlList var2) throws S3ServiceException;

    protected abstract void putObjectAclImpl(String var1, String var2, AccessControlList var3) throws S3ServiceException;

    protected abstract AccessControlList getObjectAclImpl(String var1, String var2) throws S3ServiceException;

    protected abstract AccessControlList getBucketAclImpl(String var1) throws S3ServiceException;
}

