/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Bucket;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class CreateBucketsEvent
extends ServiceEvent {
    private S3Bucket[] buckets = null;

    private CreateBucketsEvent(int eventCode) {
        super(eventCode);
    }

    public static CreateBucketsEvent newErrorEvent(Throwable t) {
        CreateBucketsEvent event = new CreateBucketsEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static CreateBucketsEvent newStartedEvent(ThreadWatcher threadWatcher) {
        CreateBucketsEvent event = new CreateBucketsEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static CreateBucketsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Bucket[] completedBuckets) {
        CreateBucketsEvent event = new CreateBucketsEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setBuckets(completedBuckets);
        return event;
    }

    public static CreateBucketsEvent newCompletedEvent() {
        CreateBucketsEvent event = new CreateBucketsEvent(2);
        return event;
    }

    public static CreateBucketsEvent newCancelledEvent(S3Bucket[] incompletedBuckets) {
        CreateBucketsEvent event = new CreateBucketsEvent(4);
        event.setBuckets(incompletedBuckets);
        return event;
    }

    private void setBuckets(S3Bucket[] buckets) {
        this.buckets = buckets;
    }

    public S3Bucket[] getCreatedBuckets() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Created Buckets are only available from EVENT_IN_PROGRESS events");
        }
        return this.buckets;
    }

    public S3Bucket[] getCancelledBuckets() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Buckets are  only available from EVENT_CANCELLED events");
        }
        return this.buckets;
    }
}

