/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class DeleteObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private DeleteObjectsEvent(int eventCode) {
        super(eventCode);
    }

    public static DeleteObjectsEvent newErrorEvent(Throwable t) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static DeleteObjectsEvent newStartedEvent(ThreadWatcher threadWatcher) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static DeleteObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] deletedObjects) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(deletedObjects);
        return event;
    }

    public static DeleteObjectsEvent newCompletedEvent() {
        DeleteObjectsEvent event = new DeleteObjectsEvent(2);
        return event;
    }

    public static DeleteObjectsEvent newCancelledEvent(S3Object[] remainingObjects) {
        DeleteObjectsEvent event = new DeleteObjectsEvent(4);
        event.setObjects(remainingObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getDeletedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Deleted Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

