/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class DownloadObjectsEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private DownloadObjectsEvent(int eventCode) {
        super(eventCode);
    }

    public static DownloadObjectsEvent newErrorEvent(Throwable t) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static DownloadObjectsEvent newStartedEvent(ThreadWatcher threadWatcher) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static DownloadObjectsEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static DownloadObjectsEvent newCompletedEvent() {
        DownloadObjectsEvent event = new DownloadObjectsEvent(2);
        return event;
    }

    public static DownloadObjectsEvent newCancelledEvent(S3Object[] incompletedObjects) {
        DownloadObjectsEvent event = new DownloadObjectsEvent(4);
        event.setObjects(incompletedObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getDownloadedObjects() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Downloaded Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

