/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.service.multithread;

import org.jets3t.service.model.S3Object;
import org.jets3t.service.multithread.ServiceEvent;
import org.jets3t.service.multithread.ThreadWatcher;

public class UpdateACLEvent
extends ServiceEvent {
    private S3Object[] objects = null;

    private UpdateACLEvent(int eventCode) {
        super(eventCode);
    }

    public static UpdateACLEvent newErrorEvent(Throwable t) {
        UpdateACLEvent event = new UpdateACLEvent(0);
        event.setErrorCause(t);
        return event;
    }

    public static UpdateACLEvent newStartedEvent(ThreadWatcher threadWatcher) {
        UpdateACLEvent event = new UpdateACLEvent(1);
        event.setThreadWatcher(threadWatcher);
        return event;
    }

    public static UpdateACLEvent newInProgressEvent(ThreadWatcher threadWatcher, S3Object[] completedObjects) {
        UpdateACLEvent event = new UpdateACLEvent(3);
        event.setThreadWatcher(threadWatcher);
        event.setObjects(completedObjects);
        return event;
    }

    public static UpdateACLEvent newCompletedEvent() {
        UpdateACLEvent event = new UpdateACLEvent(2);
        return event;
    }

    public static UpdateACLEvent newCancelledEvent(S3Object[] incompletedObjects) {
        UpdateACLEvent event = new UpdateACLEvent(4);
        event.setObjects(incompletedObjects);
        return event;
    }

    private void setObjects(S3Object[] objects) {
        this.objects = objects;
    }

    public S3Object[] getObjectsWithUpdatedACL() throws IllegalStateException {
        if (this.getEventCode() != 3) {
            throw new IllegalStateException("Completed Objects are only available from EVENT_IN_PROGRESS events");
        }
        return this.objects;
    }

    public S3Object[] getCancelledObjects() throws IllegalStateException {
        if (this.getEventCode() != 4) {
            throw new IllegalStateException("Cancelled Objects are  only available from EVENT_CANCELLED events");
        }
        return this.objects;
    }
}

