/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class ExtendedProperties
extends Hashtable {
    private ExtendedProperties defaults;
    protected String file;
    protected String basePath;
    protected String fileSeparator = System.getProperty("file.separator");
    protected boolean isInitialized = false;
    protected static String include = "include";
    protected ArrayList keysAsListed = new ArrayList();
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    protected String interpolate(String string) {
        if (string == null) {
            return null;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0 - END_TOKEN.length();
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        while ((n = string.indexOf(START_TOKEN, n3 + END_TOKEN.length())) > -1 && (n2 = string.indexOf(END_TOKEN, n)) > -1) {
            stringBuffer.append(string.substring(n3 + END_TOKEN.length(), n));
            string2 = string.substring(n + START_TOKEN.length(), n2);
            if (this.get(string2) != null) {
                stringBuffer.append(this.get(string2));
            }
            n3 = n2;
        }
        stringBuffer.append(string.substring(n3 + END_TOKEN.length(), string.length()));
        return stringBuffer.toString();
    }

    public ExtendedProperties() {
    }

    public ExtendedProperties(String string) throws IOException {
        this(string, null);
    }

    public ExtendedProperties(String string, String string2) throws IOException {
        this.file = string;
        this.basePath = new File(string).getAbsolutePath();
        this.basePath = this.basePath.substring(0, this.basePath.lastIndexOf(this.fileSeparator) + 1);
        this.load(new FileInputStream(string));
        if (string2 != null) {
            this.defaults = new ExtendedProperties(string2);
        }
    }

    private void init(ExtendedProperties extendedProperties) throws IOException {
        this.isInitialized = true;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public String getInclude() {
        return include;
    }

    public void setInclude(String string) {
        include = string;
    }

    public void load(InputStream inputStream) throws IOException {
        this.load(inputStream, null);
    }

    public synchronized void load(InputStream inputStream, String string) throws IOException {
        PropertiesReader propertiesReader = null;
        if (string != null) {
            try {
                propertiesReader = new PropertiesReader(new InputStreamReader(inputStream, string));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        if (propertiesReader == null) {
            propertiesReader = new PropertiesReader(new InputStreamReader(inputStream));
        }
        try {
            while (true) {
                String string2;
                int n;
                if ((n = (string2 = propertiesReader.readProperty()).indexOf(61)) <= 0) {
                    continue;
                }
                String string3 = string2.substring(0, n).trim();
                String string4 = string2.substring(n + 1).trim();
                if ("".equals(string4)) continue;
                if (this.getInclude() != null && string3.equalsIgnoreCase(this.getInclude())) {
                    File file = null;
                    if (string4.startsWith(this.fileSeparator)) {
                        file = new File(string4);
                    } else {
                        if (string4.startsWith("." + this.fileSeparator)) {
                            string4 = string4.substring(2);
                        }
                        file = new File(String.valueOf(this.basePath) + string4);
                    }
                    if (file == null || !file.exists() || !file.canRead()) continue;
                    this.load(new FileInputStream(file));
                    continue;
                }
                this.addProperty(string3, string4);
            }
        }
        catch (NullPointerException nullPointerException) {
            return;
        }
    }

    public Object getProperty(String string) {
        Object v = this.get(string);
        if (v == null && this.defaults != null) {
            v = this.defaults.get(string);
        }
        return v;
    }

    public void addProperty(String string, Object object) {
        Object v = this.get(string);
        if (v instanceof String) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.addElement(v);
            vector.addElement(object);
            this.put(string, vector);
        } else if (v instanceof Vector) {
            ((Vector)v).addElement(object);
        } else if (object instanceof String && ((String)object).indexOf(",") > 0) {
            PropertiesTokenizer propertiesTokenizer = new PropertiesTokenizer((String)object);
            while (propertiesTokenizer.hasMoreTokens()) {
                String string2 = propertiesTokenizer.nextToken();
                this.addStringProperty(string, string2);
            }
        } else {
            this.addPropertyDirect(string, object);
        }
    }

    private void addPropertyDirect(String string, Object object) {
        if (!this.containsKey(string)) {
            this.keysAsListed.add(string);
        }
        this.put(string, object);
    }

    private void addStringProperty(String string, String string2) {
        Object v = this.get(string);
        if (v instanceof String) {
            Vector<Object> vector = new Vector<Object>(2);
            vector.addElement(v);
            vector.addElement(string2);
            this.put(string, vector);
        } else if (v instanceof Vector) {
            ((Vector)v).addElement(string2);
        } else {
            this.addPropertyDirect(string, string2);
        }
    }

    public void setProperty(String string, Object object) {
        this.clearProperty(string);
        this.addProperty(string, object);
    }

    public synchronized void save(OutputStream outputStream, String string) throws IOException {
        if (outputStream != null) {
            PrintWriter printWriter = new PrintWriter(outputStream);
            if (string != null) {
                printWriter.println(string);
            }
            Enumeration enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                Object v = this.get(string2);
                if (v != null) {
                    Serializable serializable;
                    if (v instanceof String) {
                        serializable = new StringBuffer();
                        ((StringBuffer)serializable).append(string2);
                        ((StringBuffer)serializable).append("=");
                        ((StringBuffer)serializable).append((String)v);
                        printWriter.println(((StringBuffer)serializable).toString());
                    } else if (v instanceof Vector) {
                        serializable = (Vector)v;
                        Enumeration enumeration2 = ((Vector)serializable).elements();
                        while (enumeration2.hasMoreElements()) {
                            String string3 = (String)enumeration2.nextElement();
                            StringBuffer stringBuffer = new StringBuffer();
                            stringBuffer.append(string2);
                            stringBuffer.append("=");
                            stringBuffer.append(string3);
                            printWriter.println(stringBuffer.toString());
                        }
                    }
                }
                printWriter.println();
                printWriter.flush();
            }
        }
    }

    public void combine(ExtendedProperties extendedProperties) {
        Iterator iterator = extendedProperties.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.setProperty(string, extendedProperties.get(string));
        }
    }

    public void clearProperty(String string) {
        if (this.containsKey(string)) {
            int n = 0;
            while (n < this.keysAsListed.size()) {
                if (((String)this.keysAsListed.get(n)).equals(string)) {
                    this.keysAsListed.remove(n);
                    break;
                }
                ++n;
            }
            this.remove(string);
        }
    }

    public Iterator getKeys() {
        return this.keysAsListed.iterator();
    }

    public Iterator getKeys(String string) {
        Iterator iterator = this.getKeys();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String) || !((String)e).startsWith(string)) continue;
            arrayList.add(e);
        }
        return arrayList.iterator();
    }

    public ExtendedProperties subset(String string) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Iterator iterator = this.getKeys();
        boolean bl = false;
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof String) || !((String)e).startsWith(string)) continue;
            if (!bl) {
                bl = true;
            }
            String string2 = null;
            string2 = ((String)e).length() == string.length() ? string : ((String)e).substring(string.length() + 1);
            extendedProperties.addPropertyDirect(string2, this.get(e));
        }
        if (bl) {
            return extendedProperties;
        }
        return null;
    }

    public void display() {
        Iterator iterator = this.getKeys();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Object v = this.get(string);
            System.out.println(String.valueOf(string) + " => " + v);
        }
    }

    public String getString(String string) {
        return this.getString(string, null);
    }

    public String getString(String string, String string2) {
        Object v = this.get(string);
        if (v instanceof String) {
            return this.interpolate((String)v);
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.interpolate(this.defaults.getString(string, string2));
            }
            return this.interpolate(string2);
        }
        if (v instanceof Vector) {
            return this.interpolate((String)((Vector)v).get(0));
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a String object");
    }

    public Properties getProperties(String string) {
        return this.getProperties(string, new Properties());
    }

    public Properties getProperties(String string, Properties properties) {
        String[] stringArray = this.getStringArray(string);
        Properties properties2 = new Properties(properties);
        int n = 0;
        while (n < stringArray.length) {
            String string2 = stringArray[n];
            int n2 = string2.indexOf(61);
            if (n2 <= 0) {
                throw new IllegalArgumentException(String.valueOf('\'') + string2 + "' does not contain " + "an equals sign");
            }
            String string3 = string2.substring(0, n2).trim();
            String string4 = string2.substring(n2 + 1).trim();
            properties2.put(string3, string4);
            ++n;
        }
        return properties2;
    }

    public String[] getStringArray(String string) {
        Vector vector;
        Object v = this.get(string);
        if (v instanceof String) {
            vector = new Vector(1);
            vector.addElement(v);
        } else if (v instanceof Vector) {
            vector = (Vector)v;
        } else {
            if (v == null) {
                if (this.defaults != null) {
                    return this.defaults.getStringArray(string);
                }
                return new String[0];
            }
            throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a String/Vector object");
        }
        String[] stringArray = new String[vector.size()];
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = (String)vector.elementAt(n);
            ++n;
        }
        return stringArray;
    }

    public Vector getVector(String string) {
        return this.getVector(string, null);
    }

    public Vector getVector(String string, Vector vector) {
        Object v = this.get(string);
        if (v instanceof Vector) {
            return (Vector)v;
        }
        if (v instanceof String) {
            Vector<String> vector2 = new Vector<String>(1);
            vector2.addElement((String)v);
            this.put(string, vector2);
            return vector2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getVector(string, vector);
            }
            return vector == null ? new Vector() : vector;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Vector object");
    }

    public boolean getBoolean(String string) {
        Boolean bl = this.getBoolean(string, null);
        if (bl != null) {
            return bl;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public boolean getBoolean(String string, boolean bl) {
        return this.getBoolean(string, new Boolean(bl));
    }

    public Boolean getBoolean(String string, Boolean bl) {
        Object v = this.get(string);
        if (v instanceof Boolean) {
            return (Boolean)v;
        }
        if (v instanceof String) {
            String string2 = this.testBoolean((String)v);
            Boolean bl2 = new Boolean(string2);
            this.put(string, bl2);
            return bl2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(string, bl);
            }
            return bl;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Boolean object");
    }

    public String testBoolean(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("true") || string2.equals("on") || string2.equals("yes")) {
            return "true";
        }
        if (string2.equals("false") || string2.equals("off") || string2.equals("no")) {
            return "false";
        }
        return null;
    }

    public byte getByte(String string) {
        Byte by = this.getByte(string, null);
        if (by != null) {
            return by;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + " doesn't map to an existing object");
    }

    public byte getByte(String string, byte by) {
        return this.getByte(string, new Byte(by));
    }

    public Byte getByte(String string, Byte by) {
        Object v = this.get(string);
        if (v instanceof Byte) {
            return (Byte)v;
        }
        if (v instanceof String) {
            Byte by2 = new Byte((String)v);
            this.put(string, by2);
            return by2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(string, by);
            }
            return by;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Byte object");
    }

    public short getShort(String string) {
        Short s = this.getShort(string, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public short getShort(String string, short s) {
        return this.getShort(string, new Short(s));
    }

    public Short getShort(String string, Short s) {
        Object v = this.get(string);
        if (v instanceof Short) {
            return (Short)v;
        }
        if (v instanceof String) {
            Short s2 = new Short((String)v);
            this.put(string, s2);
            return s2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(string, s);
            }
            return s;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Short object");
    }

    public int getInt(String string) {
        return this.getInteger(string);
    }

    public int getInt(String string, int n) {
        return this.getInteger(string, n);
    }

    public int getInteger(String string) {
        Integer n = this.getInteger(string, null);
        if (n != null) {
            return n;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public int getInteger(String string, int n) {
        Integer n2 = this.getInteger(string, null);
        if (n2 == null) {
            return n;
        }
        return n2;
    }

    public Integer getInteger(String string, Integer n) {
        Object v = this.get(string);
        if (v instanceof Integer) {
            return (Integer)v;
        }
        if (v instanceof String) {
            Integer n2 = new Integer((String)v);
            this.put(string, n2);
            return n2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(string, n);
            }
            return n;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Integer object");
    }

    public long getLong(String string) {
        Long l = this.getLong(string, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public long getLong(String string, long l) {
        return this.getLong(string, new Long(l));
    }

    public Long getLong(String string, Long l) {
        Object v = this.get(string);
        if (v instanceof Long) {
            return (Long)v;
        }
        if (v instanceof String) {
            Long l2 = new Long((String)v);
            this.put(string, l2);
            return l2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(string, l);
            }
            return l;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Long object");
    }

    public float getFloat(String string) {
        Float f = this.getFloat(string, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public float getFloat(String string, float f) {
        return this.getFloat(string, new Float(f)).floatValue();
    }

    public Float getFloat(String string, Float f) {
        Object v = this.get(string);
        if (v instanceof Float) {
            return (Float)v;
        }
        if (v instanceof String) {
            Float f2 = new Float((String)v);
            this.put(string, f2);
            return f2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(string, f);
            }
            return f;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Float object");
    }

    public double getDouble(String string) {
        Double d = this.getDouble(string, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException(String.valueOf('\'') + string + "' doesn't map to an existing object");
    }

    public double getDouble(String string, double d) {
        return this.getDouble(string, new Double(d));
    }

    public Double getDouble(String string, Double d) {
        Object v = this.get(string);
        if (v instanceof Double) {
            return (Double)v;
        }
        if (v instanceof String) {
            Double d2 = new Double((String)v);
            this.put(string, d2);
            return d2;
        }
        if (v == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(string, d);
            }
            return d;
        }
        throw new ClassCastException(String.valueOf('\'') + string + "' doesn't map to a Double object");
    }

    public static ExtendedProperties convertProperties(Properties properties) {
        ExtendedProperties extendedProperties = new ExtendedProperties();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            extendedProperties.setProperty(string, properties.getProperty(string));
        }
        return extendedProperties;
    }

    class PropertiesReader
    extends LineNumberReader {
        public PropertiesReader(Reader reader) {
            super(reader);
        }

        public String readProperty() throws IOException {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                String string;
                while (true) {
                    if ((string = this.readLine().trim()).length() == 0 || string.charAt(0) == '#') {
                        continue;
                    }
                    if (!string.endsWith("\\")) break;
                    string = string.substring(0, string.length() - 1);
                    stringBuffer.append(string);
                }
                stringBuffer.append(string);
            }
            catch (NullPointerException nullPointerException) {
                return null;
            }
            return stringBuffer.toString();
        }
    }

    class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string) {
            super(string, DELIMITER);
        }

        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        public String nextToken() {
            StringBuffer stringBuffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String string = super.nextToken();
                if (string.endsWith("\\")) {
                    stringBuffer.append(string.substring(0, string.length() - 1));
                    stringBuffer.append(DELIMITER);
                    continue;
                }
                stringBuffer.append(string);
                break;
            }
            return stringBuffer.toString().trim();
        }
    }
}

