/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.collection;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.nutch.collection.Subcollection;
import org.apache.nutch.util.DomUtil;
import org.apache.nutch.util.NutchConfiguration;
import org.apache.nutch.util.ObjectCache;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CollectionManager
extends Configured {
    public static final String DEFAULT_FILE_NAME = "subcollections.xml";
    static final Logger LOG = LoggerFactory.getLogger(CollectionManager.class);
    transient Map<String, Subcollection> collectionMap = new HashMap<String, Subcollection>();
    transient URL configfile;

    public CollectionManager(Configuration conf) {
        super(conf);
        this.init();
    }

    protected CollectionManager() {
        super(NutchConfiguration.create());
    }

    protected void init() {
        block3: {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("initializing CollectionManager");
                }
                this.configfile = this.getConf().getResource(this.getConf().get("subcollections.config", DEFAULT_FILE_NAME));
                InputStream input = this.getConf().getConfResourceAsInputStream(this.getConf().get("subcollections.config", DEFAULT_FILE_NAME));
                this.parse(input);
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn("Error occured:" + e);
            }
        }
    }

    protected void parse(InputStream input) {
        Element collections = DomUtil.getDom((InputStream)input);
        if (collections != null) {
            NodeList nodeList = collections.getElementsByTagName("subcollection");
            if (LOG.isInfoEnabled()) {
                LOG.info("file has " + nodeList.getLength() + " elements");
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element scElem = (Element)nodeList.item(i);
                Subcollection subCol = new Subcollection(this.getConf());
                subCol.initialize(scElem);
                this.collectionMap.put(subCol.name, subCol);
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info("Cannot find collections");
        }
    }

    public static CollectionManager getCollectionManager(Configuration conf) {
        String key = "collectionmanager";
        ObjectCache objectCache = ObjectCache.get((Configuration)conf);
        CollectionManager impl = (CollectionManager)((Object)objectCache.getObject(key));
        if (impl == null) {
            try {
                if (LOG.isInfoEnabled()) {
                    LOG.info("Instantiating CollectionManager");
                }
                impl = new CollectionManager(conf);
                objectCache.setObject(key, (Object)impl);
            }
            catch (Exception e) {
                throw new RuntimeException("Couldn't create CollectionManager", e);
            }
        }
        return impl;
    }

    public Subcollection getSubColection(String id) {
        return this.collectionMap.get(id);
    }

    public void deleteSubCollection(String id) throws IOException {
        Subcollection subCol = this.getSubColection(id);
        if (subCol != null) {
            this.collectionMap.remove(id);
        }
    }

    public Subcollection createSubCollection(String id, String name) {
        Subcollection subCol = null;
        if (!this.collectionMap.containsKey(id)) {
            subCol = new Subcollection(id, name, this.getConf());
            this.collectionMap.put(id, subCol);
        }
        return subCol;
    }

    public List<Subcollection> getSubCollections(String url) {
        ArrayList<Subcollection> collections = new ArrayList<Subcollection>();
        for (Subcollection subCol : this.collectionMap.values()) {
            if (subCol.filter(url) == null) continue;
            collections.add(subCol);
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("subcollections:" + Arrays.toString(collections.toArray()));
        }
        return collections;
    }

    public Collection getAll() {
        return this.collectionMap.values();
    }

    public void save() throws IOException {
        try {
            FileOutputStream fos = new FileOutputStream(new File(this.configfile.getFile()));
            DocumentImpl doc = new DocumentImpl();
            Element collections = doc.createElement("subcollections");
            for (Subcollection subCol : this.collectionMap.values()) {
                Element collection = doc.createElement("subcollection");
                collections.appendChild(collection);
                Element name = doc.createElement("name");
                name.setNodeValue(subCol.getName());
                collection.appendChild(name);
                Element whiteList = doc.createElement("whitelist");
                whiteList.setNodeValue(subCol.getWhiteListString());
                collection.appendChild(whiteList);
                Element blackList = doc.createElement("blacklist");
                blackList.setNodeValue(subCol.getBlackListString());
                collection.appendChild(blackList);
            }
            DomUtil.saveDom((OutputStream)fos, (Element)collections);
            fos.flush();
            fos.close();
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.toString());
        }
    }
}

