/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.collection;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.nutch.net.URLFilter;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Subcollection
extends Configured
implements URLFilter {
    public static final String TAG_COLLECTIONS = "subcollections";
    public static final String TAG_COLLECTION = "subcollection";
    public static final String TAG_WHITELIST = "whitelist";
    public static final String TAG_BLACKLIST = "blacklist";
    public static final String TAG_NAME = "name";
    public static final String TAG_KEY = "key";
    public static final String TAG_ID = "id";
    List<String> blackList = new ArrayList<String>();
    List<String> whiteList = new ArrayList<String>();
    String id;
    String key;
    String name;
    String wlString;
    String blString;

    public Subcollection(String id, String name, Configuration conf) {
        this(id, name, null, conf);
    }

    public Subcollection(String id, String name, String key, Configuration conf) {
        this(conf);
        this.id = id;
        this.key = key;
        this.name = name;
    }

    public Subcollection(Configuration conf) {
        super(conf);
    }

    public String getName() {
        return this.name;
    }

    public String getKey() {
        return this.key;
    }

    public String getId() {
        return this.id;
    }

    public List<String> getWhiteList() {
        return this.whiteList;
    }

    public String getWhiteListString() {
        return this.wlString;
    }

    public String getBlackListString() {
        return this.blString;
    }

    public void setWhiteList(ArrayList<String> whiteList) {
        this.whiteList = whiteList;
    }

    public String filter(String urlString) {
        for (String row : this.blackList) {
            if (!urlString.contains(row)) continue;
            return null;
        }
        for (String row : this.whiteList) {
            if (!urlString.contains(row)) continue;
            return urlString;
        }
        return null;
    }

    public void initialize(Element collection) {
        this.id = DOMUtil.getChildText((Node)collection.getElementsByTagName(TAG_ID).item(0)).trim();
        this.name = DOMUtil.getChildText((Node)collection.getElementsByTagName(TAG_NAME).item(0)).trim();
        this.wlString = DOMUtil.getChildText((Node)collection.getElementsByTagName(TAG_WHITELIST).item(0)).trim();
        this.parseList(this.whiteList, this.wlString);
        NodeList nodeList = collection.getElementsByTagName(TAG_BLACKLIST);
        if (nodeList.getLength() > 0) {
            this.blString = DOMUtil.getChildText((Node)nodeList.item(0)).trim();
            this.parseList(this.blackList, this.blString);
        }
        if ((nodeList = collection.getElementsByTagName(TAG_KEY)).getLength() == 1) {
            this.key = DOMUtil.getChildText((Node)nodeList.item(0)).trim();
        }
    }

    protected void parseList(List<String> list, String text) {
        list.clear();
        StringTokenizer st = new StringTokenizer(text, "\n\r");
        while (st.hasMoreElements()) {
            String line = (String)st.nextElement();
            list.add(line.trim());
        }
    }

    public void setBlackList(String list) {
        this.blString = list;
        this.parseList(this.blackList, list);
    }

    public void setWhiteList(String list) {
        this.wlString = list;
        this.parseList(this.whiteList, list);
    }
}

