/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nutch.indexer.subcollection;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.conf.Configured;
import org.apache.hadoop.io.Text;
import org.apache.nutch.collection.CollectionManager;
import org.apache.nutch.collection.Subcollection;
import org.apache.nutch.crawl.CrawlDatum;
import org.apache.nutch.crawl.Inlinks;
import org.apache.nutch.indexer.IndexingException;
import org.apache.nutch.indexer.IndexingFilter;
import org.apache.nutch.indexer.NutchDocument;
import org.apache.nutch.parse.Parse;
import org.apache.nutch.util.NutchConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubcollectionIndexingFilter
extends Configured
implements IndexingFilter {
    private Configuration conf;
    public static String fieldName = "subcollection";
    public static final Logger LOG = LoggerFactory.getLogger(SubcollectionIndexingFilter.class);

    public SubcollectionIndexingFilter() {
        super(NutchConfiguration.create());
    }

    public SubcollectionIndexingFilter(Configuration conf) {
        super(conf);
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        fieldName = conf.get("subcollection.default.fieldname", "subcollection");
    }

    public Configuration getConf() {
        return this.conf;
    }

    private void addSubCollectionField(NutchDocument doc, String url) {
        for (Subcollection coll : CollectionManager.getCollectionManager(this.getConf()).getSubCollections(url)) {
            if (coll.getKey() == null) {
                doc.add(fieldName, (Object)coll.getName());
                continue;
            }
            doc.add(coll.getKey(), (Object)coll.getName());
        }
    }

    public NutchDocument filter(NutchDocument doc, Parse parse, Text url, CrawlDatum datum, Inlinks inlinks) throws IndexingException {
        String sUrl = url.toString();
        this.addSubCollectionField(doc, sUrl);
        return doc;
    }
}

